/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.shapedata;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.shapedata.ContainerShapedata;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.data.RelativeShape;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileShapedata
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    private static final int SLOT_A = 0;
    private static final int SLOT_B = 1;
    private static final int SLOT_CARD = 2;
    ItemStackHandler inventory = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0 || slot == 1) {
                return stack.func_77973_b() instanceof LocationGpsCard;
            }
            return stack.func_77973_b() instanceof ShapeCard;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private RelativeShape copiedShape;
    private int hasStashIfOne;

    public void execute(StructCommands cmd) {
        ItemStack shapeCard = this.inventory.getStackInSlot(2);
        if (!(shapeCard.func_77973_b() instanceof ShapeCard)) {
            return;
        }
        RelativeShape cardShape = RelativeShape.read(shapeCard);
        switch (cmd) {
            case READ: {
                BlockPos invA = this.getTarget(0);
                BlockPos invB = this.getTarget(1);
                if (invA == null || invB == null) break;
                List<BlockPos> shape = UtilShape.rect(invA, invB);
                RelativeShape worldShape = new RelativeShape(this.field_145850_b, shape, this.field_174879_c);
                worldShape.write(shapeCard);
                ModCyclic.LOGGER.info((Object)((Object)cmd) + " success");
                break;
            }
            case COPY: {
                this.copiedShape = new RelativeShape(cardShape);
                ModCyclic.LOGGER.info((Object)((Object)cmd) + " success");
                break;
            }
            case PASTE: {
                if (this.copiedShape == null || shapeCard.func_77978_p() == null) break;
                shapeCard.func_77982_d(null);
                this.copiedShape.write(shapeCard);
                ModCyclic.LOGGER.info((Object)((Object)cmd) + " success");
                break;
            }
            case MERGE: {
                if (this.copiedShape == null || cardShape.getShape().size() <= 0) break;
                cardShape.merge(this.copiedShape);
                cardShape.write(shapeCard);
                ModCyclic.LOGGER.info((Object)((Object)cmd) + " success");
            }
        }
    }

    public TileShapedata() {
        super(TileRegistry.computer_shape);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerShapedata(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        if (tag.func_74764_b("copiedShape")) {
            CompoundNBT cs = (CompoundNBT)tag.func_74781_a("copiedShape");
            this.copiedShape = RelativeShape.read(cs);
        }
        this.hasStashIfOne = tag.func_74762_e("stashToggle");
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("stashToggle", this.hasStashIfOne);
        if (this.copiedShape != null) {
            CompoundNBT copiedShapeTags = this.copiedShape.write(new CompoundNBT());
            tag.func_218657_a("copiedShape", (INBT)copiedShapeTags);
        }
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.hasStashIfOne = this.copiedShape == null ? 0 : 1;
        }
    }

    public boolean isAvailable(StructCommands shape) {
        ItemStack stack = this.inventory.getStackInSlot(2);
        if (stack.func_190926_b()) {
            return false;
        }
        boolean cardEmpty = stack.func_77978_p() == null || !stack.func_77978_p().func_74767_n("cyclic-shape");
        BlockPos invA = this.getTarget(0);
        BlockPos invB = this.getTarget(1);
        boolean hasTargets = invA != null && invB != null;
        switch (shape) {
            case COPY: {
                return !cardEmpty;
            }
            case MERGE: {
                return !cardEmpty && this.hasStashIfOne == 1;
            }
            case PASTE: {
                return cardEmpty && this.hasStashIfOne == 1;
            }
            case READ: {
                return cardEmpty && hasTargets;
            }
        }
        return true;
    }

    public BlockPos getTarget(int s) {
        ItemStack stackA = this.inventory.getStackInSlot(s);
        BlockPosDim loc = LocationGpsCard.getPosition(stackA);
        return loc == null ? null : loc.getPos();
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case COMMAND: {
                return 0;
            }
            case RENDER: {
                return this.render;
            }
            case STASH: {
                return this.hasStashIfOne;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case STASH: {
                this.hasStashIfOne = value;
                break;
            }
            case COMMAND: {
                if (value >= StructCommands.values().length) {
                    value = 0;
                }
                StructCommands cmd = StructCommands.values()[value];
                this.execute(cmd);
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    static enum StructCommands {
        READ,
        COPY,
        MERGE,
        PASTE;

    }

    static enum Fields {
        RENDER,
        COMMAND,
        STASH;

    }
}

