/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.sprinkler;

import com.lothrazar.cyclic.block.sprinkler.TileSprinkler;
import com.lothrazar.cyclic.render.FluidTankRenderType;
import com.lothrazar.cyclic.util.UtilFluid;
import com.lothrazar.cyclic.util.UtilRender;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@OnlyIn(value=Dist.CLIENT)
public class RenderSprinkler
extends TileEntityRenderer<TileSprinkler> {
    public RenderSprinkler(TileEntityRendererDispatcher d) {
        super(d);
    }

    public void render(TileSprinkler tankHere, float v, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight) {
        IFluidHandler handler = (IFluidHandler)tankHere.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null);
        if (handler == null || handler.getFluidInTank(0) == null) {
            return;
        }
        FluidStack fluid = handler.getFluidInTank(0);
        if (fluid.isEmpty()) {
            return;
        }
        IVertexBuilder buffer = renderer.getBuffer(FluidTankRenderType.resizableCuboid());
        matrix.func_227862_a_(1.0f, UtilFluid.getScale(tankHere.tank) / 4.0f, 1.0f);
        float f = 0.5f;
        matrix.func_227862_a_(f, 1.0f, f);
        matrix.func_227861_a_((double)f, 0.0, (double)f);
        UtilRender.renderObject(UtilFluid.getFluidModel(fluid, 1399), matrix, buffer, UtilRender.getColorARGB(fluid, 0.1f), UtilRender.calculateGlowLight(light, fluid));
    }
}

