/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.user;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.user.ContainerUser;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileUser
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    ItemStackHandler inventory = new ItemStackHandler(1);
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 160000);
    public static ForgeConfigSpec.IntValue POWERCONF;
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;
    private int timerDelay = 20;
    static final int MAX = 640000;

    public TileUser() {
        super(TileRegistry.user);
        this.needsRedstone = 1;
    }

    public void func_73660_a() {
        int repair;
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        if (this.field_145850_b.field_72995_K || !(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        this.timer = this.timerDelay;
        if (this.fakePlayer == null) {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            this.fakePlayer = this.setupBeforeTrigger((ServerWorld)this.field_145850_b, "user", this.uuid);
        }
        if ((repair = ((Integer)POWERCONF.get()).intValue()) > 0) {
            if (this.energy.getEnergyStored() < repair) {
                return;
            }
            this.energy.extractEnergy(repair, false);
        }
        try {
            TileEntityBase.tryEquipItem(this.inventoryCap, this.fakePlayer, 0, Hand.MAIN_HAND);
            ResourceLocation registryItem = ((FakePlayer)this.fakePlayer.get()).func_184586_b(Hand.MAIN_HAND).func_77973_b().getRegistryName();
            if (registryItem.func_110624_b().equalsIgnoreCase("mysticalagriculture") && registryItem.func_110623_a().contains("watering_can") && ((FakePlayer)this.fakePlayer.get()).func_184586_b(Hand.MAIN_HAND).func_77978_p() != null) {
                ModCyclic.LOGGER.info(registryItem + " id hack ");
                ((FakePlayer)this.fakePlayer.get()).func_184586_b(Hand.MAIN_HAND).func_77978_p().func_74778_a("ID", UUID.randomUUID().toString());
            }
            BlockPos target = this.field_174879_c.func_177972_a(this.getCurrentFacing());
            TileEntityBase.rightClickBlock(this.fakePlayer, this.field_145850_b, target, Hand.MAIN_HAND, null);
            TileEntityBase.syncEquippedItem(this.inventoryCap, this.fakePlayer, 0, Hand.MAIN_HAND);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("User action item error", e);
        }
        this.tryDumpFakePlayerInvo(this.fakePlayer, false);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case TIMERDEL: {
                this.timerDelay = value;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case TIMERDEL: {
                return this.timerDelay;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.timerDelay = tag.func_74762_e("delay");
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        if (tag.func_74764_b("uuid")) {
            this.uuid = tag.func_186857_a("uuid");
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("delay", this.timerDelay);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        if (this.uuid != null) {
            tag.func_186854_a("uuid", this.uuid);
        }
        return super.func_189515_b(tag);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerUser(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    static enum Fields {
        REDSTONE,
        TIMER,
        TIMERDEL,
        RENDER;

    }
}

