/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.workbench;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.workbench.TileWorkbench;
import com.lothrazar.cyclic.data.IContainerCraftingAction;
import com.lothrazar.cyclic.registry.ContainerScreenRegistry;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class ContainerWorkbench
extends RecipeBookContainer<CraftingInventory>
implements IContainerCraftingAction {
    private TileWorkbench tile;
    public static final int GRID_START_X = 30;
    public static final int GRID_START_Y = 17;
    public static final int OUTPUT_START_X = 124;
    public static final int OUTPUT_START_Y = 35;
    public static final int GRID_NUM_ROWS = 3;
    private final CraftingInventory craftMatrix = new CraftingInventory((Container)this, 3, 3);
    private final CraftResultInventory craftResult = new CraftResultInventory();
    private final PlayerEntity player;
    private final IWorldPosCallable worldPosCallable;
    private boolean doneOpening = false;

    public ContainerWorkbench(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        super(ContainerScreenRegistry.workbench, windowId);
        this.tile = (TileWorkbench)world.func_175625_s(pos);
        this.player = player;
        this.worldPosCallable = IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos);
        this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, TileWorkbench.ItemHandlers.OUTPUT).ifPresent(h -> this.func_75146_a((Slot)new CraftingResultSlot(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 124, 35)));
        this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, TileWorkbench.ItemHandlers.GRID).ifPresent(h -> {
            int index = 0;
            for (int rowPos = 0; rowPos < 3; ++rowPos) {
                for (int colPos = 0; colPos < 3; ++colPos) {
                    this.craftMatrix.func_70299_a(index, h.getStackInSlot(index));
                    this.func_75146_a(new Slot((IInventory)this.craftMatrix, index, 30 + colPos * 18, 17 + rowPos * 18));
                    ++index;
                }
            }
        });
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)playerInventory, l, 8 + l * 18, 142));
        }
        this.doneOpening = true;
        this.func_75130_a(this.tile);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_201771_a(RecipeItemHelper itemHelperIn) {
        this.craftMatrix.func_194018_a(itemHelperIn);
    }

    public void func_201768_e() {
        this.craftMatrix.func_174888_l();
        this.craftResult.func_174888_l();
    }

    public boolean func_201769_a(IRecipe<? super CraftingInventory> recipeIn) {
        return recipeIn.func_77569_a((IInventory)this.craftMatrix, this.player.field_70170_p);
    }

    public int func_201767_f() {
        return 0;
    }

    public int func_201770_g() {
        return 3;
    }

    public int func_201772_h() {
        return 3;
    }

    public int func_203721_h() {
        return 10;
    }

    public RecipeBookCategory func_241850_m() {
        return RecipeBookCategory.CRAFTING;
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (!this.doneOpening) {
            return;
        }
        this.tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                h.extractItem(i, h.getSlotLimit(i), false);
                h.insertItem(i, this.craftMatrix.func_70301_a(i), false);
            }
        });
        this.worldPosCallable.func_221486_a((wrld, posIn) -> ContainerWorkbench.updateCraftingResult(this.field_75152_c, wrld, this.player, this.craftMatrix, this.craftResult));
    }

    @Override
    public ItemStack transferStack(PlayerEntity playerIn, int index) {
        return this.func_82846_b(playerIn, index);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        try {
            int playerStart = 10;
            int playerEnd = 46;
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack stack = slot.func_75211_c();
                itemstack = stack.func_77946_l();
                if (index < playerStart ? !this.func_75135_a(stack, playerStart, playerEnd, false) : index <= playerEnd && !this.func_75135_a(stack, 1, 10, false)) {
                    return ItemStack.field_190927_a;
                }
                if (stack.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                if (stack.func_190916_E() == itemstack.func_190916_E()) {
                    return ItemStack.field_190927_a;
                }
                slot.func_190901_a(playerIn, stack);
            }
            return itemstack;
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error(index + "Shift click error", e);
            return ItemStack.field_190927_a;
        }
    }

    protected static void updateCraftingResult(int id, World world, PlayerEntity player, CraftingInventory inventory, CraftResultInventory inventoryResult) {
        if (!world.field_72995_K) {
            ICraftingRecipe recipe;
            ServerPlayerEntity sp = (ServerPlayerEntity)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            Optional optional = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, world);
            if (optional.isPresent() && inventoryResult.func_201561_a(world, sp, (IRecipe)(recipe = (ICraftingRecipe)optional.get()))) {
                itemstack = recipe.func_77572_b((IInventory)inventory);
            }
            inventoryResult.func_70299_a(0, itemstack);
            sp.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(id, 0, itemstack));
        }
    }

    @Override
    public CraftingInventory getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public CraftResultInventory getCraftResult() {
        return this.craftResult;
    }
}

