/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.melter.ContainerMelter;
import com.lothrazar.cyclic.block.melter.ScreenMelter;
import com.lothrazar.cyclic.block.solidifier.ContainerSolidifier;
import com.lothrazar.cyclic.block.solidifier.ScreenSolidifier;
import com.lothrazar.cyclic.block.workbench.ContainerWorkbench;
import com.lothrazar.cyclic.compat.jei.MelterRecipeCategory;
import com.lothrazar.cyclic.compat.jei.SolidifierRecipeCategory;
import com.lothrazar.cyclic.item.crafting.CraftingBagContainer;
import com.lothrazar.cyclic.item.craftingsimple.CraftingStickContainer;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import java.util.Collection;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class CyclicPluginJEI
implements IModPlugin {
    private static final int PLAYER_INV_SIZE = 36;
    private static final ResourceLocation id = new ResourceLocation("cyclic", "jei");

    public ResourceLocation getPluginUid() {
        return id;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MelterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolidifierRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.crafter.func_199767_j(), 1), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ItemRegistry.crafting_bag, 1), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ItemRegistry.crafting_stick, 1), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.workbench.func_199767_j(), 1), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.melter.func_199767_j(), 1), new ResourceLocation[]{MelterRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.solidifier.func_199767_j(), 1), new ResourceLocation[]{SolidifierRecipeCategory.ID});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ClientWorld world = Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
        registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(CyclicRecipeType.MELTER), MelterRecipeCategory.ID);
        registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(CyclicRecipeType.SOLID), SolidifierRecipeCategory.ID);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ScreenMelter.class, 75, 20, 40, 26, new ResourceLocation[]{MelterRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenSolidifier.class, 75, 20, 40, 26, new ResourceLocation[]{SolidifierRecipeCategory.ID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerMelter.class, MelterRecipeCategory.ID, 0, 2, 2, 36);
        registry.addRecipeTransferHandler(ContainerSolidifier.class, SolidifierRecipeCategory.ID, 0, 3, 4, 36);
        registry.addRecipeTransferHandler(CraftingBagContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(CraftingStickContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(ContainerWorkbench.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
    }
}

