/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RelativeShape {
    private String structure = null;
    private List<BlockPos> shape;
    private int count;

    public RelativeShape(RelativeShape other) {
        this.shape = other.shape;
        this.count = other.count;
    }

    public RelativeShape() {
        this.shape = new ArrayList<BlockPos>();
    }

    public void merge(RelativeShape other) {
        this.shape.addAll(other.shape);
        this.count = this.shape.size();
    }

    public RelativeShape(World world, List<BlockPos> options, BlockPos center) {
        this();
        this.shape = options;
        if (world != null && center != null) {
            this.setWorldCenter(world, center);
        }
    }

    public void setWorldCenter(World world, BlockPos center) {
        if (world != null) {
            List<BlockPos> options = this.shape;
            this.shape = new ArrayList<BlockPos>();
            for (BlockPos pos : options) {
                BlockState bs = world.func_180495_p(pos);
                if (bs.func_177230_c() == Blocks.field_150350_a) continue;
                this.shape.add(pos.func_177982_a(-1 * center.func_177958_n(), -1 * center.func_177956_o(), -1 * center.func_177952_p()));
            }
        }
        this.count = this.shape.size();
    }

    public int getCount() {
        return this.count;
    }

    public String getStructure() {
        return this.structure;
    }

    public void setStructure(String structure) {
        this.structure = structure;
    }

    public List<BlockPos> getShape() {
        return this.shape;
    }

    public static RelativeShape read(CompoundNBT tag) {
        if (!tag.func_74767_n("cyclic-shape")) {
            return null;
        }
        int count = tag.func_74762_e("count");
        ArrayList<BlockPos> shapeList = new ArrayList<BlockPos>();
        for (int i = 0; i < count; ++i) {
            shapeList.add(new BlockPos(tag.func_74762_e("x" + i), tag.func_74762_e("y" + i), tag.func_74762_e("z" + i)));
        }
        RelativeShape shape = new RelativeShape();
        shape.shape = shapeList;
        shape.count = shapeList.size();
        return shape;
    }

    public static RelativeShape read(ItemStack item) {
        CompoundNBT tag = item.func_196082_o();
        return RelativeShape.read(tag);
    }

    public CompoundNBT write(CompoundNBT tag) {
        int i = 0;
        int count = 0;
        for (BlockPos p : this.shape) {
            tag.func_74768_a("x" + i, p.func_177958_n());
            tag.func_74768_a("y" + i, p.func_177956_o());
            tag.func_74768_a("z" + i, p.func_177952_p());
            count = ++i;
        }
        tag.func_74768_a("count", count);
        tag.func_74757_a("cyclic-shape", true);
        return tag;
    }

    public void write(ItemStack shapeCard) {
        CompoundNBT tag = shapeCard.func_196082_o();
        this.write(tag);
    }

    public void setShape(List<BlockPos> list) {
        this.shape = list;
        this.count = this.shape.size();
    }
}

