/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.util.UtilEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantMultishot
extends EnchantBase {
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "multishot";

    public EnchantMultishot(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof BowItem;
    }

    public int func_77325_b() {
        return 1;
    }

    @SubscribeEvent
    public void onPlayerUpdate(ArrowLooseEvent event) {
        ItemStack stackBow = event.getBow();
        int level = this.getCurrentLevelTool(stackBow);
        if (level <= 0) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        World worldIn = player.field_70170_p;
        if (!worldIn.field_72995_K) {
            float charge = BowItem.func_185059_b((int)(stackBow.func_77988_m() - event.getCharge()));
            Vector3d playerDirection = UtilEntity.lookVector(player.field_70177_z, player.field_70125_A);
            Vector3d left = playerDirection.func_72431_c(new Vector3d(0.0, 1.0, 0.0));
            Vector3d right = playerDirection.func_72431_c(new Vector3d(0.0, -1.0, 0.0));
            this.spawnArrow(worldIn, player, stackBow, charge, left.func_72432_b());
            this.spawnArrow(worldIn, player, stackBow, charge, right.func_72432_b());
        }
    }

    public static float getArrowVelocity(float charge) {
        float f = charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void spawnArrow(World worldIn, PlayerEntity player, ItemStack stackBow, float charge, Vector3d offsetVector) {
        int k;
        int j;
        ArrowItem arrowitem = (ArrowItem)Items.field_151032_g;
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(worldIn, stackBow, (LivingEntity)player);
        float f = EnchantMultishot.getArrowVelocity(charge);
        abstractarrowentity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
        if (f == 1.0f) {
            abstractarrowentity.func_70243_d(true);
        }
        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stackBow)) > 0) {
            abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stackBow)) > 0) {
            abstractarrowentity.func_70240_a(k);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stackBow) > 0) {
            abstractarrowentity.func_70015_d(100);
        }
        stackBow.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(player.func_184600_cs()));
        ModCyclic.LOGGER.info("new arrow" + abstractarrowentity);
        worldIn.func_217376_c((Entity)abstractarrowentity);
    }
}

