/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilShape;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AntimatterEvaporatorWandItem
extends ItemBase {
    private static final int SIZE = 4;
    private static final String NBT_MODE = "mode";
    public static final int COOLDOWN = 15;

    public AntimatterEvaporatorWandItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        Direction face = context.func_196000_l();
        ItemStack itemstack = context.func_195996_i();
        EvaporateMode fluidMode = EvaporateMode.values()[itemstack.func_196082_o().func_74762_e(NBT_MODE)];
        List<BlockPos> area = UtilShape.cubeSquareBase(pos.func_177972_a(face), 4, 1);
        switch (fluidMode) {
            case GENERIC: {
                break;
            }
            case LAVA: {
                break;
            }
            case WATER: {
                break;
            }
        }
        int countSuccess = 0;
        boolean tryHere = false;
        for (BlockPos posTarget : area) {
            BlockState blockHere = world.func_180495_p(posTarget);
            FluidState fluidHere = blockHere.func_204520_s();
            if (fluidHere == null) continue;
            tryHere = false;
            if (fluidMode == EvaporateMode.GENERIC && fluidHere.func_206886_c() != null && fluidHere.func_206886_c() != Fluids.field_204541_a) {
                tryHere = true;
            } else if (fluidMode == EvaporateMode.WATER && fluidHere.func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a)) {
                tryHere = true;
            } else if (fluidMode == EvaporateMode.LAVA && fluidHere.func_206886_c().func_207185_a((ITag)FluidTags.field_206960_b)) {
                tryHere = true;
            }
            if (!tryHere || !this.removeLiquid(world, blockHere, posTarget)) continue;
            ++countSuccess;
        }
        if (countSuccess > 0) {
            PlayerEntity player = context.func_195999_j();
            player.func_184609_a(context.func_221531_n());
            UtilItemStack.damageItem(player, itemstack);
            if (world.field_72995_K) {
                UtilSound.playSound(pos, SoundEvents.field_187630_M);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private boolean removeLiquid(World world, BlockState blockHere, BlockPos pos) {
        if (blockHere.func_177230_c() instanceof IBucketPickupHandler) {
            IBucketPickupHandler block = (IBucketPickupHandler)blockHere.func_177230_c();
            return block.func_204508_a((IWorld)world, pos, blockHere) != null;
        }
        if (blockHere.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            return world.func_180501_a(pos, (BlockState)blockHere.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), 18);
        }
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)AntimatterEvaporatorWandItem.getModeTooltip(stack).func_240699_a_(TextFormatting.AQUA));
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        stack.func_196082_o().func_74768_a(NBT_MODE, EvaporateMode.WATER.ordinal());
        super.func_77622_d(stack, worldIn, playerIn);
    }

    private static TranslationTextComponent getModeTooltip(ItemStack stack) {
        EvaporateMode mode = EvaporateMode.values()[stack.func_196082_o().func_74762_e(NBT_MODE)];
        return new TranslationTextComponent("item.cyclic.antimatter_wand.tooltip0", new Object[]{new TranslationTextComponent(String.format("item.cyclic.antimatter_wand.mode.%s", mode.func_176610_l()))});
    }

    public static void toggleMode(PlayerEntity player, ItemStack stack) {
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        EvaporateMode mode = EvaporateMode.values()[stack.func_196082_o().func_74762_e(NBT_MODE)];
        stack.func_196082_o().func_74768_a(NBT_MODE, mode.getNext().ordinal());
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 15);
        if (player.field_70170_p.field_72995_K) {
            player.func_146105_b((ITextComponent)AntimatterEvaporatorWandItem.getModeTooltip(stack), true);
            UtilSound.playSound((LivingEntity)player, SoundRegistry.TOOL_MODE);
        }
    }

    public static enum EvaporateMode implements IStringSerializable
    {
        WATER,
        LAVA,
        GENERIC;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public EvaporateMode getNext() {
            switch (this) {
                case WATER: {
                    return LAVA;
                }
                case LAVA: {
                    return GENERIC;
                }
                case GENERIC: {
                    return WATER;
                }
            }
            return WATER;
        }
    }
}

