/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.bauble;

import com.lothrazar.cyclic.item.bauble.ItemBaseToggle;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AutoCaveTorchItem
extends ItemBaseToggle {
    private static final int TICK_DELAY = 10;
    public static final int LIGHT_LIMIT = 9;
    private static final int MAX_DISTANCE_SQ = (int)Math.pow(16.0, 2.0);
    private static final int MAX_LIST_SIZE = 200;
    private int timer = 0;
    private boolean ticking = false;

    public AutoCaveTorchItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!this.isOn(stack)) {
            return;
        }
        if (!(entityIn instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        if (player.func_175149_v()) {
            return;
        }
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            stack.func_196085_b(stack.func_77958_k());
            return;
        }
        --this.timer;
        if (this.timer <= 0 && !this.ticking) {
            this.ticking = true;
            BlockPos pos = entityIn.func_233580_cy_();
            if (world.func_217298_h(pos) <= 9) {
                List<BlockPos> blockHashList = UtilShape.caveInterior(world, pos, player.func_174811_aO(), 100);
                int count = 0;
                for (BlockPos testPos : blockHashList) {
                    if (++count > 200) break;
                    if (!this.shouldPlaceTorch(world, player, testPos)) continue;
                    if (UtilPlaceBlocks.placeTorchSafely(world, testPos)) {
                        UtilItemStack.damageItem(player, stack);
                    }
                    this.timer = 10;
                    break;
                }
                this.ticking = false;
            }
        }
        if (!this.ticking) {
            this.tryRepairWith(stack, player, Blocks.field_150478_aa.func_199767_j());
        }
    }

    private boolean shouldPlaceTorch(World world, PlayerEntity player, BlockPos pos) {
        return pos != null && world.func_201696_r(pos) <= 9 && world.func_175623_d(pos) && player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) < (double)MAX_DISTANCE_SQ;
    }
}

