/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.builder;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.item.builder.BuildStyle;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import com.lothrazar.cyclic.util.UtilPlayer;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSwapBlock
extends PacketBase {
    private BlockPos pos;
    private BuilderActionType actionType;
    private Direction side;
    private Hand hand;

    public PacketSwapBlock(BlockPos readBlockPos, BuilderActionType type, Direction dir, Hand h) {
        this.pos = readBlockPos;
        this.actionType = type;
        this.side = dir;
        this.hand = h;
    }

    public static PacketSwapBlock decode(PacketBuffer buf) {
        return new PacketSwapBlock(buf.func_179259_c(), BuilderActionType.values()[buf.readInt()], Direction.values()[buf.readInt()], Hand.values()[buf.readInt()]);
    }

    public static void encode(PacketSwapBlock msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeInt(msg.actionType.ordinal());
        buf.writeInt(msg.side.ordinal());
        buf.writeInt(msg.hand.ordinal());
    }

    public static void handle(PacketSwapBlock message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack itemStackHeld = player.func_184586_b(message.hand);
            BlockState targetState = BuilderActionType.getBlockState(itemStackHeld);
            if (targetState == null || !(itemStackHeld.func_77973_b() instanceof BuilderItem)) {
                return;
            }
            BuildStyle buildStyle = ((BuilderItem)itemStackHeld.func_77973_b()).style;
            World world = player.func_130014_f_();
            List<BlockPos> places = PacketSwapBlock.getSelectedBlocks(world, message.pos, message.actionType, message.side, buildStyle);
            HashMap<BlockPos, Integer> processed = new HashMap<BlockPos, Integer>();
            boolean atLeastOne = false;
            List<BlockPos> list = places;
            synchronized (list) {
                for (BlockPos curPos : places) {
                    if (!processed.containsKey(curPos)) {
                        processed.put(curPos, 0);
                    }
                    if ((Integer)processed.get(curPos) > 0) continue;
                    processed.put(curPos, (Integer)processed.get(curPos) + 1);
                    int slot = UtilPlayer.getFirstSlotWithBlock((PlayerEntity)player, targetState);
                    if (slot < 0 && !player.func_184812_l_()) {
                        UtilChat.sendStatusMessage((PlayerEntity)player, "scepter.cyclic.empty");
                        break;
                    }
                    if (world.func_175625_s(curPos) != null) continue;
                    BlockState replacedBlockState = world.func_180495_p(curPos);
                    Block replacedBlock = replacedBlockState.func_177230_c();
                    boolean isInBlacklist = false;
                    if (isInBlacklist || replacedBlockState.func_185887_b((IBlockReader)world, curPos) < 0.0f || UtilWorld.doBlockStatesMatch(replacedBlockState, targetState)) continue;
                    world.func_180501_a(curPos, Blocks.field_150350_a.func_176223_P(), 0);
                    boolean success = false;
                    if (!success) {
                        success = UtilPlaceBlocks.placeStateSafe(world, (PlayerEntity)player, curPos, targetState);
                    }
                    if (!success) continue;
                    atLeastOne = true;
                    UtilPlayer.decrStackSize((PlayerEntity)player, slot);
                    world.func_217379_c(2001, curPos, Block.func_196246_j((BlockState)targetState));
                    replacedBlock.func_180657_a(world, (PlayerEntity)player, curPos, replacedBlockState, null, itemStackHeld);
                }
            }
            if (atLeastOne) {
                UtilItemStack.damageItem((PlayerEntity)player, itemStackHeld);
            }
        });
        message.done(ctx);
    }

    public static List<BlockPos> getSelectedBlocks(World world, BlockPos pos, BuilderActionType actionType, Direction side, BuildStyle style) {
        List<BlockPos> places = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n();
        int yMin = pos.func_177956_o();
        int zMin = pos.func_177952_p();
        int xMax = pos.func_177958_n();
        int yMax = pos.func_177956_o();
        int zMax = pos.func_177952_p();
        boolean isVertical = side == Direction.UP || side == Direction.DOWN;
        int offsetH = 0;
        int offsetW = 0;
        switch (actionType) {
            case SINGLE: {
                places.add(pos);
                offsetH = 0;
                offsetW = 0;
                break;
            }
            case X3: {
                offsetH = 1;
                offsetW = 1;
                break;
            }
            case X5: {
                offsetH = 2;
                offsetW = 2;
                break;
            }
            case X7: {
                offsetH = 3;
                offsetW = 3;
                break;
            }
            case X9: {
                offsetH = 4;
                offsetW = 4;
                break;
            }
            case X19: {
                offsetH = 0;
                offsetW = 4;
                break;
            }
            case X91: {
                offsetH = 4;
                offsetW = 0;
                break;
            }
        }
        if (actionType != BuilderActionType.SINGLE) {
            if (isVertical) {
                xMin -= offsetH;
                xMax += offsetH;
                zMin -= offsetW;
                zMax += offsetW;
            } else if (side == Direction.EAST || side == Direction.WEST) {
                zMin -= offsetH;
                zMax += offsetH;
                yMin -= offsetW;
                yMax += offsetW;
            } else {
                xMin -= offsetH;
                xMax += offsetH;
                yMin -= offsetW;
                yMax += offsetW;
            }
            places = UtilWorld.getPositionsInRange(pos, xMin, xMax, yMin, yMax, zMin, zMax);
        }
        ArrayList<BlockPos> retPlaces = new ArrayList<BlockPos>();
        for (BlockPos p : places) {
            if (!world.func_180495_p(p).func_185904_a().func_76222_j() && !style.isReplaceable()) continue;
            retPlaces.add(p);
        }
        return retPlaces;
    }
}

