/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.equipment;

import com.google.common.collect.Sets;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;

public class MattockItem
extends ToolItem {
    final int radius;

    public MattockItem(Item.Properties builder, int radius) {
        super(5.0f, -3.0f, (IItemTier)ItemTier.DIAMOND, (Set)Sets.newHashSet(), builder.addToolType(ToolType.SHOVEL, 4).addToolType(ToolType.PICKAXE, 4));
        this.radius = radius;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockRayTraceResult ray = MattockItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (ray != null && ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
            List<BlockPos> shape;
            BlockRayTraceResult brt = ray;
            Direction sideHit = brt.func_216354_b();
            if (sideHit == Direction.UP || sideHit == Direction.DOWN) {
                shape = UtilShape.squareHorizontalHollow(pos, this.radius);
                if (this.radius == 2) {
                    shape.addAll(UtilShape.squareHorizontalHollow(pos, this.radius - 1));
                }
            } else {
                shape = sideHit == Direction.EAST || sideHit == Direction.WEST ? UtilShape.squareVerticalZ(pos, this.radius, this.radius) : UtilShape.squareVerticalX(pos, this.radius, this.radius);
            }
            for (BlockPos posCurrent : shape) {
                BlockState bsCurrent = world.func_180495_p(posCurrent);
                if (!(bsCurrent.field_235705_i_ >= 0.0f) || !player.func_175151_a(posCurrent, sideHit, stack) || !ForgeHooks.canHarvestBlock((BlockState)bsCurrent, (PlayerEntity)player, (IBlockReader)world, (BlockPos)posCurrent) || !(this.func_150893_a(stack, bsCurrent) > 1.0f)) continue;
                stack.func_179548_a(world, bsCurrent, posCurrent, player);
                Block blockCurrent = bsCurrent.func_177230_c();
                if (world.field_72995_K) {
                    world.func_217379_c(2001, posCurrent, Block.func_196246_j((BlockState)bsCurrent));
                    if (!blockCurrent.removedByPlayer(bsCurrent, world, posCurrent, player, true, bsCurrent.func_204520_s())) continue;
                    blockCurrent.func_176206_d((IWorld)world, posCurrent, bsCurrent);
                    continue;
                }
                if (!(player instanceof ServerPlayerEntity)) continue;
                ServerPlayerEntity mp = (ServerPlayerEntity)player;
                int xpGivenOnDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)posCurrent);
                if (xpGivenOnDrop < 0) continue;
                if (blockCurrent.removedByPlayer(bsCurrent, world, posCurrent, player, true, bsCurrent.func_204520_s()) && world instanceof ServerWorld) {
                    TileEntity tile = world.func_175625_s(posCurrent);
                    blockCurrent.func_176206_d((IWorld)world, posCurrent, bsCurrent);
                    blockCurrent.func_180657_a(world, player, posCurrent, bsCurrent, tile, stack);
                    blockCurrent.func_180637_b((ServerWorld)world, posCurrent, xpGivenOnDrop);
                }
                mp.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, posCurrent));
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, PlayerEntity player, BlockState blockState) {
        return Math.max(Items.field_151046_w.getHarvestLevel(stack, tool, player, blockState), Items.field_151047_v.getHarvestLevel(stack, tool, player, blockState));
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return Math.max(Items.field_151046_w.func_150893_a(stack, state), Items.field_151047_v.func_150893_a(stack, state));
    }
}

