/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.storagebag;

import com.lothrazar.cyclic.item.storagebag.StorageBagItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class StorageBagCapabilityProvider
implements ICapabilitySerializable<CompoundNBT> {
    private int slots;
    private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler(this.slots){

        public boolean isItemValid(int slot, ItemStack stack) {
            return !(stack.func_77973_b() instanceof StorageBagItem) && super.isItemValid(slot, stack);
        }
    });

    public StorageBagCapabilityProvider(ItemStack stack, int slots) {
        this.slots = slots;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        if (this.inventory.isPresent()) {
            return ((ItemStackHandler)this.inventory.resolve().get()).serializeNBT();
        }
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.inventory.ifPresent(h -> h.deserializeNBT(nbt));
    }
}

