/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.registry.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketStorageBagScreen
extends PacketBase {
    private ItemStack stack;
    private byte type;
    int slot;
    private StringNBT nbtKey;
    private INBT nbtValue;

    public PacketStorageBagScreen() {
    }

    public PacketStorageBagScreen(ItemStack stack, int slot, byte type, StringNBT nbtKey, INBT nbtValue) {
        this.stack = stack;
        this.slot = slot;
        this.type = type;
        this.nbtKey = nbtKey;
        this.nbtValue = nbtValue;
    }

    public static void handle(PacketStorageBagScreen message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                ItemStack serverStack = ItemStack.field_190927_a;
                if (0 <= message.slot && message.slot < player.field_71071_by.func_70302_i_()) {
                    serverStack = player.field_71071_by.func_70301_a(message.slot);
                }
                String key = message.nbtKey.func_150285_a_();
                if (!serverStack.func_190926_b() && serverStack.func_77973_b() == ItemRegistry.storage_bag && (key.equals("refill_mode") || key.equals("deposit_mode") || key.equals("pickup_mode"))) {
                    serverStack.func_196082_o().func_218657_a(key, message.nbtValue);
                }
            }
        });
        message.done(context);
    }

    public static PacketStorageBagScreen decode(PacketBuffer buffer) {
        PacketStorageBagScreen packet = new PacketStorageBagScreen();
        packet.slot = buffer.readInt();
        packet.type = buffer.readByte();
        packet.stack = buffer.func_150791_c();
        packet.nbtKey = StringNBT.func_229705_a_((String)buffer.func_150789_c(Short.MAX_VALUE));
        switch (packet.type) {
            case 1: {
                packet.nbtValue = ByteNBT.func_229671_a_((byte)buffer.readByte());
                break;
            }
            case 2: {
                packet.nbtValue = ShortNBT.func_229701_a_((short)buffer.readShort());
                break;
            }
            case 3: {
                packet.nbtValue = IntNBT.func_229692_a_((int)buffer.readInt());
                break;
            }
            case 4: {
                packet.nbtValue = LongNBT.func_229698_a_((long)buffer.readLong());
                break;
            }
            case 5: {
                packet.nbtValue = FloatNBT.func_229689_a_((float)buffer.readFloat());
                break;
            }
            case 6: {
                packet.nbtValue = DoubleNBT.func_229684_a_((double)buffer.readDouble());
                break;
            }
            case 7: {
                packet.nbtValue = new ByteArrayNBT(buffer.func_179251_a());
                break;
            }
            case 8: {
                packet.nbtValue = StringNBT.func_229705_a_((String)buffer.func_150789_c(Short.MAX_VALUE));
                break;
            }
            case 9: {
                packet.nbtValue = new ListNBT();
                break;
            }
            case 10: {
                packet.nbtValue = buffer.func_150793_b();
                break;
            }
            case 11: {
                packet.nbtValue = new IntArrayNBT(buffer.func_186863_b());
                break;
            }
            case 12: {
                packet.nbtValue = new LongArrayNBT(buffer.func_186873_b(null));
                break;
            }
            default: {
                packet.nbtValue = StringNBT.func_229705_a_((String)"");
            }
        }
        return packet;
    }

    public static void encode(PacketStorageBagScreen message, PacketBuffer buffer) {
        buffer.writeInt(message.slot);
        buffer.writeByte((int)message.type);
        buffer.func_150788_a(message.stack);
        buffer.func_180714_a(message.nbtKey.func_150285_a_());
        switch (message.type) {
            case 1: {
                buffer.writeByte((int)((ByteNBT)message.nbtValue).func_150290_f());
                break;
            }
            case 2: {
                buffer.writeShort((int)((ShortNBT)message.nbtValue).func_150289_e());
                break;
            }
            case 3: {
                buffer.writeInt(((IntNBT)message.nbtValue).func_150287_d());
                break;
            }
            case 4: {
                buffer.writeLong(((LongNBT)message.nbtValue).func_150291_c());
                break;
            }
            case 5: {
                buffer.writeFloat(((FloatNBT)message.nbtValue).func_150288_h());
                break;
            }
            case 6: {
                buffer.writeDouble(((DoubleNBT)message.nbtValue).func_150286_g());
                break;
            }
            case 7: {
                buffer.func_179250_a(((ByteArrayNBT)message.nbtValue).func_150292_c());
                break;
            }
            case 8: {
                buffer.func_180714_a(((StringNBT)message.nbtValue).func_150285_a_());
                break;
            }
            case 9: {
                buffer.func_180714_a("There could have been a list here, if I knew how to process it.");
                break;
            }
            case 10: {
                buffer.func_150786_a((CompoundNBT)message.nbtValue);
                break;
            }
            case 11: {
                buffer.func_186875_a(((IntArrayNBT)message.nbtValue).func_150302_c());
                break;
            }
            case 12: {
                buffer.func_186865_a(((LongArrayNBT)message.nbtValue).func_197652_h());
                break;
            }
            default: {
                buffer.func_180714_a("");
            }
        }
    }
}

