/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.ModCyclic;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class UtilPlaceBlocks {
    public static boolean rotateBlockValidState(World worldObj, BlockPos pos, Direction side) {
        BlockState clicked = worldObj.func_180495_p(pos);
        if (clicked.func_177230_c() == null) {
            return false;
        }
        Block clickedBlock = clicked.func_177230_c();
        BlockState newState = null;
        if (clickedBlock.func_203417_a((ITag)BlockTags.field_203292_x)) {
            String key = "type";
            String valueDupe = "double";
            for (Property prop : clicked.func_235904_r_()) {
                if (!prop.func_177701_a().equals("type") || !(newState = (BlockState)clicked.func_235896_a_(prop)).func_177229_b(prop).toString().equals("double")) continue;
                newState = (BlockState)newState.func_235896_a_(prop);
            }
        } else {
            switch (side) {
                case DOWN: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.CLOCKWISE_180);
                    break;
                }
                case EAST: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.CLOCKWISE_90);
                    break;
                }
                case NORTH: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
                case SOUTH: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.CLOCKWISE_90);
                    break;
                }
                case UP: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.CLOCKWISE_180);
                    break;
                }
                case WEST: {
                    newState = clickedBlock.rotate(clicked, (IWorld)worldObj, pos, Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
            }
        }
        if (newState != null) {
            return worldObj.func_175656_a(pos, newState);
        }
        return false;
    }

    public static boolean placeStateSafe(World world, PlayerEntity player, BlockPos placePos, BlockState placeState) {
        return UtilPlaceBlocks.placeStateSafe(world, player, placePos, placeState, false);
    }

    public static boolean placeStateSafe(World world, PlayerEntity player, BlockPos placePos, BlockState placeState, boolean playSound) {
        if (placePos == null) {
            return false;
        }
        BlockState stateHere = null;
        if (!world.func_175623_d(placePos) && (stateHere = world.func_180495_p(placePos)) != null && !stateHere.func_185904_a().func_76224_d()) {
            boolean dropBlock = true;
            if (!world.field_72995_K) {
                world.func_175655_b(placePos, dropBlock);
            }
        }
        boolean success = false;
        try {
            if (!world.field_72995_K) {
                success = world.func_180501_a(placePos, placeState, 3);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error attempting to place block ", e);
        }
        if (!success || playSound) {
            // empty if block
        }
        return success;
    }

    public static boolean destroyBlock(World world, BlockPos pos) {
        world.func_175713_t(pos);
        return world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public static boolean placeTorchSafely(World world, BlockPos blockPos) {
        BlockItem torch = (BlockItem)Items.field_221657_bQ;
        DirectionalPlaceContext context = new DirectionalPlaceContext(world, blockPos, Direction.DOWN, Items.field_221657_bQ.func_190903_i(), Direction.DOWN);
        return torch.func_195942_a((BlockItemUseContext)context).func_226246_a_();
    }
}

