/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.util.UtilWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class UtilShape {
    public static List<BlockPos> cubeSquareBase(BlockPos pos, int radius, int height) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n() - radius;
        int xMax = pos.func_177958_n() + radius;
        int zMin = pos.func_177952_p() - radius;
        int zMax = pos.func_177952_p() + radius;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + height; ++y) {
                    shape.add(new BlockPos(x, y, z));
                }
            }
        }
        return shape;
    }

    public static List<BlockPos> squareHorizontalFull(BlockPos pos, int radius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n() - radius;
        int xMax = pos.func_177958_n() + radius;
        int zMin = pos.func_177952_p() - radius;
        int zMax = pos.func_177952_p() + radius;
        int y = pos.func_177956_o();
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                shape.add(new BlockPos(x, y, z));
            }
        }
        return shape;
    }

    public static List<BlockPos> squareVerticalX(BlockPos pos, int xRadius, int yRadius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n() - xRadius;
        int xMax = pos.func_177958_n() + xRadius;
        int yMin = pos.func_177956_o() - yRadius;
        int yMax = pos.func_177956_o() + yRadius;
        int z = pos.func_177952_p();
        for (int y = yMin + 1; y < yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                shape.add(new BlockPos(x, y, z));
                shape.add(new BlockPos(x, y, z));
            }
        }
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin + 1; y < yMax; ++y) {
                shape.add(new BlockPos(x, y, z));
                shape.add(new BlockPos(x, y, z));
            }
        }
        return shape;
    }

    public static List<BlockPos> squareVerticalZ(BlockPos pos, int yRadius, int zRadius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int x = pos.func_177958_n();
        int zMin = pos.func_177952_p() - zRadius;
        int zMax = pos.func_177952_p() + zRadius;
        int yMin = pos.func_177956_o() - yRadius;
        int yMax = pos.func_177956_o() + yRadius;
        for (int y = yMin + 1; y < yMax; ++y) {
            for (int z = zMin; z <= zMax; ++z) {
                shape.add(new BlockPos(x, y, z));
                shape.add(new BlockPos(x, y, z));
            }
        }
        for (int z = zMin; z <= zMax; ++z) {
            for (int y = yMin + 1; y < yMax; ++y) {
                shape.add(new BlockPos(x, y, z));
                shape.add(new BlockPos(x, y, z));
            }
        }
        return shape;
    }

    public static List<BlockPos> line(BlockPos pos, Direction efacing, int want) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int skip = 1;
        for (int i = 1; i < want + 1; i += skip) {
            shape.add(pos.func_177967_a(efacing, i));
        }
        return shape;
    }

    public static List<BlockPos> squareHorizontalHollow(BlockPos pos, int radius) {
        return UtilShape.rectHollow(pos, radius, radius);
    }

    public static List<BlockPos> rect(BlockPos pos, BlockPos target) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        if (pos == null || target == null) {
            return shape;
        }
        int xMin = Math.min(pos.func_177958_n(), target.func_177958_n());
        int yMin = Math.min(pos.func_177956_o(), target.func_177956_o());
        int zMin = Math.min(pos.func_177952_p(), target.func_177952_p());
        int xMax = Math.max(pos.func_177958_n(), target.func_177958_n());
        int yMax = Math.max(pos.func_177956_o(), target.func_177956_o());
        int zMax = Math.max(pos.func_177952_p(), target.func_177952_p());
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = yMin; y <= yMax; ++y) {
                    shape.add(new BlockPos(x, y, z));
                }
            }
        }
        return shape;
    }

    public static List<BlockPos> rectHollow(BlockPos pos, int radiusX, int radiusZ) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n() - radiusX;
        int xMax = pos.func_177958_n() + radiusX;
        int zMin = pos.func_177952_p() - radiusZ;
        int zMax = pos.func_177952_p() + radiusZ;
        int y = pos.func_177956_o();
        for (int x = xMin; x <= xMax; ++x) {
            shape.add(new BlockPos(x, y, zMin));
            shape.add(new BlockPos(x, y, zMax));
        }
        for (int z = zMin + 1; z < zMax; ++z) {
            shape.add(new BlockPos(xMin, y, z));
            shape.add(new BlockPos(xMax, y, z));
        }
        return shape;
    }

    public static List<BlockPos> getShape(AxisAlignedBB ab, int y) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = (int)ab.field_72340_a;
        int xMax = (int)ab.field_72336_d - 1;
        int zMin = (int)ab.field_72339_c;
        int zMax = (int)ab.field_72334_f - 1;
        for (int x = xMin; x <= xMax; ++x) {
            shape.add(new BlockPos(x, y, zMin));
            shape.add(new BlockPos(x, y, zMax));
        }
        for (int z = zMin + 1; z < zMax; ++z) {
            shape.add(new BlockPos(xMin, y, z));
            shape.add(new BlockPos(xMax, y, z));
        }
        return shape;
    }

    public static List<BlockPos> circleHorizontal(BlockPos pos, int diameter) {
        int radius;
        int centerX = pos.func_177958_n();
        int centerZ = pos.func_177952_p();
        int height = pos.func_177956_o();
        int z = radius = diameter / 2;
        int x = 0;
        int d = 2 - 2 * radius;
        ArrayList<BlockPos> circleList = new ArrayList<BlockPos>();
        do {
            circleList.add(new BlockPos(centerX + x, height, centerZ + z));
            circleList.add(new BlockPos(centerX + x, height, centerZ - z));
            circleList.add(new BlockPos(centerX - x, height, centerZ + z));
            circleList.add(new BlockPos(centerX - x, height, centerZ - z));
            circleList.add(new BlockPos(centerX + z, height, centerZ + x));
            circleList.add(new BlockPos(centerX + z, height, centerZ - x));
            circleList.add(new BlockPos(centerX - z, height, centerZ + x));
            circleList.add(new BlockPos(centerX - z, height, centerZ - x));
            if (d < 0) {
                d = d + 4 * x + 6;
                continue;
            }
            d = d + 4 * (x - z) + 10;
            --z;
        } while (++x <= z);
        Collections.sort(circleList, new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos object1, BlockPos object2) {
                return object1.func_177958_n() - object2.func_177958_n();
            }
        });
        return circleList;
    }

    public static List<BlockPos> repeatShapeByHeight(List<BlockPos> shape, int height) {
        ArrayList<BlockPos> newShape = new ArrayList<BlockPos>();
        newShape.addAll(shape);
        for (int i = 1; i <= Math.abs(height); ++i) {
            for (BlockPos p : shape) {
                BlockPos newOffset = null;
                newOffset = height > 0 ? p.func_177981_b(i) : p.func_177979_c(i);
                if (newOffset.func_177956_o() < 0 || newOffset.func_177956_o() > 256) continue;
                newShape.add(newOffset);
            }
        }
        return newShape;
    }

    public static List<BlockPos> sphereDome(BlockPos pos, int radius) {
        return UtilShape.sphere(pos, radius, true, false);
    }

    public static List<BlockPos> sphereCup(BlockPos pos, int radius) {
        return UtilShape.sphere(pos, radius, false, true);
    }

    public static List<BlockPos> sphere(BlockPos pos, int radius) {
        return UtilShape.sphere(pos, radius, false, false);
    }

    public static List<BlockPos> sphere(BlockPos pos, int radius, boolean topHalfOnly, boolean bottomHalfOnly) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radiusInner = radius - 1;
        int yMin = y - radius;
        int yMax = y + radius;
        if (topHalfOnly) {
            yMin = pos.func_177956_o();
        } else if (bottomHalfOnly) {
            yMax = pos.func_177956_o();
        }
        for (int xCurr = x - radius; xCurr <= x + radius; ++xCurr) {
            for (int yCurr = yMin; yCurr <= yMax; ++yCurr) {
                for (int zCurr = z - radius; zCurr <= z + radius; ++zCurr) {
                    int squareDistance = (xCurr - x) * (xCurr - x) + (yCurr - y) * (yCurr - y) + (zCurr - z) * (zCurr - z);
                    if (squareDistance > radius * radius || squareDistance < radiusInner * radiusInner) continue;
                    shape.add(new BlockPos(xCurr, yCurr, zCurr));
                }
            }
        }
        return shape;
    }

    public static List<BlockPos> squarePyramid(BlockPos pos, int radius, int height) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int radiusCurrent = radius;
        BlockPos posCurrent = new BlockPos((Vector3i)pos);
        for (int i = 0; i < radius; ++i) {
            shape.addAll(UtilShape.rectHollow(posCurrent, radiusCurrent, radiusCurrent));
            --radiusCurrent;
            posCurrent = posCurrent.func_177984_a();
        }
        return shape;
    }

    public static List<BlockPos> diagonal(BlockPos posCurrent, Direction pfacing, int want, boolean isLookingUp) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        for (int i = 1; i < want + 1; ++i) {
            posCurrent = isLookingUp ? posCurrent.func_177984_a() : posCurrent.func_177977_b();
            posCurrent = posCurrent.func_177972_a(pfacing);
            shape.add(posCurrent);
        }
        return shape;
    }

    public static List<BlockPos> caveInterior(World world, BlockPos posCurrent, Direction pfacing, int distance) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        if (pfacing == Direction.WEST || pfacing == Direction.EAST) {
            shape.addAll(UtilShape.caveInteriorHalf(world, posCurrent, Direction.NORTH, distance / 2));
            shape.addAll(UtilShape.caveInteriorHalf(world, posCurrent, Direction.SOUTH, distance / 2));
        } else if (pfacing == Direction.NORTH || pfacing == Direction.SOUTH) {
            shape.addAll(UtilShape.caveInteriorHalf(world, posCurrent, Direction.EAST, distance / 2));
            shape.addAll(UtilShape.caveInteriorHalf(world, posCurrent, Direction.WEST, distance / 2));
        }
        return shape.stream().distinct().collect(Collectors.toList());
    }

    private static List<BlockPos> caveInteriorHalf(World world, BlockPos posCurrent, Direction direction, int distance) {
        return UtilShape.caveWalk(world, posCurrent, direction, Direction.DOWN, distance);
    }

    public static List<BlockPos> caveWalk(World world, BlockPos startPos, Direction facing, Direction stickySurface, int distance) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        BlockPos pos = UtilWorld.getLastAirBlockBelow(world, startPos);
        BlockPos stopPos = UtilWorld.getLastAirBlockAbove(world, startPos);
        for (int iterations = 0; pos != stopPos && iterations < distance; ++iterations) {
            Pair<Direction, Direction> nextStep;
            BlockPos nextStraightPos = pos.func_177972_a(facing);
            BlockPos nextWrapPos = nextStraightPos.func_177972_a(stickySurface);
            if (world.func_180495_p(nextStraightPos).func_200132_m()) {
                nextStep = UtilShape.nextStepChangeDirection(facing, stickySurface);
                facing = (Direction)nextStep.facing;
                stickySurface = (Direction)nextStep.stickySurface;
            } else if (world.func_180495_p(nextWrapPos).func_200132_m()) {
                pos = nextStraightPos;
            } else if (!world.func_180495_p(nextWrapPos).func_200132_m() && !world.func_180495_p(pos.func_177972_a(facing)).func_200132_m()) {
                pos = nextWrapPos;
                nextStep = UtilShape.nextStepOnSameBlock(facing, stickySurface);
                facing = (Direction)nextStep.facing;
                stickySurface = (Direction)nextStep.stickySurface;
            }
            if (shape.contains(pos)) continue;
            shape.add(pos);
        }
        return shape;
    }

    private static Pair<Direction, Direction> nextStepOnSameBlock(Direction facing, Direction stickySurface) {
        Direction newFacing = stickySurface;
        Direction newStickySurface = facing.func_176734_d();
        return new Pair<Direction, Direction>(newFacing, newStickySurface);
    }

    private static Pair<Direction, Direction> nextStepChangeDirection(Direction facing, Direction stickySurface) {
        Direction newFacing = stickySurface.func_176734_d();
        Direction newStickySurface = facing;
        return new Pair<Direction, Direction>(newFacing, newStickySurface);
    }

    private static class Pair<T, U> {
        public final T facing;
        public final U stickySurface;

        private Pair(T facing, U stickySurface) {
            this.facing = facing;
            this.stickySurface = stickySurface;
        }
    }
}

