/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.PlayerDungeonEvents;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityLocalTeleporter;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.DungeonChunkGenerator;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.item.ItemSecretBell;
import com.catastrophe573.dimdungeons.utils.CommandDimDungeons;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.command.CommandSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dimdungeons")
public class DimDungeons {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "dimdungeons";
    public static final String RESOURCE_PREFIX = "dimdungeons:";
    public static final String dungeon_basic_regname = "dungeon_dimension";
    public static final RegistryKey<World> DUNGEON_DIMENSION = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("dimdungeons", "dungeon_dimension"));
    public static final PlayerDungeonEvents eventHandler = new PlayerDungeonEvents();

    public DimDungeons() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::modConfig);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, DungeonConfig.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, DungeonConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DungeonConfig.COMMON_SPEC, "dimdungeons-common-1.13.1.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)BlockRegistrar.block_gold_portal, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)BlockRegistrar.block_local_teleporter, (RenderType)RenderType.func_228645_f_());
        ItemModelsProperties.func_239418_a_((Item)ItemRegistrar.item_portal_key, (ResourceLocation)new ResourceLocation(MOD_ID, "keytype"), (stack, world, entity) -> ItemPortalKey.getKeyLevelAsFloat(stack));
        ItemModelsProperties.func_239418_a_((Item)ItemRegistrar.item_secret_bell, (ResourceLocation)new ResourceLocation(MOD_ID, "bellupgrade"), (stack, world, entity) -> ItemSecretBell.getUpgradeLevelAsFloat(stack));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
    }

    public void modConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == DungeonConfig.CLIENT_SPEC) {
            DungeonConfig.refreshClient();
        } else if (config.getSpec() == DungeonConfig.SERVER_SPEC) {
            DungeonConfig.refreshServer();
        }
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        CommandDimDungeons.register((CommandDispatcher<CommandSource>)evt.getDispatcher());
    }

    public static void logMessageInfo(String message) {
        if (DungeonConfig.logLevel.equalsIgnoreCase("all") || DungeonConfig.logLevel.equalsIgnoreCase("info")) {
            LOGGER.info(message);
        }
    }

    public static void logMessageWarn(String message) {
        if (DungeonConfig.logLevel.equalsIgnoreCase("all") || DungeonConfig.logLevel.equalsIgnoreCase("info") || DungeonConfig.logLevel.equalsIgnoreCase("warn")) {
            LOGGER.warn(message);
        }
    }

    public static void logMessageError(String message) {
        LOGGER.error(message);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="dimdungeons")
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            BlockRegistrar.registerAllBlocks(blockRegistryEvent);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            ItemRegistrar.registerAllItems(itemRegistryEvent);
            BlockRegistrar.registerAllItemBlocks(itemRegistryEvent);
        }

        @SubscribeEvent
        public static void registerTE(RegistryEvent.Register<TileEntityType<?>> teRegistryEvent) {
            TileEntityType tetPortalKeyhole = TileEntityType.Builder.func_223042_a(TileEntityPortalKeyhole::new, (Block[])new Block[0]).func_206865_a(null);
            TileEntityType tetGoldPortal = TileEntityType.Builder.func_223042_a(TileEntityGoldPortal::new, (Block[])new Block[0]).func_206865_a(null);
            TileEntityType tetLocalTeleporter = TileEntityType.Builder.func_223042_a(TileEntityLocalTeleporter::new, (Block[])new Block[0]).func_206865_a(null);
            tetPortalKeyhole.setRegistryName(DimDungeons.MOD_ID, "tileentity_portal_keyhole");
            tetGoldPortal.setRegistryName(DimDungeons.MOD_ID, "tileentity_gold_portal");
            tetLocalTeleporter.setRegistryName(DimDungeons.MOD_ID, "tileentity_local_teleporter");
            teRegistryEvent.getRegistry().register((IForgeRegistryEntry)tetPortalKeyhole);
            teRegistryEvent.getRegistry().register((IForgeRegistryEntry)tetGoldPortal);
            teRegistryEvent.getRegistry().register((IForgeRegistryEntry)tetLocalTeleporter);
            Registry.func_218325_a((Registry)Registry.field_239690_aB_, (String)"dimdungeons:dimdungeons_chunkgen", DungeonChunkGenerator.myCodec);
        }
    }
}

