/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerDungeonEvents {
    @SubscribeEvent
    public void explosionStart(ExplosionEvent.Start event) {
    }

    @SubscribeEvent
    public void explosionModify(ExplosionEvent.Detonate event) {
        if (!DungeonUtils.isDimensionDungeon(event.getWorld())) {
            return;
        }
        ArrayList crackedBricks = Lists.newArrayList();
        for (int i = 0; i < event.getAffectedBlocks().size(); ++i) {
            if (event.getWorld().func_180495_p((BlockPos)event.getAffectedBlocks().get(i)).func_177230_c().getRegistryName().func_110623_a().equals("cracked_stone_bricks")) {
                crackedBricks.add(event.getAffectedBlocks().get(i));
            }
            if (event.getWorld().func_180495_p((BlockPos)event.getAffectedBlocks().get(i)).func_177230_c().getRegistryName().func_110623_a().equals("trapped_chest")) {
                crackedBricks.add(event.getAffectedBlocks().get(i));
            }
            if (!event.getWorld().func_180495_p((BlockPos)event.getAffectedBlocks().get(i)).func_177230_c().getRegistryName().func_110623_a().equals("tnt")) continue;
            crackedBricks.add(event.getAffectedBlocks().get(i));
        }
        event.getExplosion().func_180342_d();
        event.getAffectedBlocks().addAll(crackedBricks);
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon((World)event.getWorld())) {
            return;
        }
        BlockState targetBlock = event.getWorld().func_180495_p(event.getPos());
        if (DungeonConfig.blockBreakWhitelist.contains(targetBlock.func_177230_c())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void blockPlace(BlockEvent.EntityPlaceEvent event) {
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon((World)event.getWorld())) {
            return;
        }
        String whatBlock = event.getPlacedBlock().func_177230_c().getRegistryName().func_110623_a();
        String whyBlock = event.getBlockSnapshot().getReplacedBlock().func_177230_c().getRegistryName().func_110623_a();
        if ("water".equals(whatBlock) && "water".equals(whyBlock)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void fillBucket(FillBucketEvent event) {
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getWorld())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getWorld())) {
            return;
        }
        BlockState targetBlock = event.getWorld().func_180495_p(event.getPos());
        if (DungeonConfig.blockInteractBlacklist.contains(targetBlock.func_177230_c())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void teleportStart(EnderTeleportEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            // empty if block
        }
        if ((event.getEntity() instanceof EndermanEntity || event.getEntity() instanceof ShulkerEntity) && DungeonUtils.isDimensionDungeon(event.getEntity().func_130014_f_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent.Start event) {
        ItemStack stack = event.getItem();
        if (!(event.getEntityLiving() instanceof ServerPlayerEntity)) {
            return;
        }
        if (DungeonUtils.isDimensionDungeon(event.getEntityLiving().func_130014_f_()) && stack.func_77973_b() == Items.field_185161_cS) {
            event.setDuration(-1);
            event.setCanceled(true);
        }
    }
}

