/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.CustomTeleporter;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class BlockGoldPortal
extends BreakableBlock {
    public static String REG_NAME = "block_gold_portal";
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public BlockGoldPortal() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200943_b(50.0f).func_200947_a(SoundType.field_185853_f).func_200942_a().func_235838_a_(p -> 15));
        this.setRegistryName("dimdungeons", REG_NAME);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!this.checkPortalIntegrity(state, (IWorld)worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.checkPortalIntegrity(state, (IWorld)worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.checkPortalIntegrity(stateIn, worldIn, currentPos)) {
            return stateIn;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        TileEntity tile;
        if (worldIn.field_72995_K) {
            return;
        }
        if (!(entityIn instanceof ServerPlayerEntity)) {
            return;
        }
        if (!entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU() && (tile = worldIn.func_175625_s(pos)) != null && tile instanceof TileEntityGoldPortal) {
            TileEntityGoldPortal te = (TileEntityGoldPortal)worldIn.func_175625_s(pos);
            BlockPos destination = te.getDestination();
            float warpX = destination.func_177958_n();
            float warpY = destination.func_177956_o();
            float warpZ = destination.func_177952_p();
            int cooldown = te.getCooldown();
            int currentTick = worldIn.func_73046_m().func_71259_af();
            if (!te.needsUpdateThisTick(currentTick)) {
                return;
            }
            if (cooldown > 0) {
                te.setCooldown(cooldown - 1, worldIn, pos, currentTick);
                return;
            }
            te.setCooldown(DungeonConfig.portalCooldownTicks, worldIn, pos, currentTick);
            if (!DungeonUtils.isDimensionDungeon(worldIn)) {
                TileEntityPortalKeyhole keyhole;
                if (DungeonConfig.hardcoreMode && (keyhole = this.findKeyholeForThisPortal(state, (IWorld)worldIn, pos)) != null) {
                    keyhole.removeContents();
                    BlockState emptyState = worldIn.func_180495_p(keyhole.func_174877_v());
                    worldIn.func_175656_a(keyhole.func_174877_v(), (BlockState)((BlockState)emptyState.func_206870_a((Property)BlockPortalKeyhole.FILLED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockPortalKeyhole.LIT, (Comparable)Boolean.valueOf(false)));
                }
                DimDungeons.logMessageInfo("Player used a key to teleport to dungeon at (" + warpX + ", " + warpZ + ").");
                this.actuallyPerformTeleport((ServerPlayerEntity)entityIn, DungeonUtils.getDungeonWorld(worldIn.func_73046_m()), warpX, 55.1, warpZ + 0.5f, 0.0);
            } else if (destination.func_177958_n() == 0 && destination.func_177952_p() == 0) {
                this.sendPlayerBackHome((ServerPlayerEntity)entityIn);
            } else {
                ServerPlayerEntity player = (ServerPlayerEntity)entityIn;
                this.actuallyPerformTeleport(player, player.func_184102_h().func_71218_a(te.getDestinationDimension()), warpX + 0.5f, warpY + 0.5f, warpZ + 0.5f, 0.0);
            }
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityGoldPortal();
    }

    protected Entity actuallyPerformTeleport(ServerPlayerEntity player, ServerWorld dim, double x, double y, double z, double yaw) {
        float destPitch = player.func_189653_aC().field_189982_i;
        float destYaw = player.func_189653_aC().field_189983_j;
        if (DungeonUtils.isDimensionDungeon((World)dim)) {
            destPitch = 0.0f;
            destYaw = 180.0f;
        }
        CustomTeleporter tele = new CustomTeleporter(dim);
        tele.setDestPos(x, y, z, destYaw, destPitch);
        player.changeDimension(dim, (ITeleporter)tele);
        return player;
    }

    protected void sendPlayerBackHome(ServerPlayerEntity player) {
        float lastX = 0.0f;
        float lastY = 0.0f;
        float lastZ = 0.0f;
        float lastYaw = player.func_189653_aC().field_189983_j;
        Optional respawn = player.func_213374_dv();
        if (respawn.isPresent()) {
            lastX = ((BlockPos)respawn.get()).func_177958_n();
            lastY = ((BlockPos)respawn.get()).func_177956_o() + 3;
            lastZ = ((BlockPos)respawn.get()).func_177952_p();
        } else {
            lastX = player.func_184102_h().func_71218_a(World.field_234918_g_).func_72912_H().func_76079_c();
            lastY = player.func_184102_h().func_71218_a(World.field_234918_g_).func_72912_H().func_76075_d() + 2;
            lastZ = player.func_184102_h().func_71218_a(World.field_234918_g_).func_72912_H().func_76074_e();
        }
        this.actuallyPerformTeleport(player, player.func_184102_h().func_71218_a(World.field_234918_g_).getWorldServer(), lastX, lastY, lastZ, lastYaw);
    }

    public boolean checkPortalIntegrity(BlockState state, IWorld worldIn, BlockPos pos) {
        return DungeonUtils.isDimensionDungeon((World)worldIn) || this.isPortalShapeIntact(state, worldIn, pos);
    }

    private boolean isPortalShapeIntact(BlockState state, IWorld worldIn, BlockPos pos) {
        TileEntityPortalKeyhole te = this.findKeyholeForThisPortal(state, worldIn, pos);
        if (te == null) {
            return false;
        }
        if (!te.isActivated()) {
            return false;
        }
        BlockState keyholeBlock = worldIn.func_180495_p(te.func_174877_v());
        boolean frameLevel1 = this.checkPortalFrameLevel1(worldIn, te.func_174877_v());
        if (!frameLevel1) {
            return false;
        }
        ItemStack key = te.getObjectInserted();
        int keyLevel = ((ItemPortalKey)key.func_77973_b()).getKeyLevel(key);
        if (key.func_77973_b() instanceof ItemPortalKey && keyLevel >= 2) {
            boolean frameLevel2 = false;
            frameLevel2 = keyholeBlock.func_177229_b((Property)BlockPortalKeyhole.FACING) == Direction.WEST || keyholeBlock.func_177229_b((Property)BlockPortalKeyhole.FACING) == Direction.EAST ? this.checkPortalFrameLevel2NorthSouth(worldIn, te.func_174877_v()) : this.checkPortalFrameLevel2WestEast(worldIn, te.func_174877_v());
            if (!frameLevel2) {
                return false;
            }
        }
        return true;
    }

    private TileEntityPortalKeyhole findKeyholeForThisPortal(BlockState state, IWorld worldIn, BlockPos pos) {
        BlockPos p = pos.func_177984_a();
        for (int i = 0; i < 2; ++i) {
            BlockState keyhole = worldIn.func_180495_p(p);
            if (keyhole.func_177230_c() == BlockRegistrar.block_portal_keyhole) {
                return (TileEntityPortalKeyhole)worldIn.func_175625_s(p);
            }
            p = p.func_177984_a();
        }
        return null;
    }

    public static boolean isValidPortalFrameBlock(Block b) {
        return b.func_203417_a(BlockTags.func_199896_a().func_241834_b(new ResourceLocation("dimdungeons", "dimdungeons_portal_frame_blocks")));
    }

    private boolean checkPortalFrameLevel1(IWorld worldIn, BlockPos keyhole) {
        BlockState keyholeState = worldIn.func_180495_p(keyhole);
        ArrayList<BlockState> blocks = keyholeState.func_177229_b((Property)BlockPortalKeyhole.FACING) == Direction.WEST || keyholeState.func_177229_b((Property)BlockPortalKeyhole.FACING) == Direction.EAST ? BlockGoldPortal.getPortalFrameMaterialsNorthSouth(worldIn, keyhole) : BlockGoldPortal.getPortalFrameMaterialsWestEast(worldIn, keyhole);
        for (int i = 0; i < 9; ++i) {
            if (BlockGoldPortal.isValidPortalFrameBlock(blocks.get(i).func_177230_c())) continue;
            return false;
        }
        return blocks.get(9).func_177230_c() == BlockRegistrar.block_gilded_portal && blocks.get(10).func_177230_c() == BlockRegistrar.block_gilded_portal;
    }

    public static ArrayList<BlockState> getPortalFrameMaterialsWestEast(IWorld worldIn, BlockPos keyhole) {
        ArrayList<BlockState> retval = new ArrayList<BlockState>();
        retval.add(worldIn.func_180495_p(keyhole.func_177976_e().func_177977_b()));
        retval.add(worldIn.func_180495_p(keyhole.func_177976_e().func_177979_c(2)));
        retval.add(worldIn.func_180495_p(keyhole.func_177974_f().func_177977_b()));
        retval.add(worldIn.func_180495_p(keyhole.func_177974_f().func_177979_c(2)));
        retval.add(worldIn.func_180495_p(keyhole.func_177979_c(3)));
        retval.add(worldIn.func_180495_p(keyhole.func_177985_f(3).func_177979_c(2)));
        retval.add(worldIn.func_180495_p(keyhole.func_177985_f(3).func_177979_c(3)));
        retval.add(worldIn.func_180495_p(keyhole.func_177965_g(3).func_177979_c(2)));
        retval.add(worldIn.func_180495_p(keyhole.func_177965_g(3).func_177979_c(3)));
        retval.add(worldIn.func_180495_p(keyhole.func_177985_f(3).func_177979_c(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177965_g(3).func_177979_c(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177985_f(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177965_g(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177985_f(3).func_177979_c(1).func_177964_d(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177985_f(3).func_177979_c(1).func_177970_e(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177965_g(3).func_177979_c(1).func_177964_d(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177965_g(3).func_177979_c(1).func_177970_e(1)));
        return retval;
    }

    public static ArrayList<BlockState> getPortalFrameMaterialsNorthSouth(IWorld worldIn, BlockPos keyhole) {
        ArrayList<BlockState> retval = new ArrayList<BlockState>();
        retval.add(worldIn.func_180495_p(keyhole.func_177978_c().func_177977_b()));
        retval.add(worldIn.func_180495_p(keyhole.func_177978_c().func_177979_c(2)));
        retval.add(worldIn.func_180495_p(keyhole.func_177968_d().func_177977_b()));
        retval.add(worldIn.func_180495_p(keyhole.func_177968_d().func_177979_c(2)));
        retval.add(worldIn.func_180495_p(keyhole.func_177979_c(3)));
        retval.add(worldIn.func_180495_p(keyhole.func_177964_d(3).func_177979_c(2)));
        retval.add(worldIn.func_180495_p(keyhole.func_177964_d(3).func_177979_c(3)));
        retval.add(worldIn.func_180495_p(keyhole.func_177970_e(3).func_177979_c(2)));
        retval.add(worldIn.func_180495_p(keyhole.func_177970_e(3).func_177979_c(3)));
        retval.add(worldIn.func_180495_p(keyhole.func_177964_d(3).func_177979_c(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177970_e(3).func_177979_c(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177964_d(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177970_e(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177964_d(3).func_177979_c(1).func_177965_g(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177964_d(3).func_177979_c(1).func_177985_f(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177970_e(3).func_177979_c(1).func_177965_g(1)));
        retval.add(worldIn.func_180495_p(keyhole.func_177970_e(3).func_177979_c(1).func_177985_f(1)));
        return retval;
    }

    private boolean checkPortalFrameLevel2WestEast(IWorld worldIn, BlockPos keyhole) {
        if (worldIn.func_180495_p(keyhole.func_177985_f(1)).func_177230_c() != BlockRegistrar.block_portal_crown || worldIn.func_180495_p(keyhole.func_177965_g(1)).func_177230_c() != BlockRegistrar.block_portal_crown) {
            return false;
        }
        int front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.func_177985_f(3).func_177979_c(1).func_177964_d(1));
        int back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.func_177985_f(3).func_177979_c(1).func_177970_e(1));
        if (front < 2 && back < 2) {
            return false;
        }
        front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.func_177965_g(3).func_177979_c(1).func_177964_d(1));
        back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.func_177965_g(3).func_177979_c(1).func_177970_e(1));
        return front >= 2 || back >= 2;
    }

    private boolean checkPortalFrameLevel2NorthSouth(IWorld worldIn, BlockPos keyhole) {
        if (worldIn.func_180495_p(keyhole.func_177964_d(1)).func_177230_c() != BlockRegistrar.block_portal_crown || worldIn.func_180495_p(keyhole.func_177970_e(1)).func_177230_c() != BlockRegistrar.block_portal_crown) {
            return false;
        }
        int front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.func_177964_d(3).func_177979_c(1).func_177985_f(1));
        int back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.func_177964_d(3).func_177979_c(1).func_177965_g(1));
        if (front < 2 && back < 2) {
            return false;
        }
        front = BlockGoldPortal.getBannerLevel(worldIn, keyhole.func_177970_e(3).func_177979_c(1).func_177985_f(1));
        back = BlockGoldPortal.getBannerLevel(worldIn, keyhole.func_177970_e(3).func_177979_c(1).func_177965_g(1));
        return front >= 2 || back >= 2;
    }

    public static int getBannerLevel(IWorld worldIn, BlockPos pos) {
        Block banner = worldIn.func_180495_p(pos).func_177230_c();
        if (banner != Blocks.field_196843_hj && banner != Blocks.field_196863_ht) {
            return 0;
        }
        return 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (DungeonConfig.showParticles) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + 0.8f;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double xspeed = rand.nextFloat() * (float)(rand.nextInt(3) - 1) / 9.0f;
            double zspeed = rand.nextFloat() * (float)(rand.nextInt(3) - 1) / 9.0f;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, xspeed, 0.0, zspeed);
        }
    }

    public static BannerPattern getBannerForHash(String hash) {
        for (BannerPattern bannerpattern : BannerPattern.values()) {
            if (!bannerpattern.func_190993_b().equals(hash)) continue;
            return bannerpattern;
        }
        return null;
    }
}

