/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockGoldPortal;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPortalKeyhole
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty FILLED = BooleanProperty.func_177716_a((String)"filled");
    public static final BooleanProperty LIT = BooleanProperty.func_177716_a((String)"lit");
    public static final String REG_NAME = "block_portal_keyhole";

    public BlockPortalKeyhole() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName("dimdungeons", REG_NAME);
        this.func_180632_j(this.getMyCustomDefaultState());
    }

    public BlockState getMyCustomDefaultState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)FILLED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        boolean hasPortalBlockBelow;
        boolean bl = hasPortalBlockBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == BlockRegistrar.block_gold_portal;
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue() && hasPortalBlockBelow) {
            Direction enumfacing = (Direction)stateIn.func_177229_b((Property)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1 && DungeonConfig.playPortalSounds) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 1.0f, 3.0f, false);
            }
            if (DungeonConfig.showParticles) {
                switch (enumfacing) {
                    case WEST: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0 - 0.52, d1, d2 + d4, -1.0, 1.0, 0.0);
                        break;
                    }
                    case EAST: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0 + 0.52, d1, d2 + d4, 1.0, 1.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0 + d4, d1, d2 - 0.52, 0.0, 1.0, -1.0);
                        break;
                    }
                    default: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0 + d4, d1, d2 + 0.52, 0.0, 1.0, 1.0);
                    }
                }
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack playerItem = player.func_184586_b(handIn);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        TileEntityPortalKeyhole myEntity = (TileEntityPortalKeyhole)tileEntity;
        if (myEntity != null) {
            ItemStack insideItem = myEntity.getObjectInserted();
            if (insideItem.func_190926_b()) {
                if (!playerItem.func_190926_b()) {
                    boolean dungeonExistsHere = true;
                    boolean anotherKeyWasFirst = false;
                    if (playerItem.func_77973_b() instanceof ItemPortalKey && !worldIn.field_72995_K) {
                        ItemPortalKey key = (ItemPortalKey)playerItem.func_77973_b();
                        DungeonGenData genData = DungeonGenData.Create().setKeyItem(playerItem).setTheme(key.getDungeonTheme(playerItem)).setReturnPoint(this.getReturnPoint(state, pos), DungeonUtils.serializeDimensionKey((RegistryKey<World>)worldIn.func_234923_W_()));
                        if (this.shouldBuildDungeon(playerItem)) {
                            boolean bl = anotherKeyWasFirst = !DungeonUtils.buildDungeon(worldIn, genData);
                            if (!anotherKeyWasFirst) {
                                playerItem.func_77978_p().func_74757_a("built", true);
                            }
                        }
                        float entranceX = key.getWarpX(playerItem);
                        float entranceZ = key.getWarpZ(playerItem);
                        dungeonExistsHere = DungeonUtils.reprogramExistingExitDoorway(worldIn, (long)entranceX, (long)entranceZ, genData);
                    }
                    myEntity.setContents(playerItem.func_77946_l());
                    BlockState newBlockState = (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))).func_206870_a((Property)FILLED, (Comparable)Boolean.valueOf(myEntity.isFilled()))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(myEntity.isActivated()));
                    worldIn.func_175656_a(pos, newBlockState);
                    if (!worldIn.field_72995_K) {
                        if (this.isOkayToSpawnPortalBlocks(worldIn, pos, state, myEntity) && dungeonExistsHere) {
                            Direction keyholeFacing = (Direction)state.func_177229_b((Property)FACING);
                            Direction.Axis axis = keyholeFacing == Direction.NORTH || keyholeFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                            this.addGoldenPortalBlock(worldIn, pos.func_177977_b(), playerItem, axis);
                            this.addGoldenPortalBlock(worldIn, pos.func_177979_c(2), playerItem, axis);
                        }
                        this.checkForProblemsAndLiterallySpeakToPlayer(worldIn, pos, state, myEntity, player, dungeonExistsHere, anotherKeyWasFirst);
                    }
                    playerItem.func_190918_g(1);
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (playerItem.func_190926_b()) {
                    player.func_184611_a(handIn, insideItem);
                } else if (!player.func_191521_c(insideItem)) {
                    player.func_71019_a(insideItem, false);
                }
                myEntity.removeContents();
                BlockState newBlockState = (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)FACING, state.func_177229_b((Property)FACING))).func_206870_a((Property)FILLED, (Comparable)Boolean.valueOf(myEntity.isFilled()))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(myEntity.isActivated()));
                worldIn.func_180501_a(pos, newBlockState, 3);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    protected void addGoldenPortalBlock(World worldIn, BlockPos pos, ItemStack keyStack, Direction.Axis axis) {
        ItemPortalKey key;
        worldIn.func_175656_a(pos, (BlockState)BlockRegistrar.block_gold_portal.func_176223_P().func_206870_a(BlockGoldPortal.AXIS, (Comparable)axis));
        TileEntityGoldPortal te = (TileEntityGoldPortal)worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityGoldPortal && (key = (ItemPortalKey)keyStack.func_77973_b()) != null) {
            te.setDestination(key.getWarpX(keyStack), 55.1, key.getWarpZ(keyStack), DungeonUtils.serializeDimensionKey((RegistryKey<World>)worldIn.func_234923_W_()));
        }
    }

    protected BlockPos getReturnPoint(BlockState state, BlockPos pos) {
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        switch (dir) {
            case WEST: {
                return pos.func_177976_e().func_177979_c(2);
            }
            case EAST: {
                return pos.func_177974_f().func_177979_c(2);
            }
            case NORTH: {
                return pos.func_177978_c().func_177979_c(2);
            }
            case SOUTH: {
                return pos.func_177968_d().func_177979_c(2);
            }
        }
        return pos.func_177979_c(2);
    }

    protected boolean isOkayToSpawnPortalBlocks(World worldIn, BlockPos pos, BlockState state, TileEntityPortalKeyhole myEntity) {
        if (!myEntity.isActivated()) {
            return false;
        }
        Block b1 = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block b2 = worldIn.func_180495_p(pos.func_177979_c(2)).func_177230_c();
        if (b1 != Blocks.field_150350_a && b1 != BlockRegistrar.block_gold_portal) {
            return false;
        }
        if (b2 != Blocks.field_150350_a && b2 != BlockRegistrar.block_gold_portal) {
            return false;
        }
        ItemStack item = myEntity.getObjectInserted();
        if (item.func_77973_b() instanceof ItemPortalKey) {
            ItemPortalKey key = (ItemPortalKey)item.func_77973_b();
            return key.isActivated(item);
        }
        return false;
    }

    protected boolean shouldBuildDungeon(ItemStack stack) {
        ItemPortalKey key;
        if (stack.func_77973_b() instanceof ItemPortalKey && (key = (ItemPortalKey)stack.func_77973_b()).isActivated(stack)) {
            return !key.isDungeonBuilt(stack);
        }
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityPortalKeyhole();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState retval = this.getMyCustomDefaultState();
        return (BlockState)retval.func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (state.func_177230_c() != newState.func_177230_c()) {
            if (tileentity instanceof TileEntityPortalKeyhole) {
                ItemStack item = ((TileEntityPortalKeyhole)tileentity).getObjectInserted();
                if (!item.func_190926_b()) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)item);
                }
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            worldIn.func_175713_t(pos);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        if (((Boolean)blockState.func_177229_b((Property)LIT)).booleanValue()) {
            return 2;
        }
        return (Boolean)blockState.func_177229_b((Property)FILLED) != false ? 1 : 0;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, FILLED, LIT});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirrorIn.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
    }

    public int predictPortalError(World worldIn, PlayerEntity playerIn) {
        return 0;
    }

    protected void checkForProblemsAndLiterallySpeakToPlayer(World worldIn, BlockPos pos, BlockState state, TileEntityPortalKeyhole tileEntity, PlayerEntity player, boolean dungeonExistsHere, boolean anotherKeyWasFirst) {
        BlockState b;
        int i;
        ItemPortalKey key;
        if (worldIn.field_72995_K) {
            return;
        }
        ItemStack item = tileEntity.getObjectInserted();
        int keyLevel = 0;
        if (item.func_77973_b() instanceof ItemPortalKey) {
            key = (ItemPortalKey)item.func_77973_b();
            if (!key.isActivated(item)) {
                this.speakLiterallyToPlayerAboutProblems(worldIn, player, 1, null);
                return;
            }
        } else {
            return;
        }
        keyLevel = key.getKeyLevel(item);
        if (!this.isOkayToSpawnPortalBlocks(worldIn, pos, state, tileEntity)) {
            this.speakLiterallyToPlayerAboutProblems(worldIn, player, 2, null);
            return;
        }
        ArrayList<BlockState> blocks = state.func_177229_b((Property)FACING) == Direction.WEST || state.func_177229_b((Property)FACING) == Direction.EAST ? BlockGoldPortal.getPortalFrameMaterialsNorthSouth((IWorld)worldIn, pos) : BlockGoldPortal.getPortalFrameMaterialsWestEast((IWorld)worldIn, pos);
        for (i = 0; i < 5; ++i) {
            b = blocks.get(i);
            if (b.func_196958_f()) {
                this.speakLiterallyToPlayerAboutProblems(worldIn, player, 3, null);
                return;
            }
            if (BlockGoldPortal.isValidPortalFrameBlock(b.func_177230_c())) continue;
            this.speakLiterallyToPlayerAboutProblems(worldIn, player, 4, b);
            return;
        }
        for (i = 5; i < 9; ++i) {
            b = blocks.get(i);
            if (b.func_196958_f()) {
                this.speakLiterallyToPlayerAboutProblems(worldIn, player, 5, null);
                return;
            }
            if (BlockGoldPortal.isValidPortalFrameBlock(b.func_177230_c())) continue;
            this.speakLiterallyToPlayerAboutProblems(worldIn, player, 6, b);
            return;
        }
        for (i = 9; i < 11; ++i) {
            b = blocks.get(i);
            if (b.func_177230_c() == BlockRegistrar.block_gilded_portal) continue;
            this.speakLiterallyToPlayerAboutProblems(worldIn, player, 7, b);
            return;
        }
        if (!dungeonExistsHere) {
            this.speakLiterallyToPlayerAboutProblems(worldIn, player, 11, null);
            return;
        }
        if (anotherKeyWasFirst) {
            this.speakLiterallyToPlayerAboutProblems(worldIn, player, 12, null);
        }
        if (keyLevel < 2) {
            return;
        }
        for (i = 11; i < 13; ++i) {
            b = blocks.get(i);
            if (b.func_177230_c() == BlockRegistrar.block_portal_crown) continue;
            this.speakLiterallyToPlayerAboutProblems(worldIn, player, 8, null);
            return;
        }
        BlockState leftSpireA = blocks.get(13);
        BlockState leftSpireB = blocks.get(14);
        BlockState rightSpireA = blocks.get(15);
        BlockState rightSpireB = blocks.get(16);
        if (leftSpireA.func_177230_c() != Blocks.field_196843_hj && leftSpireA.func_177230_c() != Blocks.field_196863_ht && leftSpireB.func_177230_c() != Blocks.field_196843_hj && leftSpireB.func_177230_c() != Blocks.field_196863_ht) {
            this.speakLiterallyToPlayerAboutProblems(worldIn, player, 9, null);
            return;
        }
        if (rightSpireA.func_177230_c() != Blocks.field_196843_hj && rightSpireA.func_177230_c() != Blocks.field_196863_ht && rightSpireB.func_177230_c() != Blocks.field_196843_hj && rightSpireB.func_177230_c() != Blocks.field_196863_ht) {
            this.speakLiterallyToPlayerAboutProblems(worldIn, player, 9, null);
            return;
        }
    }

    public void speakLiterallyToPlayerAboutProblems(World worldIn, PlayerEntity playerIn, int problemID, @Nullable BlockState problemBlock) {
        TranslationTextComponent text1 = new TranslationTextComponent(new TranslationTextComponent("error.dimdungeons.portal_error_" + problemID).getString());
        if (problemBlock != null) {
            text1 = new TranslationTextComponent(new TranslationTextComponent("error.dimdungeons.portal_error_" + problemID).getString() + problemBlock.func_177230_c().getRegistryName() + ".");
        }
        text1.func_240703_c_(text1.func_150256_b().func_240722_b_(Boolean.valueOf(true)));
        text1.func_240703_c_(text1.func_150256_b().func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE)));
        playerIn.func_145747_a((ITextComponent)text1, Util.field_240973_b_);
    }
}

