/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.DungeonConfig;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;

public class TileEntityGoldPortal
extends TileEntity {
    public static final String REG_NAME = "tileentity_gold_portal";
    @ObjectHolder(value="dimdungeons:tileentity_gold_portal")
    public static TileEntityType<TileEntityGoldPortal> TYPE;
    private double destX = 0.0;
    private double destY = -10000.0;
    private double destZ = 0.0;
    private int cooldown = DungeonConfig.portalCooldownTicks;
    private int lastUpdate = 0;
    private String destDimension = "minecraft:overworld";

    public TileEntityGoldPortal() {
        super(TYPE);
    }

    public TileEntityGoldPortal(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_230337_a_(BlockState stateIn, CompoundNBT compound) {
        super.func_230337_a_(stateIn, compound);
        if (compound.func_74764_b("destX") && compound.func_74764_b("destY") && compound.func_74764_b("destZ")) {
            this.destX = compound.func_74769_h("destX");
            this.destY = compound.func_74769_h("destY");
            this.destZ = compound.func_74769_h("destZ");
        }
        if (compound.func_74764_b("cooldown")) {
            this.cooldown = compound.func_74762_e("cooldown");
        }
        this.destDimension = compound.func_74764_b("destDimension") ? compound.func_74779_i("destDimension") : "minecraft:overworld";
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74780_a("destX", this.destX);
        compound.func_74780_a("destY", this.destY);
        compound.func_74780_a("destZ", this.destZ);
        compound.func_74768_a("cooldown", this.cooldown);
        compound.func_74778_a("destDimension", this.destDimension);
        return super.func_189515_b(compound);
    }

    public void setDestination(double posX, double posY, double posZ, String destDim) {
        this.destX = posX;
        this.destY = posY;
        this.destZ = posZ;
        this.destDimension = destDim;
    }

    public BlockPos getDestination() {
        return new BlockPos(this.destX, this.destY, this.destZ);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public RegistryKey<World> getDestinationDimension() {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(this.destDimension));
    }

    public boolean needsUpdateThisTick(int tick) {
        return tick > this.lastUpdate;
    }

    public boolean setCooldown(int value, World worldIn, BlockPos pos, int currentServerTick) {
        if (this.cooldown == value || currentServerTick <= this.lastUpdate) {
            return false;
        }
        this.cooldown = value;
        this.lastUpdate = currentServerTick;
        int numBlocksUpdated = 0;
        if (worldIn.func_175625_s(pos.func_177976_e()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.func_175625_s(pos.func_177976_e())).setCooldown(value, worldIn, pos.func_177976_e(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.func_175625_s(pos.func_177974_f()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.func_175625_s(pos.func_177974_f())).setCooldown(value, worldIn, pos.func_177974_f(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.func_175625_s(pos.func_177978_c()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.func_175625_s(pos.func_177978_c())).setCooldown(value, worldIn, pos.func_177978_c(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.func_175625_s(pos.func_177968_d()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.func_175625_s(pos.func_177968_d())).setCooldown(value, worldIn, pos.func_177968_d(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.func_175625_s(pos.func_177984_a()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.func_175625_s(pos.func_177984_a())).setCooldown(value, worldIn, pos.func_177984_a(), currentServerTick) ? 1 : 0;
        }
        if (worldIn.func_175625_s(pos.func_177977_b()) instanceof TileEntityGoldPortal) {
            numBlocksUpdated += ((TileEntityGoldPortal)worldIn.func_175625_s(pos.func_177977_b())).setCooldown(value, worldIn, pos.func_177977_b(), currentServerTick) ? 1 : 0;
        }
        return numBlocksUpdated > 0;
    }
}

