/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.dimension;

import com.catastrophe573.dimdungeons.structure.DungeonPlacementLogicAdvanced;
import com.catastrophe573.dimdungeons.structure.DungeonPlacementLogicBasic;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class DungeonChunkGenerator
extends ChunkGenerator {
    public static final Codec<FlatChunkGenerator> myCodec = FlatGenerationSettings.field_236932_a_.fieldOf("settings").xmap(FlatChunkGenerator::new, FlatChunkGenerator::func_236073_g_).codec();
    private final FlatGenerationSettings settings;
    private long worldSeed = 0L;

    public DungeonChunkGenerator(FlatGenerationSettings settings) {
        super((BiomeProvider)new SingleBiomeProvider(settings.func_82648_a()), (BiomeProvider)new SingleBiomeProvider(settings.func_82648_a()), settings.func_236943_d_(), 0L);
        this.settings = settings;
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return myCodec;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator func_230349_a_(long p_230349_1_) {
        this.worldSeed = p_230349_1_;
        return this;
    }

    public FlatGenerationSettings settings() {
        return this.settings;
    }

    public void func_225551_a_(WorldGenRegion p_225551_1_, IChunk p_225551_2_) {
        ServerWorld world = p_225551_1_.func_201672_e();
        this.makeBase((IWorld)world, p_225551_2_);
    }

    public void func_230351_a_(WorldGenRegion p_230351_1_, StructureManager p_230351_2_) {
    }

    public void func_230350_a_(long p_230350_1_, BiomeManager p_230350_3_, IChunk p_230350_4_, GenerationStage.Carving p_230350_5_) {
    }

    public int func_205470_d() {
        BlockState[] ablockstate = this.settings.func_202233_q();
        for (int i = 0; i < ablockstate.length; ++i) {
            BlockState blockstate;
            BlockState blockState = blockstate = ablockstate[i] == null ? Blocks.field_150350_a.func_176223_P() : ablockstate[i];
            if (Heightmap.Type.MOTION_BLOCKING.func_222684_d().test(blockstate)) continue;
            return i - 1;
        }
        return ablockstate.length;
    }

    public void func_230352_b_(IWorld p_230352_1_, StructureManager p_230352_2_, IChunk p_230352_3_) {
        BlockState[] ablockstate = this.settings.func_202233_q();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        Heightmap heightmap = p_230352_3_.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = p_230352_3_.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        for (int i = 0; i < ablockstate.length; ++i) {
            BlockState blockstate = ablockstate[i];
            if (blockstate == null) continue;
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    p_230352_3_.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(j, i, k), blockstate, false);
                    heightmap.func_202270_a(j, i, k, blockstate);
                    heightmap1.func_202270_a(j, i, k, blockstate);
                }
            }
        }
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        BlockState[] ablockstate = this.settings.func_202233_q();
        for (int i = ablockstate.length - 1; i >= 0; --i) {
            BlockState blockstate = ablockstate[i];
            if (blockstate == null || !heightmapType.func_222684_d().test(blockstate)) continue;
            return i + 1;
        }
        return 0;
    }

    public IBlockReader func_230348_a_(int p_230348_1_, int p_230348_2_) {
        return new Blockreader((BlockState[])Arrays.stream(this.settings.func_202233_q()).map(state -> state == null ? Blocks.field_150350_a.func_176223_P() : state).toArray(BlockState[]::new));
    }

    public void makeBase(IWorld worldIn, IChunk chunkIn) {
        block9: {
            int z;
            int x;
            block8: {
                Random randomSeed = worldIn.func_201674_k();
                x = chunkIn.func_76632_l().field_77276_a;
                z = chunkIn.func_76632_l().field_77275_b;
                randomSeed.setSeed(this.worldSeed + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)(z * z) * 4392871L + (long)(z * 389711) ^ this.worldSeed);
                if (!DungeonPlacementLogicBasic.isDungeonChunk(x, z) && !DungeonPlacementLogicAdvanced.isDungeonChunk(x, z)) break block8;
                for (int px = 0; px < 16; ++px) {
                    for (int py = 1; py < 255; ++py) {
                        for (int pz = 0; pz < 16; ++pz) {
                            if (py < 2) {
                                chunkIn.func_177436_a(new BlockPos(px, py, pz), Blocks.field_150357_h.func_176223_P(), false);
                                continue;
                            }
                            if (py >= 50) continue;
                            if (DungeonPlacementLogicBasic.isEntranceChunk(x, z) || DungeonPlacementLogicAdvanced.isEntranceChunk(x, z)) {
                                chunkIn.func_177436_a(new BlockPos(px, py, pz), Blocks.field_235406_np_.func_176223_P(), false);
                                continue;
                            }
                            chunkIn.func_177436_a(new BlockPos(px, py, pz), Blocks.field_150322_A.func_176223_P(), false);
                        }
                    }
                }
                break block9;
            }
            if (x % 16 != 0 && z % 16 != 0) break block9;
            for (int px = 0; px < 16; ++px) {
                for (int py = 1; py < 255; ++py) {
                    for (int pz = 0; pz < 16; ++pz) {
                        chunkIn.func_177436_a(new BlockPos(px, py, pz), Blocks.field_180401_cv.func_176223_P(), false);
                    }
                }
            }
        }
    }
}

