/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ItemSecretBell
extends Item {
    public static final String REG_NAME = "item_secret_bell";
    public static final String NBT_UPGRADE = "upgrade";
    public static final String NBT_SECRET_X = "secret_x";
    public static final String NBT_SECRET_Y = "secret_y";
    public static final String NBT_SECRET_Z = "secret_z";
    public static final int BELL_COOLDOWN_TICKS = 80;

    public ItemSecretBell(Item.Properties builderIn) {
        super(builderIn);
        this.setRegistryName("dimdungeons", REG_NAME);
    }

    public static float getUpgradeLevelAsFloat(ItemStack stack) {
        if (((ItemSecretBell)stack.func_77973_b()).getUpgradeLevel(stack) == 2) {
            return 0.2f;
        }
        return 0.1f;
    }

    public int getUpgradeLevel(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_UPGRADE)) {
            return stack.func_77978_p().func_74762_e(NBT_UPGRADE);
        }
        return 1;
    }

    public int getSecretX(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_SECRET_X)) {
            return stack.func_77978_p().func_74762_e(NBT_SECRET_X);
        }
        return -1;
    }

    public int getSecretY(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_SECRET_Y)) {
            return stack.func_77978_p().func_74762_e(NBT_SECRET_Y);
        }
        return -1;
    }

    public int getSecretZ(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_SECRET_Z)) {
            return stack.func_77978_p().func_74762_e(NBT_SECRET_Z);
        }
        return -1;
    }

    public void setUpgradeLevel(ItemStack stack, int level) {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a(NBT_UPGRADE, level);
        data.func_74768_a(NBT_SECRET_X, this.getSecretX(stack));
        data.func_74768_a(NBT_SECRET_Y, this.getSecretY(stack));
        data.func_74768_a(NBT_SECRET_Z, this.getSecretZ(stack));
        stack.func_77982_d(data);
    }

    public void setSecretLocation(ItemStack stack, int x, int y, int z) {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a(NBT_UPGRADE, this.getUpgradeLevel(stack));
        data.func_74768_a(NBT_SECRET_X, x);
        data.func_74768_a(NBT_SECRET_Y, y);
        data.func_74768_a(NBT_SECRET_Z, z);
        stack.func_77982_d(data);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (this.getUpgradeLevel(itemstack) < 2 && !DungeonUtils.isDimensionDungeon(playerIn.func_130014_f_())) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        if (handIn == Hand.MAIN_HAND) {
            playerIn.func_184811_cZ().func_185145_a((Item)this, 80);
            BlockPos secret = this.findSecretChestNearby(playerIn.func_233580_cy_(), worldIn);
            this.setSecretLocation(itemstack, secret.func_177958_n(), secret.func_177956_o(), secret.func_177952_p());
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemstack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof ServerPlayerEntity) || !isSelected) {
            return;
        }
        ServerPlayerEntity playerIn = (ServerPlayerEntity)entityIn;
        int time = (int)(playerIn.func_184811_cZ().func_185143_a((Item)this, 0.0f) * 80.0f);
        if (time == 0) {
            return;
        }
        if (time == 80) {
            this.playSoundAtPosition(worldIn, entityIn.func_233580_cy_(), 13);
        }
        if (time == 77) {
            this.playSoundAtPosition(worldIn, entityIn.func_233580_cy_(), 12);
        }
        if (time == 74) {
            this.playSoundAtPosition(worldIn, entityIn.func_233580_cy_(), 9);
        }
        if (time == 71) {
            this.playSoundAtPosition(worldIn, entityIn.func_233580_cy_(), 3);
        }
        if (this.getSecretY(stack) > -10000) {
            BlockPos secretPos = new BlockPos(this.getSecretX(stack), this.getSecretY(stack), this.getSecretZ(stack));
            if (time == 68) {
                this.playSoundAtPosition(worldIn, secretPos, 2);
            }
            if (time == 65) {
                this.playSoundAtPosition(worldIn, secretPos, 10);
            }
            if (time == 62) {
                this.playSoundAtPosition(worldIn, secretPos, 14);
            }
            if (time == 59) {
                this.playSoundAtPosition(worldIn, secretPos, 18);
            }
        }
    }

    public void playSoundAtPosition(World worldIn, BlockPos pos, int note) {
        float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        worldIn.func_184133_a((PlayerEntity)null, pos, NoteBlockInstrument.BELL.func_208088_a(), SoundCategory.RECORDS, 3.0f, pitch);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 0.5, (double)note / 24.0, 0.0, 0.0);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        attacker.func_130014_f_().func_184133_a((PlayerEntity)null, target.func_233580_cy_(), SoundEvents.field_219603_Y, SoundCategory.BLOCKS, 2.0f, 1.0f);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }

    private BlockPos findSecretChestNearby(BlockPos start, World worldIn) {
        int startX = Math.floorDiv(start.func_177958_n(), 16) * 16;
        int startZ = Math.floorDiv(start.func_177952_p(), 16) * 16;
        int startY = start.func_177956_o() - 8;
        for (int x = startX; x < startX + 16; ++x) {
            for (int z = startZ; z < startZ + 16; ++z) {
                for (int y = startY; y < startY + 16; ++y) {
                    TileEntity te = worldIn.func_175625_s(new BlockPos(x, y, z));
                    if (te == null || !(te instanceof LockableLootTileEntity)) continue;
                    boolean hasLootTable = false;
                    try {
                        hasLootTable = FieldUtils.readField((Object)te, (String)"lootTable", (boolean)true) != null;
                    }
                    catch (IllegalAccessException e) {
                        DimDungeons.logMessageError("Bell of Secrets FAILED - Illegal Access");
                    }
                    catch (IllegalArgumentException e) {
                        DimDungeons.logMessageError("Bell of Secrets FAILED - Illegal Argument");
                    }
                    if (!hasLootTable) continue;
                    return new BlockPos(x, y, z);
                }
            }
        }
        return new BlockPos(-1, -10000, -1);
    }
}

