/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.structure.DungeonBuilderLogic;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Rotation;

public class DungeonBuilderTestShapes {
    public static void MakeTestDungeonOne(DungeonBuilderLogic dbl) {
        int i;
        for (i = 1; i <= 8; ++i) {
            dbl.placeRoomShape(i - 1, 0, "deadend_" + i, DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1, 1, "redspuzzle_" + i, DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        }
        dbl.placeRoomShape(5, 1, "freebie_1", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(6, 1, "freebie_2", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(7, 1, "freebie_3", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        for (i = 1; i <= 6; ++i) {
            dbl.placeRoomShape(i - 1, 2, "spawner_" + i, DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 3; ++i) {
            dbl.placeRoomShape(i - 1, 3, "shoutout_" + i, DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1 + 3, 3, "keytrap_" + i, DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 4, "coffin_" + i, DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 5, "restroom_" + i, DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1, 6, "deathtrap_" + i, DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        }
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1 + 4, 6, "keyroom_" + i, DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        }
        dbl.placeRoomShape(4, 7, "entrance_9", DungeonBuilderLogic.RoomType.ENTRANCE, Rotation.NONE);
    }

    public static void MakeTestDungeonTwo(DungeonBuilderLogic dbl) {
        int i;
        for (i = 1; i <= 8; ++i) {
            dbl.placeRoomShape(i - 1, 0, "entrance_" + i, DungeonBuilderLogic.RoomType.ENTRANCE, Rotation.NONE);
        }
        for (i = 1; i <= 6; ++i) {
            dbl.placeRoomShape(i - 1, 1, "hallway_" + i, DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(7, 1, "entrance_9", DungeonBuilderLogic.RoomType.ENTRANCE, Rotation.NONE);
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 2, "extrahall_" + i, DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(6, 2, "moohall_1", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(7, 2, "skullcorner", DungeonBuilderLogic.RoomType.CORNER, Rotation.NONE);
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1, 3, "tempt_" + i, DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        }
        for (i = 1; i <= 3; ++i) {
            dbl.placeRoomShape(i - 1 + 4, 3, "coalhall_" + i, DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        }
        for (i = 1; i <= 8; ++i) {
            dbl.placeRoomShape(i - 1, 4, "corner_" + i, DungeonBuilderLogic.RoomType.CORNER, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 5, "longcorner_" + i, DungeonBuilderLogic.RoomType.CORNER, Rotation.NONE);
        }
        dbl.placeRoomShape(5, 5, "yinyang_1", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 5, "yinyang_2", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(4, 7, "entrance_9", DungeonBuilderLogic.RoomType.ENTRANCE, Rotation.NONE);
    }

    public static void MakeTestDungeonThree(DungeonBuilderLogic dbl) {
        int i;
        for (i = 1; i <= 4; ++i) {
            dbl.placeRoomShape(i - 1, 0, "disco_" + i, DungeonBuilderLogic.RoomType.FOURWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(4, 0, "advice_1", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(5, 0, "advice_2", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 0, "advice_3", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        for (i = 1; i <= 6; ++i) {
            dbl.placeRoomShape(i - 1, 1, "combat_" + i, DungeonBuilderLogic.RoomType.FOURWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(6, 1, "swimmaze_1", DungeonBuilderLogic.RoomType.FOURWAY, Rotation.NONE);
        dbl.placeRoomShape(7, 1, "fourway_9", DungeonBuilderLogic.RoomType.FOURWAY, Rotation.NONE);
        for (i = 1; i <= 8; ++i) {
            dbl.placeRoomShape(i - 1, 2, "fourway_" + i, DungeonBuilderLogic.RoomType.FOURWAY, Rotation.NONE);
        }
        for (i = 1; i <= 5; ++i) {
            dbl.placeRoomShape(i - 1, 3, "threeway_" + i, DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(5, 3, "tetris_1", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 3, "tetris_2", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(7, 3, "tetris_3", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        for (i = 1; i <= 3; ++i) {
            dbl.placeRoomShape(i - 1, 4, "morethree_" + i, DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        }
        dbl.placeRoomShape(0, 5, "redstrap_1", DungeonBuilderLogic.RoomType.FOURWAY, Rotation.NONE);
        dbl.placeRoomShape(1, 5, "redstrap_2", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(2, 5, "redstrap_3", DungeonBuilderLogic.RoomType.CORNER, Rotation.NONE);
        dbl.placeRoomShape(3, 5, "redstrap_4", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(4, 5, "mazenotfound_1", DungeonBuilderLogic.RoomType.CORNER, Rotation.NONE);
        dbl.placeRoomShape(5, 5, "mazenotfound_2", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 5, "mazenotfound_3", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(4, 7, "entrance_9", DungeonBuilderLogic.RoomType.ENTRANCE, Rotation.NONE);
    }

    public static void MakeTestDungeonFour(DungeonBuilderLogic dbl) {
        dbl.placeRoomShape(0, 0, "redspuzzle_4", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(1, 0, "morethree_4", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(2, 0, "morethree_5", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(3, 0, "morethree_6", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(4, 0, "library_1", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(5, 0, "library_2", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(0, 1, "crueltrap_1", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(1, 1, "crueltrap_2", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(2, 1, "crueltrap_3", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(3, 1, "blastchest_1", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(4, 1, "smeltery_v2", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(5, 1, "hiddenpath_3", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(6, 1, "hiddenpath_1", DungeonBuilderLogic.RoomType.THREEWAY, Rotation.NONE);
        dbl.placeRoomShape(7, 1, "hiddenpath_2", DungeonBuilderLogic.RoomType.FOURWAY, Rotation.NONE);
        dbl.placeRoomShape(0, 2, "waterhall_1", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(1, 2, "yinyang_1", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(2, 2, "yinyang_2", DungeonBuilderLogic.RoomType.HALLWAY, Rotation.NONE);
        dbl.placeRoomShape(3, 2, "magicpuzzle_1", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(4, 2, "beacon_1", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(5, 2, "beacon_2", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(0, 4, "spawner_1", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(1, 4, "spawner_2", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(2, 4, "spawner_3", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(3, 4, "spawner_4", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(4, 4, "spawner_5", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(5, 4, "spawner_6", DungeonBuilderLogic.RoomType.END, Rotation.NONE);
        dbl.placeRoomShape(4, 7, "entrance_9", DungeonBuilderLogic.RoomType.ENTRANCE, Rotation.NONE);
    }

    public static void MakeTestDungeonDynamic(DungeonBuilderLogic dbl, DungeonBuilderLogic.DungeonType tier, DungeonBuilderLogic.RoomType type) {
        int i;
        ArrayList allrooms = Lists.newArrayList();
        List<? extends List<String>> theListWeCareAbout = DungeonConfig.basicEntrances;
        if (tier == DungeonBuilderLogic.DungeonType.BASIC && type == DungeonBuilderLogic.RoomType.FOURWAY) {
            theListWeCareAbout = DungeonConfig.basicFourways;
        }
        if (tier == DungeonBuilderLogic.DungeonType.BASIC && type == DungeonBuilderLogic.RoomType.THREEWAY) {
            theListWeCareAbout = DungeonConfig.basicThreeways;
        }
        if (tier == DungeonBuilderLogic.DungeonType.BASIC && type == DungeonBuilderLogic.RoomType.HALLWAY) {
            theListWeCareAbout = DungeonConfig.basicHallways;
        }
        if (tier == DungeonBuilderLogic.DungeonType.BASIC && type == DungeonBuilderLogic.RoomType.CORNER) {
            theListWeCareAbout = DungeonConfig.basicCorners;
        }
        if (tier == DungeonBuilderLogic.DungeonType.BASIC && type == DungeonBuilderLogic.RoomType.END) {
            theListWeCareAbout = DungeonConfig.basicEnds;
        }
        if (tier == DungeonBuilderLogic.DungeonType.ADVANCED && type == DungeonBuilderLogic.RoomType.FOURWAY) {
            theListWeCareAbout = DungeonConfig.advancedFourways;
        }
        if (tier == DungeonBuilderLogic.DungeonType.ADVANCED && type == DungeonBuilderLogic.RoomType.THREEWAY) {
            theListWeCareAbout = DungeonConfig.advancedThreeways;
        }
        if (tier == DungeonBuilderLogic.DungeonType.ADVANCED && type == DungeonBuilderLogic.RoomType.HALLWAY) {
            theListWeCareAbout = DungeonConfig.advancedHallways;
        }
        if (tier == DungeonBuilderLogic.DungeonType.ADVANCED && type == DungeonBuilderLogic.RoomType.CORNER) {
            theListWeCareAbout = DungeonConfig.advancedCorners;
        }
        if (tier == DungeonBuilderLogic.DungeonType.ADVANCED && type == DungeonBuilderLogic.RoomType.END) {
            theListWeCareAbout = DungeonConfig.advancedEnds;
        }
        for (i = 0; i < theListWeCareAbout.size(); ++i) {
            for (int j = 0; j < theListWeCareAbout.get(i).size(); ++j) {
                String temp = theListWeCareAbout.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        dbl.placeRoomShape(4, 7, "entrance_1", DungeonBuilderLogic.RoomType.ENTRANCE, Rotation.NONE);
        for (i = 0; i < allrooms.size(); ++i) {
            if (i / 8 == 4 && i % 8 == 7) {
                int beyondEnd = allrooms.size() + 1;
                dbl.placeRoomShape(beyondEnd / 8, beyondEnd % 8, (String)allrooms.get(i), type, Rotation.NONE);
                continue;
            }
            dbl.placeRoomShape(i / 8, i % 8, (String)allrooms.get(i), type, Rotation.NONE);
        }
    }

    public static void MakeTestDungeonForTheme(DungeonBuilderLogic dbl, int theme) {
        String temp;
        int j;
        int i;
        ArrayList allrooms = Lists.newArrayList();
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEntrances.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEntrances.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeEntrances.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeFourways.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeFourways.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeFourways.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeThreeways.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeThreeways.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeThreeways.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeHallways.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeHallways.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeHallways.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeCorners.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeCorners.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeCorners.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        for (i = 0; i < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnds.size(); ++i) {
            for (j = 0; j < DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnds.get(i).size(); ++j) {
                temp = DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnds.get(i).get(j);
                allrooms.add(temp.replace("dimdungeons:", ""));
            }
        }
        dbl.placeRoomShape(4, 7, (String)allrooms.get(0), DungeonBuilderLogic.RoomType.ENTRANCE, Rotation.NONE);
        for (i = 1; i < allrooms.size(); ++i) {
            if (i / 8 == 4 && i % 8 == 7) {
                int beyondEnd = allrooms.size() + 1;
                dbl.placeRoomShape(beyondEnd / 8, beyondEnd % 8, (String)allrooms.get(i), DungeonBuilderLogic.RoomType.FOURWAY, Rotation.NONE);
                continue;
            }
            dbl.placeRoomShape(i / 8, i % 8, (String)allrooms.get(i), DungeonBuilderLogic.RoomType.FOURWAY, Rotation.NONE);
        }
    }
}

