/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityLocalTeleporter;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonBuilderLogic;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class DungeonPlacementLogicBasic {
    public static String FEATURE_ID = "feature_basic_dungeon";

    public static boolean place(ServerWorld world, long x, long z, DungeonGenData genData) {
        long entranceChunkX = x / 16L + 8L;
        long entranceChunkZ = z / 16L + 11L;
        if (!DungeonPlacementLogicBasic.isEntranceChunk(entranceChunkX, entranceChunkZ)) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: basic dungeon does not start at " + x + ", " + z);
            return false;
        }
        DimDungeons.logMessageInfo("DIMDUNGEONS START BASIC STRUCTURE at " + x + ", " + z);
        DungeonBuilderLogic dbl = new DungeonBuilderLogic(world.func_201674_k(), entranceChunkX, entranceChunkZ, DungeonBuilderLogic.DungeonType.BASIC, genData.dungeonTheme);
        int dungeonSize = 25;
        if (genData.dungeonTheme > 0) {
            dungeonSize = DungeonConfig.themeSettings.get((int)(genData.dungeonTheme - 1)).themeDungeonSize;
        }
        dbl.calculateDungeonShape(dungeonSize, false);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                ChunkPos cpos;
                DungeonBuilderLogic.DungeonRoom nextRoom = dbl.finalLayout[i][j];
                if (!nextRoom.hasRoom() || DungeonPlacementLogicBasic.putRoomHere(cpos = new ChunkPos((int)x / 16 + i + 4, (int)z / 16 + j + 4), world, nextRoom, genData)) continue;
                DimDungeons.logMessageError("DIMDUNGEONS ERROR UNABLE TO PLACE STRUCTURE: " + nextRoom.structure);
            }
        }
        return true;
    }

    public static boolean isDungeonChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX > 3L && plotX < 12L && plotZ > 3L && plotZ < 12L;
    }

    public static boolean isEntranceChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX == 8L && plotZ == 11L;
    }

    public static void putTestStructureHere(long x, long z, IWorld world) {
        ChunkPos cpos = new ChunkPos((int)x, (int)z);
        MinecraftServer minecraftserver = ((World)world).func_73046_m();
        TemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).func_184163_y();
        Template template = templatemanager.func_200219_b(new ResourceLocation("dimdungeons:basic_template"));
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(cpos);
        placementsettings.func_186223_a(placementsettings.func_186213_g());
        placementsettings.func_186220_a(Rotation.NONE);
        BlockPos position = new BlockPos(cpos.func_180334_c(), 50, cpos.func_180333_d());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        template.func_237146_a_((IServerWorld)world, position, sizeRange, placementsettings, world.func_201674_k(), 2);
    }

    public static boolean putRoomHere(ChunkPos cpos, ServerWorld world, DungeonBuilderLogic.DungeonRoom room, DungeonGenData genData) {
        MinecraftServer minecraftserver = world.func_73046_m();
        TemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).func_184163_y();
        Template template = templatemanager.func_200219_b(new ResourceLocation(room.structure));
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(cpos);
        placementsettings.func_186223_a(placementsettings.func_186213_g());
        placementsettings.func_186220_a(room.rotation);
        BlockPos position = new BlockPos(cpos.func_180334_c(), 50, cpos.func_180333_d());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        if (template == null) {
            DimDungeons.logMessageInfo("DIMDUNGEONS FATAL ERROR: Structure does not exist (" + room.structure + ")");
            return false;
        }
        if (room.rotation == Rotation.COUNTERCLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
            position = position.func_177982_a(0, 0, template.func_186259_a().func_177952_p() - 1);
        } else if (room.rotation == Rotation.CLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_90);
            position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, 0);
        } else if (room.rotation == Rotation.CLOCKWISE_180) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_180);
            position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, template.func_186259_a().func_177952_p() - 1);
        } else {
            placementsettings.func_186220_a(Rotation.NONE);
        }
        DimDungeons.logMessageInfo("Placing a room: " + room.structure);
        boolean success = template.func_237146_a_((IServerWorld)world, position, sizeRange, placementsettings, world.func_201674_k(), 2);
        for (Template.BlockInfo template$blockinfo : template.func_215381_a(position, placementsettings, Blocks.field_185779_df)) {
            StructureMode structuremode;
            if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            DungeonPlacementLogicBasic.handleDataBlock(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world, world.func_201674_k(), placementsettings.func_186213_g(), genData);
        }
        return success;
    }

    public void printMap(DungeonBuilderLogic dbl) {
        for (int j = 0; j < 8; ++j) {
            String dungeonRowShape = "";
            for (int i = 0; i < 8; ++i) {
                dungeonRowShape = dungeonRowShape + (dbl.finalLayout[i][j].hasRoom() ? "*" : ".");
            }
            System.out.println(dungeonRowShape);
        }
    }

    protected static void handleDataBlock(String name, BlockPos pos, ServerWorld world, Random rand, MutableBoundingBox bb, DungeonGenData genData) {
        if ("ReturnPortal".equals(name)) {
            world.func_180501_a(pos, BlockRegistrar.block_gold_portal.func_176223_P(), 2);
            TileEntityGoldPortal te = (TileEntityGoldPortal)world.func_175625_s(pos);
            if (te != null) {
                te.setDestination((double)genData.returnPoint.func_177958_n() + 0.5, (double)genData.returnPoint.func_177956_o() + 0.1, (double)genData.returnPoint.func_177952_p() + 0.5, genData.returnDimension);
            }
        } else if ("BackToEntrance".equals(name)) {
            world.func_180501_a(pos, BlockRegistrar.block_local_teleporter.func_176223_P(), 2);
            TileEntityLocalTeleporter te = (TileEntityLocalTeleporter)world.func_175625_s(pos);
            if (te != null) {
                ItemPortalKey key = (ItemPortalKey)genData.keyItem.func_77973_b();
                double entranceX = key.getWarpX(genData.keyItem);
                double entranceZ = key.getWarpZ(genData.keyItem);
                te.setDestination(entranceX, 55.1, entranceZ, 0.0, 180.0);
            }
        } else if ("LockItStoneBrick".equals(name)) {
            world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
        } else if (!"LockIt".equals(name)) {
            if ("FortuneTeller".equals(name)) {
                world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
                DungeonPlacementLogicBasic.faceContainerTowardsAir((IWorld)world, pos.func_177977_b());
                TileEntity te = world.func_175625_s(pos.func_177977_b());
                if (te instanceof DispenserTileEntity) {
                    ((DispenserTileEntity)te).func_174888_l();
                    ItemStack message = DungeonPlacementLogicBasic.generateLuckyMessage(rand);
                    ((DispenserTileEntity)te).func_146019_a(message);
                } else {
                    DimDungeons.logMessageWarn("DIMDUNGEONS TILE ENTITY ERROR: unable to place a fortune teller block.");
                }
            } else if ("ChestLoot1".equals(name)) {
                DungeonPlacementLogicBasic.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_basic_easy"), (IWorld)world, rand);
            } else if ("ChestLoot2".equals(name)) {
                DungeonPlacementLogicBasic.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_basic_hard"), (IWorld)world, rand);
            } else if ("ChestLootLucky".equals(name)) {
                int lucky = rand.nextInt(100);
                if (lucky < 30) {
                    DungeonPlacementLogicBasic.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_lucky"), (IWorld)world, rand);
                } else {
                    if (DungeonConfig.isModInstalled("artifacts") && lucky < 40) {
                        DungeonPlacementLogicBasic.spawnMimicFromArtifactsMod(pos, "mimic", (IWorld)world);
                    }
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
                }
            } else if ("SetTrappedLoot".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)new ResourceLocation("dimdungeons:chests/chestloot_basic_easy"));
            } else if ("BarrelLoot1".equals(name)) {
                DungeonPlacementLogicBasic.fillBarrelBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_basic_easy"), (IWorld)world, rand);
            } else if ("PlaceL2Key".equals(name)) {
                ItemStack key;
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                TileEntityPortalKeyhole te = (TileEntityPortalKeyhole)world.func_175625_s(pos.func_177977_b());
                if (te != null && (key = te.getObjectInserted()).func_77973_b() instanceof ItemPortalKey) {
                    ((ItemPortalKey)key.func_77973_b()).activateKeyLevel2(world.func_73046_m(), key);
                    te.setContents(key);
                }
            } else if ("SummonWitch".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                DungeonPlacementLogicBasic.spawnEnemyHere(pos, "minecraft:witch", world, genData.dungeonTheme);
            } else if ("SummonWaterEnemy".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                DungeonPlacementLogicBasic.spawnEnemyHere(pos, "minecraft:guardian", world, genData.dungeonTheme);
            } else if ("SummonEnderman".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                DungeonPlacementLogicBasic.spawnEnemyHere(pos, "minecraft:enderman", world, genData.dungeonTheme);
            } else if ("SummonEnemy1".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                int poolSize = DungeonConfig.basicEnemySet1.size();
                String mobid = DungeonConfig.basicEnemySet1.get(rand.nextInt(poolSize));
                if (genData.dungeonTheme > 0) {
                    poolSize = DungeonConfig.themeSettings.get((int)(genData.dungeonTheme - 1)).themeEnemySet1.size();
                    mobid = DungeonConfig.themeSettings.get((int)(genData.dungeonTheme - 1)).themeEnemySet1.get(rand.nextInt(poolSize));
                }
                DungeonPlacementLogicBasic.spawnEnemyHere(pos, mobid, world, genData.dungeonTheme);
            } else if ("SummonEnemy2".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                int poolSize = DungeonConfig.basicEnemySet2.size();
                String mobid = DungeonConfig.basicEnemySet2.get(rand.nextInt(poolSize));
                if (genData.dungeonTheme > 0) {
                    poolSize = DungeonConfig.themeSettings.get((int)(genData.dungeonTheme - 1)).themeEnemySet2.size();
                    mobid = DungeonConfig.themeSettings.get((int)(genData.dungeonTheme - 1)).themeEnemySet2.get(rand.nextInt(poolSize));
                }
                DungeonPlacementLogicBasic.spawnEnemyHere(pos, mobid, world, genData.dungeonTheme);
            } else {
                DimDungeons.logMessageWarn("UNHANDLED DATA BLOCK WITH name = " + name);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }

    private static void spawnEnemyHere(BlockPos pos, String resourceLocation, ServerWorld world, int theme) {
        EntityType entitytype = EntityType.func_220327_a((String)resourceLocation).orElse(EntityType.field_200795_i);
        Entity mob = entitytype.func_220331_a(world, null, null, pos, SpawnReason.STRUCTURE, true, true);
        TranslationTextComponent fancyName = new TranslationTextComponent("enemy.dimdungeons." + resourceLocation);
        mob.func_200203_b((ITextComponent)fancyName);
        mob.func_174828_a(pos, 0.0f, 0.0f);
        if (mob instanceof MobEntity) {
            ((MobEntity)mob).func_98053_h(false);
            ((MobEntity)mob).func_213390_a(pos, 8);
            ((MobEntity)mob).func_110163_bv();
            double healthScaling = DungeonConfig.basicEnemyHealthScaling;
            if (theme > 0) {
                healthScaling = DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnemyHealthScaling;
            }
            ModifiableAttributeInstance tempHealth = ((MobEntity)mob).func_110148_a(Attributes.field_233818_a_);
            ((MobEntity)mob).func_110148_a(Attributes.field_233818_a_).func_111128_a(tempHealth.func_111125_b() * healthScaling);
            ((MobEntity)mob).func_70606_j((float)((MobEntity)mob).func_110148_a(Attributes.field_233818_a_).func_111125_b());
            if (world.func_201674_k().nextInt(100) < DungeonConfig.chanceForThemeKeys && DungeonConfig.themeSettings.size() > 0 && theme < 1 && !((MobEntity)mob).func_190630_a(EquipmentSlotType.OFFHAND)) {
                int numThemes = DungeonConfig.themeSettings.size();
                ItemStack stack = new ItemStack((IItemProvider)ItemRegistrar.item_portal_key);
                ((ItemPortalKey)ItemRegistrar.item_portal_key.func_199767_j()).activateKeyLevel1(world.func_73046_m(), stack, world.func_201674_k().nextInt(numThemes) + 1);
                ((MobEntity)mob).func_184611_a(Hand.OFF_HAND, stack);
                ((MobEntity)mob).func_184642_a(EquipmentSlotType.OFFHAND, 1.0f);
            }
        }
    }

    private static void fillChestBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        DungeonPlacementLogicBasic.faceContainerTowardsAir(world, pos.func_177977_b());
        LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)lootTable);
        if (!(world.func_175625_s(pos.func_177977_b()) instanceof ChestTileEntity)) {
            DimDungeons.logMessageWarn("DIMDUNGEONS: FAILED TO PLACE CHEST IN DUNGEON. pos = " + pos.func_177958_n() + ", " + pos.func_177952_p());
        }
    }

    private static void fillBarrelBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)lootTable);
        if (!(world.func_175625_s(pos.func_177977_b()) instanceof BarrelTileEntity)) {
            DimDungeons.logMessageWarn("DIMDUNGEONS: FAILED TO PLACE BARREL IN DUNGEON. pos = " + pos.func_177958_n() + ", " + pos.func_177952_p());
        }
    }

    private static ItemStack generateLuckyMessage(Random rand) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151164_bB);
        stack.func_77982_d(new CompoundNBT());
        int bookType = rand.nextInt(3);
        int messageVariation = rand.nextInt(8) + 1;
        String body = "";
        String title = "";
        if (bookType == 0) {
            title = new TranslationTextComponent("book.dimdungeons.title_1").getString();
            body = new TranslationTextComponent("book.dimdungeons.fun_message_" + messageVariation).getString();
        } else if (bookType == 1) {
            title = new TranslationTextComponent("book.dimdungeons.title_2").getString();
            body = new TranslationTextComponent("book.dimdungeons.helpful_message_" + messageVariation).getString();
        } else {
            title = new TranslationTextComponent("book.dimdungeons.title_3").getString();
            body = new TranslationTextComponent("book.dimdungeons.dangerous_message_" + messageVariation).getString();
        }
        ListNBT pages = new ListNBT();
        TranslationTextComponent text = new TranslationTextComponent(body);
        String json = ITextComponent.Serializer.func_150696_a((ITextComponent)text);
        pages.add(0, (INBT)StringNBT.func_229705_a_((String)json));
        stack.func_77978_p().func_74757_a("resolved", false);
        stack.func_77978_p().func_74768_a("generation", 0);
        stack.func_77978_p().func_218657_a("pages", (INBT)pages);
        stack.func_77978_p().func_74778_a("title", title);
        stack.func_77978_p().func_74778_a("author", new TranslationTextComponent("book.dimdungeons.author").getString());
        return stack;
    }

    private static void faceContainerTowardsAir(IWorld world, BlockPos pos) {
        BlockState bs = world.func_180495_p(pos);
        if (bs.func_177230_c() == Blocks.field_150367_z || bs.func_177230_c() == Blocks.field_150486_ae) {
            if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            world.func_180501_a(pos, bs, 2);
        }
    }

    private static void spawnMimicFromArtifactsMod(BlockPos pos, String casualName, IWorld world) {
        MobEntity mob = null;
        if (!DungeonConfig.isModInstalled("artifacts")) {
            return;
        }
        mob = (MobEntity)((EntityType)EntityType.func_220327_a((String)"artifacts:mimic").get()).func_200721_a((World)world);
        mob.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        mob.func_98053_h(false);
        mob.func_174828_a(pos, 0.0f, 0.0f);
        mob.func_110163_bv();
        mob.func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
        world.func_217376_c((Entity)mob);
    }
}

