/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityLocalTeleporter;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.structure.DungeonBuilderLogic;
import com.catastrophe573.dimdungeons.structure.DungeonBuilderTestShapes;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class DungeonPlacementLogicDebug {
    public static boolean place(ServerWorld world, long x, long z, int debugType, DungeonGenData genData) {
        long entranceChunkX = x / 16L + 8L;
        long entranceChunkZ = z / 16L + 11L;
        if (!DungeonPlacementLogicDebug.isEntranceChunk(entranceChunkX, entranceChunkZ)) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: debug dungeon does not start at " + x + ", " + z);
            return false;
        }
        DimDungeons.logMessageInfo("DIMDUNGEONS START DEBUG STRUCTURE at " + x + ", " + z);
        DungeonBuilderLogic dbl = new DungeonBuilderLogic(world.func_201674_k(), entranceChunkX, entranceChunkZ, DungeonBuilderLogic.DungeonType.BASIC, genData.dungeonTheme);
        switch (debugType) {
            case 1: {
                DungeonBuilderTestShapes.MakeTestDungeonOne(dbl);
                break;
            }
            case 2: {
                DungeonBuilderTestShapes.MakeTestDungeonTwo(dbl);
                break;
            }
            case 3: {
                DungeonBuilderTestShapes.MakeTestDungeonThree(dbl);
                break;
            }
            case 4: {
                DungeonBuilderTestShapes.MakeTestDungeonFour(dbl);
                break;
            }
            case 5: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.BASIC, DungeonBuilderLogic.RoomType.FOURWAY);
                break;
            }
            case 6: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.BASIC, DungeonBuilderLogic.RoomType.THREEWAY);
                break;
            }
            case 7: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.BASIC, DungeonBuilderLogic.RoomType.HALLWAY);
                break;
            }
            case 8: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.BASIC, DungeonBuilderLogic.RoomType.CORNER);
                break;
            }
            case 9: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.BASIC, DungeonBuilderLogic.RoomType.END);
                break;
            }
            case 10: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.ADVANCED, DungeonBuilderLogic.RoomType.FOURWAY);
                break;
            }
            case 11: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.ADVANCED, DungeonBuilderLogic.RoomType.THREEWAY);
                break;
            }
            case 12: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.ADVANCED, DungeonBuilderLogic.RoomType.HALLWAY);
                break;
            }
            case 13: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.ADVANCED, DungeonBuilderLogic.RoomType.CORNER);
                break;
            }
            case 14: {
                DungeonBuilderTestShapes.MakeTestDungeonDynamic(dbl, DungeonBuilderLogic.DungeonType.ADVANCED, DungeonBuilderLogic.RoomType.END);
                break;
            }
            case 15: {
                DungeonBuilderTestShapes.MakeTestDungeonForTheme(dbl, genData.dungeonTheme);
            }
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                ChunkPos cpos;
                DungeonBuilderLogic.DungeonRoom nextRoom = dbl.finalLayout[i][j];
                if (!nextRoom.hasRoom() || DungeonPlacementLogicDebug.putRoomHere(cpos = new ChunkPos((int)x / 16 + i + 4, (int)z / 16 + j + 4), world, nextRoom, genData)) continue;
                DimDungeons.logMessageError("DIMDUNGEONS ERROR UNABLE TO PLACE STRUCTURE: " + nextRoom.structure);
            }
        }
        return true;
    }

    public static boolean isDungeonChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX > 3L && plotX < 12L && plotZ > 3L && plotZ < 12L;
    }

    public static boolean isEntranceChunk(long x, long z) {
        if (x < 0L || z < 0L) {
            return false;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX == 8L && plotZ == 11L;
    }

    public static void putTestStructureHere(long x, long z, IWorld world) {
        ChunkPos cpos = new ChunkPos((int)x, (int)z);
        MinecraftServer minecraftserver = ((World)world).func_73046_m();
        TemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).func_184163_y();
        Template template = templatemanager.func_200219_b(new ResourceLocation("dimdungeons:basic_template"));
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(cpos);
        placementsettings.func_186223_a(placementsettings.func_186213_g());
        placementsettings.func_186220_a(Rotation.NONE);
        BlockPos position = new BlockPos(cpos.func_180334_c(), 50, cpos.func_180333_d());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        template.func_237146_a_((IServerWorld)world, position, sizeRange, placementsettings, world.func_201674_k(), 2);
    }

    public static boolean putRoomHere(ChunkPos cpos, ServerWorld world, DungeonBuilderLogic.DungeonRoom room, DungeonGenData genData) {
        MinecraftServer minecraftserver = world.func_73046_m();
        TemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).func_184163_y();
        Template template = templatemanager.func_200219_b(new ResourceLocation("dimdungeons:" + room.structure));
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a(cpos);
        placementsettings.func_186223_a(placementsettings.func_186213_g());
        placementsettings.func_186220_a(room.rotation);
        BlockPos position = new BlockPos(cpos.func_180334_c(), 50, cpos.func_180333_d());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        if (template == null) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: Structure does not exist (" + room.structure + ")");
            return false;
        }
        if (room.rotation == Rotation.COUNTERCLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
            position = position.func_177982_a(0, 0, template.func_186259_a().func_177952_p() - 1);
        } else if (room.rotation == Rotation.CLOCKWISE_90) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_90);
            position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, 0);
        } else if (room.rotation == Rotation.CLOCKWISE_180) {
            placementsettings.func_186220_a(Rotation.CLOCKWISE_180);
            position = position.func_177982_a(template.func_186259_a().func_177958_n() - 1, 0, template.func_186259_a().func_177952_p() - 1);
        } else {
            placementsettings.func_186220_a(Rotation.NONE);
        }
        DimDungeons.logMessageInfo("Placing a room: " + room.structure);
        boolean success = template.func_237146_a_((IServerWorld)world, position, sizeRange, placementsettings, world.func_201674_k(), 2);
        for (Template.BlockInfo template$blockinfo : template.func_215381_a(position, placementsettings, Blocks.field_185779_df)) {
            StructureMode structuremode;
            if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            DungeonPlacementLogicDebug.handleDataBlock(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, world, world.func_201674_k(), placementsettings.func_186213_g(), genData);
        }
        return success;
    }

    public void printMap(DungeonBuilderLogic dbl) {
        for (int j = 0; j < 8; ++j) {
            String dungeonRowShape = "";
            for (int i = 0; i < 8; ++i) {
                dungeonRowShape = dungeonRowShape + (dbl.finalLayout[i][j].hasRoom() ? "*" : ".");
            }
            System.out.println(dungeonRowShape);
        }
    }

    protected static void handleDataBlock(String name, BlockPos pos, ServerWorld world, Random rand, MutableBoundingBox bb, DungeonGenData genData) {
        if ("ReturnPortal".equals(name)) {
            world.func_180501_a(pos, BlockRegistrar.block_gold_portal.func_176223_P(), 2);
        } else if ("BackToEntrance".equals(name)) {
            world.func_180501_a(pos, BlockRegistrar.block_local_teleporter.func_176223_P(), 2);
            TileEntityLocalTeleporter te = (TileEntityLocalTeleporter)world.func_175625_s(pos);
            if (te != null) {
                ItemPortalKey key = (ItemPortalKey)genData.keyItem.func_77973_b();
                double entranceX = key.getWarpX(genData.keyItem);
                double entranceZ = key.getWarpZ(genData.keyItem);
                te.setDestination(entranceX, 55.1, entranceZ, 0.0, 180.0);
            }
        } else if ("LockItStoneBrick".equals(name)) {
            world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
        } else if (!"LockIt".equals(name)) {
            if ("FortuneTeller".equals(name)) {
                world.func_180501_a(pos, Blocks.field_196696_di.func_176223_P(), 2);
                DungeonPlacementLogicDebug.faceContainerTowardsAir((IWorld)world, pos.func_177977_b());
                TileEntity te = world.func_175625_s(pos.func_177977_b());
                if (te instanceof DispenserTileEntity) {
                    ((DispenserTileEntity)te).func_174888_l();
                    ItemStack message = DungeonPlacementLogicDebug.generateLuckyMessage(rand);
                    ((DispenserTileEntity)te).func_146019_a(message);
                } else {
                    DimDungeons.logMessageWarn("DIMDUNGEONS TILE ENTITY ERROR: unable to place a fortune teller block.");
                }
            } else if ("ChestLoot1".equals(name)) {
                int lucky = rand.nextInt(100);
                if (lucky < 80) {
                    DungeonPlacementLogicDebug.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_1"), (IWorld)world, rand);
                } else {
                    DungeonPlacementLogicDebug.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_2"), (IWorld)world, rand);
                }
            } else if ("ChestLoot2".equals(name)) {
                DungeonPlacementLogicDebug.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_2"), (IWorld)world, rand);
            } else if ("ChestLootLucky".equals(name)) {
                int lucky = rand.nextInt(100);
                if (lucky < 30) {
                    DungeonPlacementLogicDebug.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_lucky"), (IWorld)world, rand);
                } else {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
                }
            } else if ("SetTrappedLoot".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                ChestTileEntity te = (ChestTileEntity)world.func_175625_s(pos.func_177977_b());
                if (te != null) {
                    te.func_174888_l();
                    te.func_189404_a(new ResourceLocation("dimdungeons:chests/chestloot_1"), rand.nextLong());
                }
            } else if ("BarrelLoot1".equals(name)) {
                int lucky = rand.nextInt(100);
                if (lucky < 80) {
                    DungeonPlacementLogicDebug.fillBarrelBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_1"), (IWorld)world, rand);
                } else {
                    DungeonPlacementLogicDebug.fillBarrelBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_2"), (IWorld)world, rand);
                }
            } else if ("PlaceL2Key".equals(name)) {
                ItemStack key;
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                TileEntityPortalKeyhole te = (TileEntityPortalKeyhole)world.func_175625_s(pos.func_177977_b());
                if (te != null && (key = te.getObjectInserted()).func_77973_b() instanceof ItemPortalKey) {
                    ((ItemPortalKey)key.func_77973_b()).activateKeyLevel2(world.func_73046_m(), key);
                    te.setContents(key);
                }
            } else if ("SummonWitch".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                DungeonPlacementLogicDebug.spawnEnemyHere(pos, "witch", world);
            } else if ("SummonWaterEnemy".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                int chance = rand.nextInt(100);
                if (chance < 80) {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "guardian", world);
                } else {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "drowned", world);
                }
            } else if ("SummonEnderman".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                DungeonPlacementLogicDebug.spawnEnemyHere(pos, "enderman", world);
            } else if ("SummonEnemy1".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                int chance = rand.nextInt(100);
                if (chance < 16) {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "zombie", world);
                } else if (chance < 32) {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "husk", world);
                } else if (chance < 48) {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "drowned", world);
                } else if (chance < 64) {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "spider", world);
                }
            } else if ("SummonEnemy2".equals(name)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                int chance = rand.nextInt(100);
                if (chance < 20) {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "wither_skeleton", world);
                } else if (chance < 40) {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "stray", world);
                } else if (chance < 60) {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "skeleton", world);
                } else if (chance < 80) {
                    DungeonPlacementLogicDebug.spawnEnemyHere(pos, "pillager", world);
                }
            } else {
                DimDungeons.logMessageWarn("UNHANDLED DATA BLOCK WITH name = " + name);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }

    private static void spawnEnemyHere(BlockPos pos, String casualName, ServerWorld world) {
        MobEntity mob = null;
        if ("witch".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200759_ay.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("enderman".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200803_q.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 2), (double)pos.func_177952_p());
        } else if ("guardian".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200761_A.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("zombie".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200725_aD.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("husk".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200763_C.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("drowned".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_204724_o.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("skeleton".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200741_ag.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("wither_skeleton".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200722_aA.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("stray".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200750_ap.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("spider".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_200748_an.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else if ("pillager".contentEquals(casualName)) {
            mob = (MobEntity)EntityType.field_220350_aJ.func_200721_a((World)world);
            mob.func_70107_b((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
        } else {
            System.out.println("DungeonChunkGenerator: Attempting to spawn unrecognized enemy: " + casualName);
            return;
        }
        mob.func_98053_h(false);
        mob.func_200203_b((ITextComponent)new TranslationTextComponent("enemy.dimdungeons." + casualName));
        mob.func_213390_a(pos, 8);
        mob.func_174828_a(pos, 0.0f, 0.0f);
        mob.func_110163_bv();
        mob.func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
        world.func_217376_c((Entity)mob);
    }

    private static void fillChestBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        DungeonPlacementLogicDebug.faceContainerTowardsAir(world, pos.func_177977_b());
        TileEntity te = world.func_175625_s(pos.func_177977_b());
        if (te instanceof ChestTileEntity) {
            ((ChestTileEntity)te).func_174888_l();
            ((ChestTileEntity)te).func_189404_a(lootTable, rand.nextLong());
        } else {
            DimDungeons.logMessageWarn("DIMDUNGEONS: FAILED TO PLACE CHEST IN DUNGEON. pos = " + pos.func_177958_n() + ", " + pos.func_177952_p());
        }
    }

    private static void fillBarrelBelow(BlockPos pos, ResourceLocation lootTable, IWorld world, Random rand) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        TileEntity te = world.func_175625_s(pos.func_177977_b());
        if (te instanceof BarrelTileEntity) {
            ((BarrelTileEntity)te).func_174888_l();
            ((BarrelTileEntity)te).func_189404_a(lootTable, rand.nextLong());
        } else {
            DimDungeons.logMessageError("DIMDUNGEONS: FAILED TO PLACE BARREL IN DUNGEON. pos = " + pos.func_177958_n() + ", " + pos.func_177952_p());
        }
    }

    private static ItemStack generateLuckyMessage(Random rand) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151164_bB);
        stack.func_77982_d(new CompoundNBT());
        int bookType = rand.nextInt(3);
        int messageVariation = rand.nextInt(8) + 1;
        String body = "";
        String title = "";
        if (bookType == 0) {
            title = new TranslationTextComponent("book.dimdungeons.title_1").getString();
            body = new TranslationTextComponent("book.dimdungeons.fun_message_" + messageVariation).getString();
        } else if (bookType == 1) {
            title = new TranslationTextComponent("book.dimdungeons.title_2").getString();
            body = new TranslationTextComponent("book.dimdungeons.helpful_message_" + messageVariation).getString();
        } else {
            title = new TranslationTextComponent("book.dimdungeons.title_3").getString();
            body = new TranslationTextComponent("book.dimdungeons.dangerous_message_" + messageVariation).getString();
        }
        ListNBT pages = new ListNBT();
        TranslationTextComponent text = new TranslationTextComponent(body);
        String json = ITextComponent.Serializer.func_150696_a((ITextComponent)text);
        pages.add(0, (INBT)StringNBT.func_229705_a_((String)json));
        stack.func_77978_p().func_74757_a("resolved", false);
        stack.func_77978_p().func_74768_a("generation", 0);
        stack.func_77978_p().func_218657_a("pages", (INBT)pages);
        stack.func_77978_p().func_74778_a("title", title);
        stack.func_77978_p().func_74778_a("author", new TranslationTextComponent("book.dimdungeons.author").getString());
        return stack;
    }

    private static void faceContainerTowardsAir(IWorld world, BlockPos pos) {
        BlockState bs = world.func_180495_p(pos);
        if (bs.func_177230_c() == Blocks.field_150367_z || bs.func_177230_c() == Blocks.field_150486_ae) {
            if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == Blocks.field_150350_a) {
                // empty if block
            }
            world.func_180501_a(pos, bs, 2);
        }
    }
}

