/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.utils;

import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CommandDimDungeons {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder givekeyArgumentBuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"givekey").requires(cmd -> cmd.func_197034_c(2));
        String[] keytypes = new String[]{"blank", "basic", "advanced"};
        for (int i = 0; i < keytypes.length; ++i) {
            String type = keytypes[i];
            givekeyArgumentBuilder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)type).executes(cmd -> CommandDimDungeons.giveKey((CommandContext<CommandSource>)cmd, Collections.singleton(((CommandSource)cmd.getSource()).func_197035_h()), type, 0))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).executes(cmd -> CommandDimDungeons.giveKey((CommandContext<CommandSource>)cmd, EntityArgument.func_197090_e((CommandContext)cmd, (String)"target"), type, 0))).then(Commands.func_197056_a((String)"theme", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(cmd -> CommandDimDungeons.giveKey((CommandContext<CommandSource>)cmd, EntityArgument.func_197090_e((CommandContext)cmd, (String)"target"), type, IntegerArgumentType.getInteger((CommandContext)cmd, (String)"theme"))))));
        }
        dispatcher.register(givekeyArgumentBuilder);
        LiteralArgumentBuilder gendungeonArgumentBuilder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"gendungeon").requires(cmd -> cmd.func_197034_c(2));
        gendungeonArgumentBuilder.then(Commands.func_197056_a((String)"x", (ArgumentType)IntegerArgumentType.integer((int)0, (int)8192)).then(Commands.func_197056_a((String)"z", (ArgumentType)IntegerArgumentType.integer((int)-8192, (int)8192)).executes(cmd -> CommandDimDungeons.generateDungeon((CommandContext<CommandSource>)cmd, IntegerArgumentType.getInteger((CommandContext)cmd, (String)"x"), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"z")))));
        dispatcher.register(gendungeonArgumentBuilder);
    }

    private static int giveKey(CommandContext<CommandSource> cmd, Collection<ServerPlayerEntity> targets, String type, int theme) throws CommandSyntaxException {
        TranslationTextComponent keyName = new TranslationTextComponent("item.dimdungeons.item_portal_key");
        for (ServerPlayerEntity serverplayerentity : targets) {
            ItemEntity itementity;
            ItemStack stack = new ItemStack((IItemProvider)ItemRegistrar.item_portal_key);
            if ("blank".equals(type)) {
                keyName = new TranslationTextComponent("item.dimdungeons.item_portal_key");
            } else if ("basic".equals(type)) {
                ((ItemPortalKey)ItemRegistrar.item_portal_key.func_199767_j()).activateKeyLevel1(((CommandSource)cmd.getSource()).func_197028_i(), stack, theme);
                keyName = new TranslationTextComponent("item.dimdungeons.item_portal_key_basic");
            } else if ("advanced".equals(type)) {
                ((ItemPortalKey)ItemRegistrar.item_portal_key.func_199767_j()).activateKeyLevel2(((CommandSource)cmd.getSource()).func_197028_i(), stack);
                keyName = new TranslationTextComponent("item.dimdungeons.item_portal_key_advanced");
            }
            boolean flag = serverplayerentity.field_71071_by.func_70441_a(stack);
            if (flag && stack.func_190926_b()) {
                stack.func_190920_e(1);
                itementity = serverplayerentity.func_71019_a(stack, false);
                if (itementity != null) {
                    itementity.func_174870_v();
                }
                serverplayerentity.field_70170_p.func_184148_a((PlayerEntity)null, serverplayerentity.func_226277_ct_(), serverplayerentity.func_226278_cu_(), serverplayerentity.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((serverplayerentity.func_70681_au().nextFloat() - serverplayerentity.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverplayerentity.field_71069_bz.func_75142_b();
                continue;
            }
            itementity = serverplayerentity.func_71019_a(stack, false);
            if (itementity == null) continue;
            itementity.func_174868_q();
            itementity.func_200217_b(serverplayerentity.func_110124_au());
        }
        if (targets.size() == 1) {
            ((CommandSource)cmd.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.give.success.single", new Object[]{1, keyName, targets.iterator().next().func_145748_c_()}), true);
        } else {
            ((CommandSource)cmd.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.give.success.single", new Object[]{1, keyName, targets.size()}), true);
        }
        return targets.size();
    }

    private static int generateDungeon(CommandContext<CommandSource> cmd, int destX, int destZ) throws CommandSyntaxException {
        DungeonGenData fakeData = new DungeonGenData();
        if (cmd.getSource() != null) {
            fakeData.setReturnPoint(new BlockPos(((CommandSource)cmd.getSource()).func_197036_d().field_72450_a, ((CommandSource)cmd.getSource()).func_197036_d().field_72448_b + 2.0, ((CommandSource)cmd.getSource()).func_197036_d().field_72449_c), "minecraft:overworld");
        } else {
            fakeData.setReturnPoint(new BlockPos(0, 100, 0), "minecraft:overworld");
        }
        ItemStack fakeKey = new ItemStack((IItemProvider)ItemRegistrar.item_portal_key);
        ((ItemPortalKey)ItemRegistrar.item_portal_key.func_199767_j()).forceCoordinates(fakeKey, destX, destZ);
        fakeData.setKeyItem(fakeKey);
        if (DungeonUtils.buildDungeon((World)((CommandSource)cmd.getSource()).func_197023_e(), fakeData)) {
            ((CommandSource)cmd.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendungeon.success", new Object[]{fakeKey.func_200301_q()}), true);
            return 1;
        }
        ((CommandSource)cmd.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendungeon.failed"), true);
        return 0;
    }
}

