/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.utils;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.structure.DungeonPlacementLogicAdvanced;
import com.catastrophe573.dimdungeons.structure.DungeonPlacementLogicBasic;
import com.catastrophe573.dimdungeons.structure.DungeonPlacementLogicDebug;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import net.minecraft.block.BlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DungeonUtils {
    public static boolean isDimensionOverworld(World worldIn) {
        return worldIn.func_234923_W_() == World.field_234918_g_;
    }

    public static boolean isDimensionDungeon(World worldIn) {
        if (worldIn == null) {
            DimDungeons.logMessageError("FATAL ERROR: This 1.16 port is still broken.");
            return false;
        }
        return worldIn.func_234923_W_().func_240901_a_().func_110623_a() == "dungeon_dimension";
    }

    public static ServerWorld getDungeonWorld(MinecraftServer server) {
        return server.func_71218_a(DimDungeons.DUNGEON_DIMENSION);
    }

    public static boolean buildDungeon(World worldIn, DungeonGenData genData) {
        if (worldIn.field_72995_K) {
            return false;
        }
        if (!(genData.keyItem.func_77973_b() instanceof ItemPortalKey)) {
            DimDungeons.logMessageError("FATAL ERROR: Using a non-key item to build a dungeon? What happened?");
            return false;
        }
        ItemPortalKey key = (ItemPortalKey)genData.keyItem.func_77973_b();
        long buildX = key.getDungeonTopLeftX(genData.keyItem);
        long buildZ = key.getDungeonTopLeftZ(genData.keyItem);
        long entranceX = buildX + 128L;
        long entranceZ = buildZ + 176L;
        ServerWorld dungeonWorld = DungeonUtils.getDungeonWorld(worldIn.func_73046_m());
        if (DungeonUtils.dungeonAlreadyExistsHere((World)dungeonWorld, entranceX, entranceZ)) {
            DimDungeons.logMessageWarn("DIMDUNGEONS: Cancelling dungeon contruction. A dungeon already exists here.");
            return false;
        }
        if (genData.keyItem.func_82837_s() && DungeonConfig.enableDebugCheats) {
            String name = genData.keyItem.func_200301_q().func_150261_e();
            if (name.contentEquals("DebugOne")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 1, genData);
                return true;
            }
            if (name.contentEquals("DebugTwo")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 2, genData);
                return true;
            }
            if (name.contentEquals("DebugThree")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 3, genData);
                return true;
            }
            if (name.contentEquals("DebugFour")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 4, genData);
                return true;
            }
            if (name.contentEquals("bas-4")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 5, genData);
                return true;
            }
            if (name.contentEquals("bas-3")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 6, genData);
                return true;
            }
            if (name.contentEquals("bas-h")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 7, genData);
                return true;
            }
            if (name.contentEquals("bas-c")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 8, genData);
                return true;
            }
            if (name.contentEquals("bas-1")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 9, genData);
                return true;
            }
            if (name.contentEquals("adv-4")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 10, genData);
                return true;
            }
            if (name.contentEquals("adv-3")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 11, genData);
                return true;
            }
            if (name.contentEquals("adv-h")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 12, genData);
                return true;
            }
            if (name.contentEquals("adv-c")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 13, genData);
                return true;
            }
            if (name.contentEquals("adv-1")) {
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 14, genData);
                return true;
            }
            if (name.contains("theme-")) {
                String themeStr = name.replaceFirst("theme-", "");
                genData.dungeonTheme = Integer.parseUnsignedInt(themeStr);
                DungeonPlacementLogicDebug.place(dungeonWorld, buildX, buildZ, 15, genData);
                return true;
            }
        }
        if (DungeonPlacementLogicBasic.isEntranceChunk(entranceX / 16L, entranceZ / 16L)) {
            DungeonPlacementLogicBasic.place(dungeonWorld, buildX, buildZ, genData);
            return true;
        }
        if (DungeonPlacementLogicAdvanced.isEntranceChunk(entranceX / 16L, entranceZ / 16L)) {
            DungeonPlacementLogicAdvanced.place(dungeonWorld, buildX, buildZ, genData);
            return true;
        }
        DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: trying to build a dungeon at coordinates where no dungeon is supposed to start?");
        return false;
    }

    public static boolean dungeonAlreadyExistsHere(World worldIn, long entranceX, long entranceZ) {
        BlockState temp = worldIn.func_180495_p(new BlockPos((double)entranceX, 51.0, (double)entranceZ));
        return !temp.func_196958_f();
    }

    public static boolean reprogramExistingExitDoorway(World worldIn, long entranceX, long entranceZ, DungeonGenData genData) {
        ServerWorld ddim = DungeonUtils.getDungeonWorld(worldIn.func_73046_m());
        int zoffset = entranceZ < 0L ? 1 : 2;
        for (int x = 0; x <= 1; ++x) {
            for (int y = 55; y <= 57; ++y) {
                BlockPos pos = new BlockPos((double)(entranceX - (long)x), (double)y, (double)(entranceZ + (long)zoffset));
                TileEntityGoldPortal te = (TileEntityGoldPortal)ddim.func_175625_s(pos);
                if (te == null) {
                    DimDungeons.logMessageWarn("DIMDUNGEONS WARNING: why is there no exit portal here? (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")");
                    return false;
                }
                te.setDestination((double)genData.returnPoint.func_177958_n() + 0.5, (double)genData.returnPoint.func_177956_o() + 0.1, (double)genData.returnPoint.func_177952_p() + 0.5, genData.returnDimension);
            }
        }
        return true;
    }

    public static String serializeDimensionKey(RegistryKey<World> dimension) {
        return dimension.func_240901_a_().func_110624_b() + ":" + dimension.func_240901_a_().func_110623_a();
    }

    public static int getLimitOfWorldBorder(MinecraftServer server) {
        int block_limit = 0x200000;
        RegistryKey configkey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(DungeonConfig.worldborderToRespect));
        ServerWorld world = server.func_71218_a(configkey);
        double size = world.func_175723_af().func_177741_h() / 2.0;
        if (size < (double)block_limit) {
            return (int)(Math.round(size) / 256L);
        }
        return 8192;
    }
}

