/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyItemGroups;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.registry.Accessory;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.item.ChangeOwnerItem;
import doggytalents.common.item.ChewStickItem;
import doggytalents.common.item.DogShearsItem;
import doggytalents.common.item.DoggyCharmItem;
import doggytalents.common.item.DroolBoneItem;
import doggytalents.common.item.DyeableAccessoryItem;
import doggytalents.common.item.RadarItem;
import doggytalents.common.item.SizeBoneItem;
import doggytalents.common.item.ThrowableItem;
import doggytalents.common.item.TreatBagItem;
import doggytalents.common.item.TreatItem;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.util.Util;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DoggyItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"doggytalents");
    public static final RegistryObject<Item> THROW_BONE = DoggyItems.registerThrowBone("throw_bone");
    public static final RegistryObject<Item> THROW_BONE_WET = DoggyItems.registerThrowBoneWet("throw_bone_wet");
    public static final RegistryObject<Item> THROW_STICK = DoggyItems.registerThrowStick("throw_stick");
    public static final RegistryObject<Item> THROW_STICK_WET = DoggyItems.registerThrowStickWet("throw_stick_wet");
    public static final RegistryObject<Item> TRAINING_TREAT = DoggyItems.registerTreat("training_treat", DogLevel.Type.NORMAL, 20);
    public static final RegistryObject<Item> SUPER_TREAT = DoggyItems.registerTreat("super_treat", DogLevel.Type.NORMAL, 40);
    public static final RegistryObject<Item> MASTER_TREAT = DoggyItems.registerTreat("master_treat", DogLevel.Type.NORMAL, 60);
    public static final RegistryObject<Item> DIRE_TREAT = DoggyItems.registerTreat("dire_treat", DogLevel.Type.DIRE, 30);
    public static final RegistryObject<Item> BREEDING_BONE = DoggyItems.register("breeding_bone");
    public static final RegistryObject<Item> COLLAR_SHEARS = DoggyItems.registerWith("collar_shears", DogShearsItem::new, 1);
    public static final RegistryObject<Item> DOGGY_CHARM = DoggyItems.registerWith("doggy_charm", DoggyCharmItem::new, 1);
    public static final RegistryObject<AccessoryItem> RADIO_COLLAR = DoggyItems.registerAccessory("radio_collar", DoggyAccessories.RADIO_BAND);
    public static final RegistryObject<DyeableAccessoryItem> WOOL_COLLAR = DoggyItems.registerAccessoryDyed("wool_collar", DoggyAccessories.DYEABLE_COLLAR);
    public static final RegistryObject<AccessoryItem> CREATIVE_COLLAR = DoggyItems.registerAccessory("creative_collar", DoggyAccessories.GOLDEN_COLLAR);
    public static final RegistryObject<AccessoryItem> SPOTTED_COLLAR = DoggyItems.registerAccessory("spotted_collar", DoggyAccessories.SPOTTED_COLLAR);
    public static final RegistryObject<AccessoryItem> MULTICOLOURED_COLLAR = DoggyItems.registerAccessory("multicoloured_collar", DoggyAccessories.MULTICOLORED_COLLAR);
    public static final RegistryObject<Item> RADAR = DoggyItems.registerWith("radar", RadarItem::new, 1);
    public static final RegistryObject<Item> CREATIVE_RADAR = DoggyItems.registerWith("creative_radar", RadarItem::new, 1);
    public static final RegistryObject<Item> WHISTLE = DoggyItems.registerWith("whistle", WhistleItem::new, 1);
    public static final RegistryObject<Item> TREAT_BAG = DoggyItems.registerWith("treat_bag", TreatBagItem::new, 1);
    public static final RegistryObject<Item> CHEW_STICK = DoggyItems.register("chew_stick", ChewStickItem::new);
    public static final RegistryObject<AccessoryItem> CAPE = DoggyItems.registerAccessory("cape", DoggyAccessories.CAPE);
    public static final RegistryObject<DyeableAccessoryItem> CAPE_COLOURED = DoggyItems.registerAccessoryDyed("cape_coloured", DoggyAccessories.DYEABLE_CAPE);
    public static final RegistryObject<AccessoryItem> SUNGLASSES = DoggyItems.registerAccessory("sunglasses", DoggyAccessories.SUNGLASSES);
    public static final RegistryObject<AccessoryItem> GUARD_SUIT = DoggyItems.registerAccessory("guard_suit", DoggyAccessories.GUARD_SUIT);
    public static final RegistryObject<AccessoryItem> LEATHER_JACKET = DoggyItems.registerAccessory("leather_jacket", DoggyAccessories.LEATHER_JACKET_CLOTHING);
    public static final RegistryObject<Item> TINY_BONE = DoggyItems.registerSizeBone("tiny_bone", SizeBoneItem.Type.TINY);
    public static final RegistryObject<Item> BIG_BONE = DoggyItems.registerSizeBone("big_bone", SizeBoneItem.Type.BIG);
    public static final RegistryObject<Item> OWNER_CHANGE = DoggyItems.registerWith("owner_change", ChangeOwnerItem::new, 1);

    private static Item.Properties createInitialProp() {
        return new Item.Properties().m_41491_(DoggyItemGroups.GENERAL);
    }

    private static RegistryObject<Item> registerThrowBone(String name) {
        return DoggyItems.register(name, () -> new ThrowableItem((Supplier<? extends Item>)THROW_BONE_WET, (Supplier<? extends Item>)Items.f_42500_.delegate, DoggyItems.createInitialProp().m_41487_(2)));
    }

    private static RegistryObject<Item> registerThrowStick(String name) {
        return DoggyItems.register(name, () -> new ThrowableItem((Supplier<? extends Item>)THROW_STICK_WET, (Supplier<? extends Item>)THROW_STICK, DoggyItems.createInitialProp().m_41487_(8)));
    }

    private static RegistryObject<Item> registerThrowBoneWet(String name) {
        return DoggyItems.register(name, () -> new DroolBoneItem((Supplier<? extends Item>)THROW_BONE, DoggyItems.createInitialProp().m_41487_(1)));
    }

    private static RegistryObject<Item> registerThrowStickWet(String name) {
        return DoggyItems.register(name, () -> new DroolBoneItem((Supplier<? extends Item>)THROW_STICK, DoggyItems.createInitialProp().m_41487_(1)));
    }

    private static RegistryObject<Item> registerSizeBone(String name, SizeBoneItem.Type typeIn) {
        return DoggyItems.register(name, () -> new SizeBoneItem(typeIn, DoggyItems.createInitialProp()));
    }

    private static RegistryObject<Item> registerTreat(String name, DogLevel.Type typeIn, int maxLevel) {
        return DoggyItems.register(name, () -> new TreatItem(maxLevel, typeIn, DoggyItems.createInitialProp()));
    }

    private static RegistryObject<DyeableAccessoryItem> registerAccessoryDyed(String name, Supplier<? extends DyeableAccessory> type) {
        return DoggyItems.register(name, () -> new DyeableAccessoryItem(type, DoggyItems.createInitialProp()));
    }

    private static RegistryObject<AccessoryItem> registerAccessory(String name, Supplier<? extends Accessory> type) {
        return DoggyItems.register(name, () -> new AccessoryItem(type, DoggyItems.createInitialProp()));
    }

    private static <T extends Item> RegistryObject<T> registerWith(String name, Function<Item.Properties, T> itemConstructor, int maxStackSize) {
        return DoggyItems.register(name, () -> (Item)itemConstructor.apply(DoggyItems.createInitialProp().m_41487_(maxStackSize)));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Function<Item.Properties, T> itemConstructor) {
        return DoggyItems.register(name, () -> (Item)itemConstructor.apply(DoggyItems.createInitialProp()));
    }

    private static RegistryObject<Item> register(String name) {
        return DoggyItems.registerWith(name, null);
    }

    private static RegistryObject<Item> registerWith(String name, @Nullable Function<Item.Properties, Item.Properties> extraPropFunc) {
        Item.Properties prop = DoggyItems.createInitialProp();
        return DoggyItems.register(name, () -> new Item(extraPropFunc != null ? (Item.Properties)extraPropFunc.apply(prop) : prop));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> sup) {
        return ITEMS.register(name, sup);
    }

    public static void registerItemColours(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        Util.acceptOrElse(WOOL_COLLAR, item -> itemColors.m_92689_((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{item}), DoggyBlocks::logError);
        Util.acceptOrElse(CAPE_COLOURED, item -> itemColors.m_92689_((stack, tintIndex) -> tintIndex > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{item}), DoggyBlocks::logError);
        Util.acceptOrElse(DoggyBlocks.DOG_BATH, item -> itemColors.m_92689_((stack, tintIndex) -> 4159204, new ItemLike[]{item}), DoggyBlocks::logError);
    }
}

