/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.impl.MissingBeddingMaterial;
import doggytalents.api.impl.MissingCasingMissing;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.api.registry.Talent;
import doggytalents.common.util.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class DoggyRegistries {
    public static void newRegistry(RegistryEvent.NewRegistry event) {
        DoggyTalentsAPI.TALENTS = DoggyRegistries.makeRegistry("talents", Talent.class).create();
        DoggyTalentsAPI.ACCESSORIES = DoggyRegistries.makeRegistry("accessories", Accessory.class).create();
        DoggyTalentsAPI.ACCESSORY_TYPE = DoggyRegistries.makeRegistry("accessory_type", AccessoryType.class).disableSync().create();
        DoggyTalentsAPI.BEDDING_MATERIAL = DoggyRegistries.makeRegistry("bedding", IBeddingMaterial.class).addCallback((Object)BeddingCallbacks.INSTANCE).create();
        DoggyTalentsAPI.CASING_MATERIAL = DoggyRegistries.makeRegistry("casing", ICasingMaterial.class).addCallback((Object)CasingCallbacks.INSTANCE).create();
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(String name, Class<T> type) {
        return new RegistryBuilder().setName(Util.getResource(name)).setType(type);
    }

    private static class BeddingCallbacks
    implements IForgeRegistry.DummyFactory<IBeddingMaterial> {
        static final BeddingCallbacks INSTANCE = new BeddingCallbacks();

        private BeddingCallbacks() {
        }

        public IBeddingMaterial createDummy(ResourceLocation key) {
            return (IBeddingMaterial)new MissingBeddingMaterial().setRegistryName(key);
        }
    }

    private static class CasingCallbacks
    implements IForgeRegistry.DummyFactory<ICasingMaterial> {
        static final CasingCallbacks INSTANCE = new CasingCallbacks();

        private CasingCallbacks() {
        }

        public ICasingMaterial createDummy(ResourceLocation key) {
            return (ICasingMaterial)new MissingCasingMissing().setRegistryName(key);
        }
    }
}

