/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

public class Accessory
extends ForgeRegistryEntry<Accessory> {
    @Nullable
    private String translationKey;
    @Deprecated
    private final Supplier<ItemStack> stack;
    @Deprecated
    private final Supplier<? extends AccessoryType> type;
    private ResourceLocation modelTexture;
    private String renderer;

    public Accessory(Supplier<? extends AccessoryType> typeIn, Supplier<ItemStack> stackIn, int x) {
        this.type = typeIn;
        this.stack = stackIn;
    }

    public Accessory(Supplier<? extends AccessoryType> typeIn, Supplier<? extends ItemLike> itemIn) {
        this(typeIn, () -> new ItemStack((ItemLike)itemIn.get()), 0);
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.m_137492_((String)"accessory", (ResourceLocation)DoggyTalentsAPI.ACCESSORIES.getKey((IForgeRegistryEntry)this));
        }
        return this.translationKey;
    }

    public byte getRenderLayer() {
        return 0;
    }

    public AccessoryInstance getDefault() {
        return new AccessoryInstance(this);
    }

    public AccessoryInstance createInstance(FriendlyByteBuf buf) {
        return this.getDefault();
    }

    public AccessoryInstance read(CompoundTag compound) {
        return this.getDefault();
    }

    public void write(AccessoryInstance instance, FriendlyByteBuf buf) {
    }

    public void write(AccessoryInstance instance, CompoundTag compound) {
    }

    public AccessoryInstance createFromStack(ItemStack stackIn) {
        return this.getDefault();
    }

    public ItemStack getReturnItem(AccessoryInstance instance) {
        return this.stack.get();
    }

    public final AccessoryType getType() {
        return this.type.get();
    }

    public <T extends Accessory> boolean of(Supplier<T> accessoryIn) {
        return this.of((Accessory)((Object)accessoryIn.get()));
    }

    public <T extends Accessory> boolean of(T accessoryIn) {
        return this.of(accessoryIn.delegate);
    }

    public <T extends Accessory> boolean of(IRegistryDelegate<T> accessoryDelegateIn) {
        return accessoryDelegateIn.equals((Object)this.delegate);
    }

    public <T extends Accessory> T setModelTexture(ResourceLocation modelTextureIn) {
        this.modelTexture = modelTextureIn;
        return (T)((Object)this);
    }

    @Nullable
    public ResourceLocation getModelTexture() {
        return this.modelTexture;
    }

    public <T extends Accessory> T setRenderer(String rendererIn) {
        this.renderer = rendererIn;
        return (T)((Object)this);
    }

    @Nullable
    public boolean usesRenderer(Class layer) {
        return Objects.equals(this.renderer, layer.getSimpleName());
    }
}

