/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.api.inferface.IColoredObject;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogModel;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.entity.accessory.ArmourAccessory;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ArmorAccessoryRenderer
extends RenderLayer<DogEntity, DogModel<DogEntity>> {
    private DogModel model;

    public ArmorAccessoryRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super(parentRenderer);
        this.model = new DogModel(ctx.m_174023_(ClientSetup.DOG_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, DogEntity dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!dog.m_21824_() || dog.m_20145_()) {
            return;
        }
        ((DogModel)this.m_117386_()).m_102624_((EntityModel)this.model);
        this.model.prepareMobModel(dog, limbSwing, limbSwingAmount, partialTicks);
        this.model.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        for (AccessoryInstance accessoryInst : dog.getAccessories()) {
            AccessoryInstance accessoryInstance = accessoryInst;
            if (!(accessoryInstance instanceof ArmourAccessory.Instance)) continue;
            ArmourAccessory.Instance armorInst = (ArmourAccessory.Instance)accessoryInstance;
            this.model.setVisible(false);
            if (accessoryInst.ofType(DoggyAccessoryTypes.FEET)) {
                this.model.legBackLeft.f_104207_ = true;
                this.model.legBackRight.f_104207_ = true;
                this.model.legFrontLeft.f_104207_ = true;
                this.model.legFrontRight.f_104207_ = true;
            } else if (accessoryInst.ofType(DoggyAccessoryTypes.HEAD)) {
                this.model.head.f_104207_ = true;
            } else if (accessoryInst.ofType(DoggyAccessoryTypes.CLOTHING)) {
                this.model.body.f_104207_ = true;
                this.model.mane.f_104207_ = true;
            } else if (accessoryInst.ofType(DoggyAccessoryTypes.TAIL)) {
                this.model.tail.f_104207_ = true;
            }
            if (accessoryInst instanceof IColoredObject) {
                float[] color = ((IColoredObject)((Object)armorInst)).getColor();
                ArmorAccessoryRenderer.renderArmorCutout(this.model, armorInst.getModelTexture(dog), poseStack, buffer, packedLight, dog, color[0], color[1], color[2], armorInst.hasEffect());
                continue;
            }
            ArmorAccessoryRenderer.renderArmorCutout(this.model, armorInst.getModelTexture(dog), poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, armorInst.hasEffect());
        }
    }

    public static <T extends LivingEntity> void renderArmorCutout(EntityModel<T> modelIn, ResourceLocation textureLocationIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entityIn, float red, float green, float blue, boolean enchanted) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115184_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110431_((ResourceLocation)textureLocationIn), (boolean)false, (boolean)enchanted);
        modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }
}

