/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.DogEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class BedFinderRenderer {
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (Entity passenger : player.m_20197_()) {
            DogEntity dog;
            Optional<BlockPos> bedPosOpt;
            if (!(passenger instanceof DogEntity) || !(bedPosOpt = (dog = (DogEntity)passenger).getBedPos()).isPresent()) continue;
            BlockPos bedPos = bedPosOpt.get();
            int level = dog.getLevel((Supplier)DoggyTalents.BED_FINDER);
            double distance = (double)level * 200.0 - Math.sqrt(bedPos.m_123331_((Vec3i)dog.m_142538_()));
            if (level != 5 && !(distance >= 0.0)) continue;
            PoseStack stack = event.getMatrixStack();
            AABB boundingBox = new AABB(bedPos).m_82400_(0.5);
            BedFinderRenderer.drawSelectionBox(stack, boundingBox);
        }
    }

    public static void drawSelectionBox(PoseStack stack, AABB boundingBox) {
        RenderSystem.m_157427_(GameRenderer::m_172757_);
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69472_();
        Vec3 vec3d = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double d0 = vec3d.m_7096_();
        double d1 = vec3d.m_7098_();
        double d2 = vec3d.m_7094_();
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        buf.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_166851_);
        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)buf, (AABB)boundingBox.m_82386_(-d0, -d1, -d2), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        buf.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buf);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}

