/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.DoggyAccessories;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.Talent;
import doggytalents.client.DogTextureManager;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogModeData;
import doggytalents.common.network.packet.data.DogNameData;
import doggytalents.common.network.packet.data.DogObeyData;
import doggytalents.common.network.packet.data.DogTalentData;
import doggytalents.common.network.packet.data.DogTextureData;
import doggytalents.common.network.packet.data.FriendlyFireData;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class DogInfoScreen
extends Screen {
    public final DogEntity dog;
    public final Player player;
    private int currentPage = 0;
    private int maxPages = 1;
    private List<AbstractWidget> talentWidgets = new ArrayList<AbstractWidget>(16);
    private Button leftBtn;
    private Button rightBtn;
    private List<Talent> talentList;
    private List<ResourceLocation> customSkinList;
    public int textureIndex;

    public DogInfoScreen(DogEntity dog, Player player) {
        super((Component)new TranslatableComponent("doggytalents.screen.dog.title"));
        this.dog = dog;
        this.player = player;
        this.talentList = DoggyTalentsAPI.TALENTS.getValues().stream().sorted(Comparator.comparing(t -> I18n.m_118938_((String)t.getTranslationKey(), (Object[])new Object[0]))).collect(Collectors.toList());
        this.customSkinList = DogTextureManager.INSTANCE.getAll();
        this.textureIndex = this.customSkinList.indexOf(DogTextureManager.INSTANCE.getTextureLoc(dog.getSkinHash()));
        this.textureIndex = this.textureIndex >= 0 ? this.textureIndex : 0;
    }

    public static void open(DogEntity dog) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new DogInfoScreen(dog, (Player)mc.f_91074_));
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        int topX = this.f_96543_ / 2;
        int topY = this.f_96544_ / 2;
        EditBox nameTextField = new EditBox(this.f_96547_, topX - 100, topY + 50, 200, 20, (Component)new TranslatableComponent("dogInfo.enterName"));
        nameTextField.m_94151_(text -> PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogNameData(this.dog.m_142049_(), (String)text)));
        nameTextField.m_94178_(false);
        nameTextField.m_94199_(32);
        if (this.dog.m_8077_()) {
            nameTextField.m_94144_(this.dog.m_7770_().m_6111_());
        }
        this.m_142416_((GuiEventListener)nameTextField);
        if (this.dog.m_21830_((LivingEntity)this.player)) {
            Button obeyBtn = new Button(this.f_96543_ - 64, topY + 77, 42, 20, (Component)new TextComponent(String.valueOf(this.dog.willObeyOthers())), btn -> {
                btn.m_93666_((Component)new TextComponent(String.valueOf(!this.dog.willObeyOthers())));
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogObeyData(this.dog.m_142049_(), !this.dog.willObeyOthers()));
            });
            this.m_142416_((GuiEventListener)obeyBtn);
        }
        Button attackPlayerBtn = new Button(this.f_96543_ - 64, topY - 5, 42, 20, (Component)new TextComponent(String.valueOf(this.dog.canPlayersAttack())), button -> {
            button.m_93666_((Component)new TextComponent(String.valueOf(!this.dog.canPlayersAttack())));
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new FriendlyFireData(this.dog.m_142049_(), !this.dog.canPlayersAttack()));
        });
        this.m_142416_((GuiEventListener)attackPlayerBtn);
        Button addBtn = new Button(this.f_96543_ - 42, topY + 30, 20, 20, (Component)new TextComponent("+"), btn -> {
            ++this.textureIndex;
            this.textureIndex %= this.customSkinList.size();
            ResourceLocation rl = this.customSkinList.get(this.textureIndex);
            this.setDogTexture(rl);
        });
        Button lessBtn = new Button(this.f_96543_ - 64, topY + 30, 20, 20, (Component)new TextComponent("-"), btn -> {
            this.textureIndex += this.customSkinList.size() - 1;
            this.textureIndex %= this.customSkinList.size();
            ResourceLocation rl = this.customSkinList.get(this.textureIndex);
            this.setDogTexture(rl);
        });
        this.m_142416_((GuiEventListener)addBtn);
        this.m_142416_((GuiEventListener)lessBtn);
        Button modeBtn = new Button(topX + 40, topY + 25, 60, 20, (Component)new TranslatableComponent(this.dog.getMode().getUnlocalisedName()), button -> {
            EnumMode mode = this.dog.getMode().nextMode();
            if (mode == EnumMode.WANDERING && !this.dog.getBowlPos().isPresent()) {
                button.m_93666_((Component)new TranslatableComponent(mode.getUnlocalisedName()).m_130940_(ChatFormatting.RED));
            } else {
                button.m_93666_((Component)new TranslatableComponent(mode.getUnlocalisedName()));
            }
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogModeData(this.dog.m_142049_(), mode));
        }){

            public void m_7428_(PoseStack stack, int mouseX, int mouseY) {
                ArrayList<Object> list = new ArrayList<Object>();
                String str = I18n.m_118938_((String)DogInfoScreen.this.dog.getMode().getUnlocalisedInfo(), (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, DogInfoScreen.this.f_96547_));
                if (DogInfoScreen.this.dog.getMode() == EnumMode.WANDERING) {
                    if (DogInfoScreen.this.dog.getBowlPos().isPresent()) {
                        double distance = DogInfoScreen.this.dog.m_142538_().m_123331_((Vec3i)DogInfoScreen.this.dog.getBowlPos().get());
                        if (distance > 256.0) {
                            list.add(new TranslatableComponent("dog.mode.docile.distance", new Object[]{(int)Math.sqrt(distance)}).m_130940_(ChatFormatting.RED));
                        } else {
                            list.add(new TranslatableComponent("dog.mode.docile.bowl", new Object[]{(int)Math.sqrt(distance)}).m_130940_(ChatFormatting.GREEN));
                        }
                    } else {
                        list.add(new TranslatableComponent("dog.mode.docile.nobowl").m_130940_(ChatFormatting.RED));
                    }
                }
                DogInfoScreen.this.m_96597_(stack, list, mouseX, mouseY);
            }
        };
        this.m_142416_((GuiEventListener)modeBtn);
        int size = DoggyTalentsAPI.TALENTS.getKeys().size();
        int perPage = Math.max(Mth.m_14107_((double)((double)(this.f_96544_ - 10) / 21.0)) - 2, 1);
        this.currentPage = 0;
        this.recalculatePage(perPage);
        if (perPage < size) {
            this.leftBtn = new Button(25, perPage * 21 + 10, 20, 20, (Component)new TextComponent("<"), btn -> {
                this.currentPage = Math.max(0, this.currentPage - 1);
                btn.f_93623_ = this.currentPage > 0;
                this.rightBtn.f_93623_ = true;
                this.recalculatePage(perPage);
            }){

                public void m_7428_(PoseStack stack, int mouseX, int mouseY) {
                    DogInfoScreen.this.m_96602_(stack, (Component)new TranslatableComponent("doggui.prevpage").m_130940_(ChatFormatting.ITALIC), mouseX, mouseY);
                }
            };
            this.leftBtn.f_93623_ = false;
            this.rightBtn = new Button(48, perPage * 21 + 10, 20, 20, (Component)new TextComponent(">"), btn -> {
                this.currentPage = Math.min(this.maxPages - 1, this.currentPage + 1);
                btn.f_93623_ = this.currentPage < this.maxPages - 1;
                this.leftBtn.f_93623_ = true;
                this.recalculatePage(perPage);
            }){

                public void m_7428_(PoseStack stack, int mouseX, int mouseY) {
                    DogInfoScreen.this.m_96602_(stack, (Component)new TranslatableComponent("doggui.nextpage").m_130940_(ChatFormatting.ITALIC), mouseX, mouseY);
                }
            };
            this.m_142416_((GuiEventListener)this.leftBtn);
            this.m_142416_((GuiEventListener)this.rightBtn);
        }
    }

    private void setDogTexture(ResourceLocation rl) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTextureData(this.dog.m_142049_(), DogTextureManager.INSTANCE.getTextureHash(rl)));
    }

    private void recalculatePage(int perPage) {
        int index;
        this.talentWidgets.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.talentWidgets.clear();
        this.maxPages = Mth.m_14165_((double)((double)this.talentList.size() / (double)perPage));
        for (int i = 0; i < perPage && (index = this.currentPage * perPage + i) < this.talentList.size(); ++i) {
            Talent talent = this.talentList.get(index);
            TalentButton button = new TalentButton(25, 10 + i * 21, 20, 20, (Component)new TextComponent("+"), talent, btn -> {
                int level = this.dog.getLevel(talent);
                if (level < talent.getMaxLevel() && this.dog.canSpendPoints(talent.getLevelCost(level + 1))) {
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTalentData(this.dog.m_142049_(), talent));
                }
            }){

                public void m_7428_(PoseStack stack, int mouseX, int mouseY) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(new TranslatableComponent(this.talent.getTranslationKey()).m_130940_(ChatFormatting.GREEN));
                    if (this.f_93623_) {
                        list.add(new TextComponent("Level: " + DogInfoScreen.this.dog.getLevel(this.talent)));
                        list.add(new TextComponent("--------------------------------").m_130940_(ChatFormatting.GRAY));
                        list.addAll(ScreenUtil.splitInto(I18n.m_118938_((String)this.talent.getInfoTranslationKey(), (Object[])new Object[0]), 200, DogInfoScreen.this.f_96547_));
                    } else {
                        list.add(new TextComponent("Talent disabled").m_130940_(ChatFormatting.RED));
                    }
                    DogInfoScreen.this.m_96597_(stack, list, mouseX, mouseY);
                }
            };
            button.f_93623_ = ConfigHandler.TALENT.getFlag(talent);
            this.talentWidgets.add((AbstractWidget)button);
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int topX = this.f_96543_ / 2;
        int topY = this.f_96544_ / 2;
        this.m_7333_(stack);
        String health = Util.format1DP(this.dog.m_21223_());
        String healthMax = Util.format1DP(this.dog.m_21233_());
        String speedValue = Util.format2DP(this.dog.m_21051_(Attributes.f_22279_).m_22135_());
        String armorValue = Util.format2DP(this.dog.m_21051_(Attributes.f_22284_).m_22135_());
        String ageValue = Util.format2DP(this.dog.m_146764_());
        String ageRel = I18n.m_118938_((String)(this.dog.m_6162_() ? "doggui.age.baby" : "doggui.age.adult"), (Object[])new Object[0]);
        String ageString = ageValue + " " + ageRel;
        String tamedString = "";
        if (this.dog.m_21824_()) {
            if (this.dog.m_21830_((LivingEntity)this.player)) {
                tamedString = I18n.m_118938_((String)"doggui.owner.you", (Object[])new Object[0]);
            } else if (this.dog.getOwnersName().isPresent()) {
                tamedString = this.dog.getOwnersName().get().getString();
            }
        }
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.speed", (Object[])new Object[0]) + " " + speedValue, (float)(this.f_96543_ - 160), (float)(topY - 100), 0xFFFFFF);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.owner", (Object[])new Object[0]) + " " + tamedString, (float)(this.f_96543_ - 160), (float)(topY - 90), 0xFFFFFF);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.age", (Object[])new Object[0]) + " " + ageString, (float)(this.f_96543_ - 160), (float)(topY - 80), 0xFFFFFF);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.armor", (Object[])new Object[0]) + " " + armorValue, (float)(this.f_96543_ - 160), (float)(topY - 70), 0xFFFFFF);
        if (((Boolean)ConfigHandler.SERVER.DOG_GENDER.get()).booleanValue()) {
            this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.gender", (Object[])new Object[0]) + " " + I18n.m_118938_((String)this.dog.getGender().getUnlocalisedName(), (Object[])new Object[0]), (float)(this.f_96543_ - 160), (float)(topY - 60), 0xFFFFFF);
        }
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.newname", (Object[])new Object[0]), (float)(topX - 100), (float)(topY + 38), 0x404040);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.level", (Object[])new Object[0]) + " " + this.dog.getLevel().getLevel(DogLevel.Type.NORMAL), (float)(topX - 65), (float)(topY + 75), 16716025);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.leveldire", (Object[])new Object[0]) + " " + this.dog.getLevel().getLevel(DogLevel.Type.DIRE), (float)topX, (float)(topY + 75), 16716025);
        if (this.dog.getAccessory((Accessory)DoggyAccessories.GOLDEN_COLLAR.get()).isPresent()) {
            this.f_96547_.m_92883_(stack, ChatFormatting.GOLD + "Unlimited Points", (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        } else {
            this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.pointsleft", (Object[])new Object[0]) + " " + this.dog.getSpendablePoints(), (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        }
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.textureindex", (Object[])new Object[0]), (float)(this.f_96543_ - 80), (float)(topY + 20), 0xFFFFFF);
        this.f_96547_.m_92883_(stack, this.dog.getSkinHash().substring(0, Math.min(this.dog.getSkinHash().length(), 10)), (float)(this.f_96543_ - 73), (float)(topY + 54), 0xFFFFFF);
        if (this.dog.m_21830_((LivingEntity)this.player)) {
            this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.obeyothers", (Object[])new Object[0]), (float)(this.f_96543_ - 76), (float)(topY + 67), 0xFFFFFF);
        }
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"doggui.friendlyfire", (Object[])new Object[0]), (float)(this.f_96543_ - 76), (float)(topY - 15), 0xFFFFFF);
        this.f_169369_.forEach(widget -> {
            if (widget instanceof TalentButton) {
                TalentButton talBut = (TalentButton)((Object)widget);
                this.f_96547_.m_92883_(stack, I18n.m_118938_((String)talBut.talent.getTranslationKey(), (Object[])new Object[0]), (float)(talBut.f_93620_ + 25), (float)(talBut.f_93621_ + 7), 0xFFFFFF);
            }
        });
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        for (Widget widget2 : this.f_169369_) {
            AbstractWidget w;
            Widget widget3 = widget2;
            if (!(widget3 instanceof AbstractWidget) || !(w = (AbstractWidget)widget3).m_5702_()) continue;
            w.m_7428_(stack, mouseX, mouseY);
            break;
        }
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public boolean m_7043_() {
        return false;
    }

    private static class TalentButton
    extends Button {
        protected Talent talent;

        private TalentButton(int x, int y, int widthIn, int heightIn, Component buttonText, Talent talent, Consumer<TalentButton> onPress) {
            super(x, y, widthIn, heightIn, buttonText, button -> onPress.accept((TalentButton)button));
            this.talent = talent;
        }
    }
}

