/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import doggytalents.DoggyItems;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.common.Screens;
import doggytalents.common.block.tileentity.FoodBowlTileEntity;
import doggytalents.common.util.InventoryUtil;
import doggytalents.common.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class FoodBowlBlock
extends BaseEntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);

    public FoodBowlBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 5.0f).m_60918_(SoundType.f_56743_));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new FoodBowlTileEntity(pos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return FoodBowlBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)DoggyTileEntityTypes.FOOD_BOWL.get()), FoodBowlTileEntity::tick);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        FoodBowlTileEntity foodBowlTileEntity = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, FoodBowlTileEntity.class);
        if (foodBowlTileEntity != null) {
            foodBowlTileEntity.setPlacer(placer);
        }
        worldIn.m_7731_(pos, state, 2);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        FoodBowlTileEntity foodBowl;
        if (entityIn instanceof ItemEntity && (foodBowl = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, FoodBowlTileEntity.class)) != null) {
            ItemEntity entityItem = (ItemEntity)entityIn;
            ItemStackHandler bowlInventory = foodBowl.getInventory();
            ItemStack remaining = InventoryUtil.addItem((IItemHandler)bowlInventory, entityItem.m_32055_());
            if (!remaining.m_41619_()) {
                entityItem.m_32045_(remaining);
            } else {
                entityItem.m_146870_();
                worldIn.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.25f, ((worldIn.f_46441_.nextFloat() - worldIn.f_46441_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            FoodBowlTileEntity foodBowl = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, FoodBowlTileEntity.class);
            if (foodBowl != null) {
                ItemStackHandler bowlInventory = foodBowl.getInventory();
                for (int i = 0; i < bowlInventory.getSlots(); ++i) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)bowlInventory.getStackInSlot(i));
                }
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        FoodBowlTileEntity foodBowl = WorldUtil.getTileEntity((BlockGetter)worldIn, pos, FoodBowlTileEntity.class);
        if (foodBowl != null) {
            ItemStackHandler bowlInventory = foodBowl.getInventory();
            return InventoryUtil.calcRedstoneFromInventory((IItemHandler)bowlInventory);
        }
        return 0;
    }

    public InteractionResult m_6227_(BlockState blockStateIn, Level worldIn, BlockPos posIn, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        FoodBowlTileEntity foodBowl = WorldUtil.getTileEntity((BlockGetter)worldIn, posIn, FoodBowlTileEntity.class);
        if (foodBowl != null) {
            ItemStack stack = playerIn.m_21120_(handIn);
            if (!stack.m_41619_() && stack.m_41720_() == DoggyItems.TREAT_BAG.get()) {
                IItemHandler bagInventory = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EmptyHandler.INSTANCE);
                ItemStackHandler bowlInventory = foodBowl.getInventory();
                InventoryUtil.transferStacks((IItemHandlerModifiable)bagInventory, (IItemHandler)bowlInventory);
            } else if (playerIn instanceof ServerPlayer && !(playerIn instanceof FakePlayer)) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                Screens.openFoodBowlScreen(serverPlayer, foodBowl);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState FluidState2 = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

