/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyAttributes;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggySerializers;
import doggytalents.DoggyTags;
import doggytalents.DoggyTalents2;
import doggytalents.api.enu.WetSource;
import doggytalents.api.feature.DataKey;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.feature.InteractHandler;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.screen.DogInfoScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.ai.BerserkerModeGoal;
import doggytalents.common.entity.ai.BreedGoal;
import doggytalents.common.entity.ai.DogBegGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoal;
import doggytalents.common.entity.ai.DogWanderGoal;
import doggytalents.common.entity.ai.FetchGoal;
import doggytalents.common.entity.ai.FindWaterGoal;
import doggytalents.common.entity.ai.GuardModeGoal;
import doggytalents.common.entity.ai.MoveToBlockGoal;
import doggytalents.common.entity.ai.OwnerHurtByTargetGoal;
import doggytalents.common.entity.ai.OwnerHurtTargetGoal;
import doggytalents.common.entity.serializers.DimensionDependantArg;
import doggytalents.common.entity.stats.StatsTracker;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.BackwardsComp;
import doggytalents.common.util.Cache;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.DataSerializerEntry;

public class DogEntity
extends AbstractDogEntity {
    private static final EntityDataAccessor<Optional<Component>> LAST_KNOWN_NAME = SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135032_);
    private static final EntityDataAccessor<Byte> DOG_FLAGS = SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> HUNGER_INT = SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> CUSTOM_SKIN = SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Byte> SIZE = SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<ItemStack> BONE_VARIANT = SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final Cache<EntityDataAccessor<List<AccessoryInstance>>> ACCESSORIES = Cache.make(() -> SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)((DataSerializerEntry)DoggySerializers.ACCESSORY_SERIALIZER.get()).getSerializer()));
    private static final Cache<EntityDataAccessor<List<TalentInstance>>> TALENTS = Cache.make(() -> SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)((DataSerializerEntry)DoggySerializers.TALENT_SERIALIZER.get()).getSerializer()));
    private static final Cache<EntityDataAccessor<DogLevel>> DOG_LEVEL = Cache.make(() -> SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)((DataSerializerEntry)DoggySerializers.DOG_LEVEL_SERIALIZER.get()).getSerializer()));
    private static final Cache<EntityDataAccessor<EnumGender>> GENDER = Cache.make(() -> SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)((DataSerializerEntry)DoggySerializers.GENDER_SERIALIZER.get()).getSerializer()));
    private static final Cache<EntityDataAccessor<EnumMode>> MODE = Cache.make(() -> SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)((DataSerializerEntry)DoggySerializers.MODE_SERIALIZER.get()).getSerializer()));
    private static final Cache<EntityDataAccessor<DimensionDependantArg<Optional<BlockPos>>>> DOG_BED_LOCATION = Cache.make(() -> SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)((DataSerializerEntry)DoggySerializers.BED_LOC_SERIALIZER.get()).getSerializer()));
    private static final Cache<EntityDataAccessor<DimensionDependantArg<Optional<BlockPos>>>> DOG_BOWL_LOCATION = Cache.make(() -> SynchedEntityData.m_135353_(DogEntity.class, (EntityDataSerializer)((DataSerializerEntry)DoggySerializers.BED_LOC_SERIALIZER.get()).getSerializer()));
    private final Cache<Integer> spendablePoints = Cache.make(this::getSpendablePointsInternal);
    private final List<IDogAlteration> alterations = new ArrayList<IDogAlteration>(4);
    private final List<IDogFoodHandler> foodHandlers = new ArrayList<IDogFoodHandler>(4);
    public final Map<Integer, Object> objects = new HashMap<Integer, Object>();
    public final StatsTracker statsTracker = new StatsTracker();
    private int hungerTick;
    private int prevHungerTick;
    private int healingTick;
    private int prevHealingTick;
    private float headRotationCourse;
    private float headRotationCourseOld;
    private WetSource wetSource;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    protected boolean dogJumping;
    protected float jumpPower;
    protected BlockPos targetBlock;

    public static final void initDataParameters() {
        ACCESSORIES.get();
        TALENTS.get();
        DOG_LEVEL.get();
        GENDER.get();
        MODE.get();
        DOG_BED_LOCATION.get();
        DOG_BOWL_LOCATION.get();
    }

    public DogEntity(EntityType<? extends DogEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_7105_(false);
        this.setGender(EnumGender.random(this.m_21187_()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACCESSORIES.get(), new ArrayList(4));
        this.f_19804_.m_135372_(TALENTS.get(), new ArrayList(4));
        this.f_19804_.m_135372_(LAST_KNOWN_NAME, Optional.empty());
        this.f_19804_.m_135372_(DOG_FLAGS, (Object)0);
        this.f_19804_.m_135372_(GENDER.get(), (Object)EnumGender.UNISEX);
        this.f_19804_.m_135372_(MODE.get(), (Object)EnumMode.DOCILE);
        this.f_19804_.m_135372_(HUNGER_INT, (Object)Float.valueOf(60.0f));
        this.f_19804_.m_135372_(CUSTOM_SKIN, (Object)"");
        this.f_19804_.m_135372_(DOG_LEVEL.get(), (Object)new DogLevel(0, 0));
        this.f_19804_.m_135372_(SIZE, (Object)3);
        this.f_19804_.m_135372_(BONE_VARIANT, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DOG_BED_LOCATION.get(), new DimensionDependantArg(() -> EntityDataSerializers.f_135039_));
        this.f_19804_.m_135372_(DOG_BOWL_LOCATION.get(), new DimensionDependantArg(() -> EntityDataSerializers.f_135039_));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new MoveToBlockGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new DogWanderGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FetchGoal(this, 1.0, 32.0f));
        this.f_21345_.m_25352_(6, (Goal)new DogFollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new DogBegGoal(this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(6, new BerserkerModeGoal<Monster>(this, Monster.class, false));
        this.f_21346_.m_25352_(6, (Goal)new GuardModeGoal(this, false));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        if (this.f_19796_.nextInt(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    @Override
    public float m_6121_() {
        return 0.4f;
    }

    public boolean isDogWet() {
        return this.wetSource != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float partialTicks) {
        return Math.min(0.5f + Mth.m_14179_((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) / 2.0f * 0.5f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float partialTicks, float offset) {
        float f = (Mth.m_14179_((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.headRotationCourseOld, (float)this.headRotationCourse) * 0.15f * (float)Math.PI;
    }

    public void m_7822_(byte id) {
        if (id == 8) {
            this.startShaking();
        } else if (id == 56) {
            this.finishShaking();
        } else {
            super.m_7822_(id);
        }
    }

    public float getTailRotation() {
        return this.m_21824_() ? (0.55f - (this.m_21233_() - this.m_21223_()) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    @Override
    public float getWagAngle(float limbSwing, float limbSwingAmount, float partialTickTime) {
        return Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.8f;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public double m_6049_() {
        return this.m_20202_() instanceof Player ? 0.5 : 0.0;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.headRotationCourseOld = this.headRotationCourse;
            this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
            boolean inWater = this.m_20069_();
            boolean inRain = inWater ? false : this.m_20070_();
            boolean inBubbleColumn = this.m_20305_();
            if (inWater || inRain || inBubbleColumn) {
                if (this.wetSource == null) {
                    this.wetSource = WetSource.of(inWater, inBubbleColumn, inRain);
                }
                if (this.isShaking && !this.f_19853_.f_46443_) {
                    this.finishShaking();
                    this.f_19853_.m_7605_((Entity)this, (byte)56);
                }
            } else if ((this.wetSource != null || this.isShaking) && this.isShaking) {
                if (this.timeWolfIsShaking == 0.0f) {
                    this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                }
                this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
                this.timeWolfIsShaking += 0.05f;
                if (this.prevTimeWolfIsShaking >= 2.0f) {
                    if (this.wetSource != null) {
                        for (IDogAlteration alter2 : this.alterations) {
                            alter2.onShakingDry(this, this.wetSource);
                        }
                    }
                    this.wetSource = null;
                    this.finishShaking();
                }
                if (this.timeWolfIsShaking > 0.4f) {
                    float f = (float)this.m_20186_();
                    int i = (int)(Mth.m_14031_((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3d = this.m_20184_();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.f_19796_.nextFloat() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        float f2 = (this.f_19796_.nextFloat() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                    }
                }
            }
            if (!this.f_19853_.f_46443_ && this.f_19797_ % 40 == 0) {
                DogLocationStorage.get(this.f_19853_).getOrCreateData(this).update(this);
                if (this.m_142480_() != null) {
                    this.setOwnersName(this.m_142480_().m_7755_());
                }
            }
        }
        this.alterations.forEach(alter -> alter.tick(this));
    }

    public void m_8107_() {
        ResourceKey dimKey;
        Optional<BlockPos> bowlPos;
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.wetSource != null && !this.isShaking && !this.m_21691_() && this.m_20096_()) {
            this.startShaking();
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
        if (!this.f_19853_.f_46443_) {
            InteractionResultHolder<Integer> result;
            if (!((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue()) {
                this.prevHungerTick = this.hungerTick++;
                if (this.m_20160_() || !this.m_21825_()) {
                    // empty if block
                }
                for (IDogAlteration alter2 : this.alterations) {
                    result = alter2.hungerTick(this, this.hungerTick - this.prevHungerTick);
                    if (!result.m_19089_().m_19080_()) continue;
                    this.hungerTick = (Integer)result.m_19095_() + this.prevHungerTick;
                }
                if (this.hungerTick > 400) {
                    this.setDogHunger(this.getDogHunger() - 1.0f);
                    this.hungerTick -= 400;
                }
            }
            this.prevHealingTick = this.healingTick;
            this.healingTick += 8;
            if (this.m_21825_()) {
                this.healingTick += 4;
            }
            for (IDogAlteration alter2 : this.alterations) {
                result = alter2.healingTick(this, this.healingTick - this.prevHealingTick);
                if (!result.m_19089_().m_19080_()) continue;
                this.healingTick = (Integer)result.m_19095_() + this.prevHealingTick;
            }
            if (this.healingTick >= 6000) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(1.0f);
                }
                this.healingTick = 0;
            }
        }
        if (((Boolean)ConfigHandler.CLIENT.DIRE_PARTICLES.get()).booleanValue() && this.f_19853_.f_46443_ && this.getLevel().isDireDog()) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.nextDouble() - 0.5) * 2.0, -this.f_19796_.nextDouble(), (this.f_19796_.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.f_19797_ % 50 == 0 && (bowlPos = this.getBowlPos((ResourceKey<Level>)(dimKey = this.f_19853_.m_46472_()))).isPresent() && this.f_19853_.m_46805_(bowlPos.get()) && !this.f_19853_.m_8055_(bowlPos.get()).m_60713_((Block)DoggyBlocks.FOOD_BOWL.get())) {
            this.setBowlPos((ResourceKey<Level>)dimKey, Optional.empty());
        }
        this.alterations.forEach(alter -> alter.livingTick(this));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Optional<IDogFoodHandler> foodHandler;
        ItemStack stack = player.m_21120_(hand);
        if (this.m_21824_()) {
            if (stack.m_41720_() == Items.f_42398_ && this.canInteract((LivingEntity)player)) {
                if (this.f_19853_.f_46443_) {
                    DogInfoScreen.open(this);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41720_() == Items.f_42500_ || stack.m_41720_() == DoggyItems.TRAINING_TREAT.get()) {
            if (!this.f_19853_.f_46443_) {
                this.m_142075_(player, hand, stack);
                if (stack.m_41720_() == DoggyItems.TRAINING_TREAT.get() || this.f_19796_.nextInt(3) == 0) {
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21839_(true);
                    this.m_21153_(20.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if ((foodHandler = FoodHandler.getMatch(this, stack, (Entity)player)).isPresent()) {
            return foodHandler.get().consume(this, stack, (Entity)player);
        }
        InteractionResult interactResult = InteractHandler.getMatch(this, stack, player, hand);
        if (interactResult != InteractionResult.PASS) {
            return interactResult;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.processInteract(this, this.f_19853_, player, hand);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        InteractionResult actionresulttype = super.m_6071_(player, hand);
        if ((!actionresulttype.m_19077_() || this.m_6162_()) && this.canInteract((LivingEntity)player)) {
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        return actionresulttype;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBeRiddenInWater(this, rider);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.canBeRiddenInWater(rider);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canTrample(this, state, pos, fallDistance);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.onLivingFall(this, distance, damageMultiplier);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        int i = this.m_5639_(distance, damageMultiplier);
        if (i > 0) {
            if (this.m_20160_()) {
                for (Entity e : this.m_20197_()) {
                    e.m_6469_(DamageSource.f_19315_, (float)i);
                }
            }
            this.m_5496_(this.m_5896_(i), 1.0f, 1.0f);
            this.m_21229_();
            this.m_6469_(DamageSource.f_19315_, i);
            return true;
        }
        return false;
    }

    public int m_6056_() {
        return super.m_6056_();
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        MobEffectInstance effectInst = this.m_21124_(MobEffects.f_19603_);
        float f = effectInst == null ? 0.0f : (float)(effectInst.m_19564_() + 1);
        distance -= f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.calculateFallDistance(this, distance);
            if (!result.m_19089_().m_19080_()) continue;
            distance = ((Float)result.m_19095_()).floatValue();
            break;
        }
        return Mth.m_14167_((float)((distance - 3.0f - f) * damageMultiplier));
    }

    public boolean m_6040_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBreatheUnderwater(this);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_6040_();
    }

    protected int m_7302_(int air) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.decreaseAirSupply(this, air);
            if (!result.m_19089_().m_19080_()) continue;
            return (Integer)result.m_19095_();
        }
        return super.m_7302_(air);
    }

    protected int m_7305_(int currentAir) {
        currentAir += 4;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.determineNextAir(this, currentAir);
            if (!result.m_19089_().m_19080_()) continue;
            currentAir = (Integer)result.m_19095_();
            break;
        }
        return Math.min(currentAir, this.m_6062_());
    }

    public boolean m_6779_(LivingEntity target) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canAttack((AbstractDogEntity)this, target);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof Creeper) {
            return false;
        }
        return super.m_6779_(target);
    }

    public boolean m_6549_(EntityType<?> entityType) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canAttack((AbstractDogEntity)this, entityType);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (entityType == EntityType.f_20558_) {
            return false;
        }
        return super.m_6549_(entityType);
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.shouldAttackEntity(this, target, owner);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof Creeper || target instanceof Ghast) {
            return false;
        }
        if (target instanceof Wolf) {
            Wolf wolfentity = (Wolf)target;
            return !wolfentity.m_21824_() || wolfentity.m_142480_() != owner;
        }
        if (target instanceof DogEntity) {
            DogEntity dogEntity = (DogEntity)target;
            return !dogEntity.m_21824_() || dogEntity.m_142480_() != owner;
        }
        if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
            return false;
        }
        if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.attackEntityFrom((AbstractDogEntity)this, source, amount);
            if (result.m_19089_() == InteractionResult.FAIL) {
                return false;
            }
            amount = ((Float)result.m_19095_()).floatValue();
        }
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player && !this.canPlayersAttack()) {
            return false;
        }
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity target) {
        boolean flag;
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.attackEntityAsMob(this, target);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        AttributeInstance attackDamageInst = this.m_21051_(Attributes.f_22281_);
        Set critModifiers = null;
        if (this.m_21051_((Attribute)DoggyAttributes.CRIT_CHANCE.get()).m_22135_() > this.m_21187_().nextDouble()) {
            critModifiers = this.m_21051_((Attribute)DoggyAttributes.CRIT_BONUS.get()).m_22122_();
            critModifiers.forEach(arg_0 -> ((AttributeInstance)attackDamageInst).m_22118_(arg_0));
        }
        int damage = (int)attackDamageInst.m_22135_();
        if (critModifiers != null) {
            critModifiers.forEach(arg_0 -> ((AttributeInstance)attackDamageInst).m_22130_(arg_0));
        }
        if (flag = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)damage)) {
            this.m_19970_((LivingEntity)this, target);
            this.statsTracker.increaseDamageDealt(damage);
            if (critModifiers != null) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91061_.m_107329_(target, (ParticleOptions)ParticleTypes.f_123797_));
            }
        }
        return flag;
    }

    public void m_5993_(Entity killed, int scoreValue, DamageSource damageSource) {
        super.m_5993_(killed, scoreValue, damageSource);
        this.statsTracker.incrementKillCount(killed);
    }

    public boolean m_21275_(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBlockDamageSource(this, source);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_21275_(source);
    }

    public void m_20254_(int second) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.setFire(this, second);
            if (!result.m_19089_().m_19080_()) continue;
            second = (Integer)result.m_19095_();
        }
        super.m_20254_(second);
    }

    public boolean m_5825_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isImmuneToFire(this);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_5825_();
    }

    public boolean m_6673_(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isInvulnerableTo(this, source);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_6673_(source);
    }

    public boolean m_20147_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isInvulnerable(this);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_20147_();
    }

    public boolean m_7301_(MobEffectInstance effectIn) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isPotionApplicable(this, effectIn);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_7301_(effectIn);
    }

    public boolean m_6573_(Player player) {
        return this.canInteract((LivingEntity)player) && super.m_6573_(player);
    }

    public void m_20084_(UUID uniqueIdIn) {
        UUID oldUniqueId = this.m_142081_();
        if (uniqueIdIn.equals(oldUniqueId)) {
            return;
        }
        super.m_20084_(uniqueIdIn);
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            DogLocationStorage.get(this.f_19853_).remove(oldUniqueId);
            DogLocationStorage.get(this.f_19853_).getOrCreateData(this).update(this);
        }
    }

    public void m_21828_(Player player) {
        super.m_21828_(player);
        this.setOwnersName(player.m_7755_());
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public void m_21816_(@Nullable UUID uuid) {
        super.m_21816_(uuid);
        if (uuid == null) {
            this.setOwnersName((Component)null);
        }
    }

    public boolean m_7313_(Entity entityIn) {
        if (entityIn instanceof Player && !this.canPlayersAttack()) {
            return true;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.hitByEntity(this, entityIn);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)DoggyItems.DOGGY_CHARM.get());
    }

    public boolean m_6898_(ItemStack stack) {
        return DoggyTags.BREEDING_ITEMS.m_8110_((Object)stack.m_41720_());
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(otherAnimal instanceof DogEntity)) {
            return false;
        }
        DogEntity entitydog = (DogEntity)otherAnimal;
        if (!entitydog.m_21824_()) {
            return false;
        }
        if (entitydog.m_21825_()) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.DOG_GENDER.get()).booleanValue() && !this.getGender().canMateWith(entitydog.getGender())) {
            return false;
        }
        return this.m_27593_() && entitydog.m_27593_();
    }

    public AgeableMob m_142606_(ServerLevel worldIn, AgeableMob partner) {
        DogEntity child = (DogEntity)((EntityType)DoggyEntityTypes.DOG.get()).m_20615_((Level)worldIn);
        UUID uuid = this.m_142504_();
        if (uuid != null) {
            child.m_21816_(uuid);
            child.m_7105_(true);
        }
        if (partner instanceof DogEntity && ((Boolean)ConfigHandler.SERVER.PUPS_GET_PARENT_LEVELS.get()).booleanValue()) {
            child.setLevel(this.getLevel().combine(((DogEntity)partner).getLevel()));
        }
        return child;
    }

    public boolean m_6052_() {
        return this.m_8077_() || super.m_6052_();
    }

    public float m_6134_() {
        if (this.m_6162_()) {
            return 0.5f;
        }
        return (float)this.getDogSize() * 0.3f + 0.1f;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.alterations == null) {
            return super.getCapability(cap, side);
        }
        for (IDogAlteration alter : this.alterations) {
            LazyOptional<T> result = alter.getCapability(this, cap, side);
            if (result == null) continue;
            return result;
        }
        return super.getCapability(cap, side);
    }

    public Entity changeDimension(ServerLevel worldIn, ITeleporter teleporter) {
        Entity transportedEntity = super.changeDimension(worldIn, teleporter);
        if (transportedEntity instanceof DogEntity) {
            DogLocationStorage.get(this.f_19853_).getOrCreateData(this).update((DogEntity)transportedEntity);
        }
        return transportedEntity;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        if (!(removalReason != Entity.RemovalReason.DISCARDED && removalReason != Entity.RemovalReason.KILLED || this.f_19853_ == null || this.f_19853_.f_46443_)) {
            DogRespawnStorage.get(this.f_19853_).putData(this);
            DogLocationStorage.get(this.f_19853_).remove(this);
        }
    }

    protected void m_6153_() {
        if (this.f_20919_ != 19 || this.f_19853_ == null || !this.f_19853_.f_46443_) {
            // empty if block
        }
        super.m_6153_();
    }

    private void startShaking() {
        this.isShaking = true;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    private void finishShaking() {
        this.isShaking = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void m_6667_(DamageSource cause) {
        this.wetSource = null;
        this.finishShaking();
        this.alterations.forEach(alter -> alter.onDeath(this, cause));
        super.m_6667_(cause);
    }

    public void m_5907_() {
        super.m_5907_();
        this.alterations.forEach(alter -> alter.dropInventory(this));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.alterations.forEach(alter -> alter.invalidateCapabilities(this));
    }

    public void m_7380_(CompoundTag compound) {
        DimensionDependantArg bowlsData;
        super.m_7380_(compound);
        ListTag talentList = new ListTag();
        List<TalentInstance> talents = this.getTalentMap();
        for (int i = 0; i < talents.size(); ++i) {
            CompoundTag talentTag = new CompoundTag();
            talents.get(i).writeInstance(this, talentTag);
            talentList.add((Object)talentTag);
        }
        compound.m_128365_("talents", (net.minecraft.nbt.Tag)talentList);
        ListTag accessoryList = new ListTag();
        List<AccessoryInstance> accessories = this.getAccessories();
        for (int i = 0; i < accessories.size(); ++i) {
            CompoundTag accessoryTag = new CompoundTag();
            accessories.get(i).writeInstance(accessoryTag);
            accessoryList.add((Object)accessoryTag);
        }
        compound.m_128365_("accessories", (net.minecraft.nbt.Tag)accessoryList);
        compound.m_128359_("mode", this.getMode().getSaveName());
        compound.m_128359_("dogGender", this.getGender().getSaveName());
        compound.m_128350_("dogHunger", this.getDogHunger());
        this.getOwnersName().ifPresent(comp -> NBTUtil.putTextComponent(compound, "lastKnownOwnerName", comp));
        compound.m_128359_("customSkinHash", this.getSkinHash());
        compound.m_128379_("willObey", this.willObeyOthers());
        compound.m_128379_("friendlyFire", this.canPlayersAttack());
        compound.m_128405_("dogSize", this.getDogSize());
        compound.m_128405_("level_normal", this.getLevel().getLevel(DogLevel.Type.NORMAL));
        compound.m_128405_("level_dire", this.getLevel().getLevel(DogLevel.Type.DIRE));
        NBTUtil.writeItemStack(compound, "fetchItem", this.getBoneVariant());
        DimensionDependantArg bedsData = (DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get());
        if (!bedsData.isEmpty()) {
            ListTag bedsList = new ListTag();
            for (Map.Entry entry : bedsData.entrySet()) {
                CompoundTag bedNBT = new CompoundTag();
                NBTUtil.putResourceLocation(bedNBT, "dim", entry.getKey().m_135782_());
                NBTUtil.putBlockPos(bedNBT, "pos", (Optional)entry.getValue());
                bedsList.add((Object)bedNBT);
            }
            compound.m_128365_("beds", (net.minecraft.nbt.Tag)bedsList);
        }
        if (!(bowlsData = (DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).isEmpty()) {
            ListTag bowlsList = new ListTag();
            for (Map.Entry entry : bowlsData.entrySet()) {
                CompoundTag bowlsNBT = new CompoundTag();
                NBTUtil.putResourceLocation(bowlsNBT, "dim", entry.getKey().m_135782_());
                NBTUtil.putBlockPos(bowlsNBT, "pos", (Optional)entry.getValue());
                bowlsList.add((Object)bowlsNBT);
            }
            compound.m_128365_("bowls", (net.minecraft.nbt.Tag)bowlsList);
        }
        this.statsTracker.writeAdditional(compound);
        this.alterations.forEach(alter -> alter.onWrite(this, compound));
    }

    /*
     * Exception decompiling
     */
    public void m_20258_(CompoundTag compound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$TooOptimisticMatchException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.getString(SwitchStringRewriter.java:404)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.access$600(SwitchStringRewriter.java:53)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$SwitchStringMatchResultCollector.collectMatches(SwitchStringRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.KleeneN.match(KleeneN.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchSequence.match(MatchSequence.java:26)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:23)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewriteComplex(SwitchStringRewriter.java:201)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewrite(SwitchStringRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:881)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        List<TalentInstance> talentMap = this.getTalentMap();
        talentMap.clear();
        if (compound.m_128425_("talents", 9)) {
            ListTag talentList = compound.m_128437_("talents", 10);
            for (int i = 0; i < talentList.size(); ++i) {
                TalentInstance.readInstance(this, talentList.m_128728_(i)).ifPresent(talentMap::add);
            }
        } else {
            BackwardsComp.readTalentMapping(compound, talentMap);
        }
        this.markDataParameterDirty(TALENTS.get(), false);
        List<AccessoryInstance> accessories = this.getAccessories();
        accessories.clear();
        if (compound.m_128425_("accessories", 9)) {
            ListTag accessoryList = compound.m_128437_("accessories", 10);
            for (int i = 0; i < accessoryList.size(); ++i) {
                AccessoryInstance.readInstance(accessoryList.m_128728_(i)).ifPresent(accessories::add);
            }
        } else {
            BackwardsComp.readAccessories(compound, accessories);
        }
        this.markDataParameterDirty(ACCESSORIES.get(), false);
        this.recalculateAlterationsCache();
        this.spendablePoints.markForRefresh();
        try {
            for (IDogAlteration inst : this.alterations) {
                inst.init(this);
            }
        }
        catch (Exception e) {
            DoggyTalents2.LOGGER.error("Failed to init alteration: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.setGender(EnumGender.bySaveName(compound.m_128461_("dogGender")));
            if (compound.m_128425_("mode", 8)) {
                this.setMode(EnumMode.bySaveName(compound.m_128461_("mode")));
            } else {
                BackwardsComp.readMode(compound, this::setMode);
            }
            if (compound.m_128425_("customSkinHash", 8)) {
                this.setSkinHash(compound.m_128461_("customSkinHash"));
            } else {
                BackwardsComp.readDogTexture(compound, this::setSkinHash);
            }
            if (compound.m_128425_("fetchItem", 10)) {
                this.setBoneVariant(NBTUtil.readItemStack(compound, "fetchItem"));
            } else {
                BackwardsComp.readHasBone(compound, this::setBoneVariant);
            }
            this.setHungerDirectly(compound.m_128457_("dogHunger"));
            this.setOwnersName(NBTUtil.getTextComponent(compound, "lastKnownOwnerName"));
            this.setWillObeyOthers(compound.m_128471_("willObey"));
            this.setCanPlayersAttack(compound.m_128471_("friendlyFire"));
            if (compound.m_128425_("dogSize", 99)) {
                this.setDogSize(compound.m_128451_("dogSize"));
            }
        }
        catch (Exception e) {
            DoggyTalents2.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            if (compound.m_128425_("level_normal", 99)) {
                this.getLevel().setLevel(DogLevel.Type.NORMAL, compound.m_128451_("level_normal"));
                this.markDataParameterDirty(DOG_LEVEL.get());
            }
            if (compound.m_128425_("level_dire", 99)) {
                this.getLevel().setLevel(DogLevel.Type.DIRE, compound.m_128451_("level_dire"));
                this.markDataParameterDirty(DOG_LEVEL.get());
            }
        }
        catch (Exception e) {
            DoggyTalents2.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        DimensionDependantArg<Optional<BlockPos>> bedsData = ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get())).copyEmpty();
        try {
            if (compound.m_128425_("beds", 9)) {
                ListTag bedsList = compound.m_128437_("beds", 10);
                for (int i = 0; i < bedsList.size(); ++i) {
                    CompoundTag bedNBT = bedsList.m_128728_(i);
                    ResourceLocation loc = NBTUtil.getResourceLocation(bedNBT, "dim");
                    ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)loc);
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bedNBT, "pos");
                    bedsData.put((ResourceKey<Level>)type, pos);
                }
            } else {
                BackwardsComp.readBedLocations(compound, bedsData);
            }
        }
        catch (Exception e) {
            DoggyTalents2.LOGGER.error("Failed to load beds: " + e.getMessage());
            e.printStackTrace();
        }
        this.f_19804_.m_135381_(DOG_BED_LOCATION.get(), bedsData);
        DimensionDependantArg<Optional<BlockPos>> bowlsData = ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).copyEmpty();
        try {
            if (compound.m_128425_("bowls", 9)) {
                ListTag bowlsList = compound.m_128437_("bowls", 10);
                for (int i = 0; i < bowlsList.size(); ++i) {
                    CompoundTag bowlsNBT = bowlsList.m_128728_(i);
                    ResourceLocation loc = NBTUtil.getResourceLocation(bowlsNBT, "dim");
                    ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)loc);
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bowlsNBT, "pos");
                    bowlsData.put((ResourceKey<Level>)type, pos);
                }
            } else {
                BackwardsComp.readBowlLocations(compound, bowlsData);
            }
        }
        catch (Exception e) {
            DoggyTalents2.LOGGER.error("Failed to load bowls: " + e.getMessage());
            e.printStackTrace();
        }
        this.f_19804_.m_135381_(DOG_BOWL_LOCATION.get(), bowlsData);
        try {
            this.statsTracker.readAdditional(compound);
        }
        catch (Exception e) {
            DoggyTalents2.LOGGER.error("Failed to load stats tracker: " + e.getMessage());
            e.printStackTrace();
        }
        this.alterations.forEach(alter -> {
            try {
                alter.onRead(this, compound);
            }
            catch (Exception e) {
                DoggyTalents2.LOGGER.error("Failed to load alteration: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (TALENTS.get().equals(key) || ACCESSORIES.get().equals(key)) {
            this.recalculateAlterationsCache();
            for (IDogAlteration inst : this.alterations) {
                inst.init(this);
            }
        }
        if (TALENTS.get().equals(key)) {
            this.spendablePoints.markForRefresh();
        }
        if (DOG_LEVEL.get().equals(key)) {
            this.spendablePoints.markForRefresh();
        }
        if (ACCESSORIES.get().equals(key) && this.f_19853_.f_46443_) {
            this.getAccessories().sort(AccessoryInstance.RENDER_SORTER);
        }
        if (SIZE.equals(key)) {
            this.m_6210_();
        }
    }

    public void recalculateAlterationsCache() {
        this.alterations.clear();
        this.foodHandlers.clear();
        for (AccessoryInstance inst : this.getAccessories()) {
            if (inst instanceof IDogAlteration) {
                this.alterations.add((IDogAlteration)((Object)inst));
            }
            if (!(inst instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)inst));
        }
        List<TalentInstance> talents = this.getTalentMap();
        this.alterations.addAll(talents);
        for (TalentInstance inst : talents) {
            if (!(inst instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)inst));
        }
    }

    @Override
    public boolean canInteract(LivingEntity livingEntity) {
        return this.willObeyOthers() || this.m_21830_(livingEntity);
    }

    @Override
    public List<AccessoryInstance> getAccessories() {
        return (List)this.f_19804_.m_135370_(ACCESSORIES.get());
    }

    @Override
    public boolean addAccessory(@Nonnull AccessoryInstance accessoryInst) {
        List<AccessoryInstance> accessories = this.getAccessories();
        AccessoryType type = accessoryInst.getAccessory().getType();
        List filtered = accessories.stream().filter(inst -> type == inst.getAccessory().getType()).collect(Collectors.toList());
        if (filtered.size() >= type.numberToPutOn()) {
            return false;
        }
        accessories.add(accessoryInst);
        this.markDataParameterDirty(ACCESSORIES.get());
        return true;
    }

    @Override
    public List<AccessoryInstance> removeAccessories() {
        ArrayList<AccessoryInstance> removed = new ArrayList<AccessoryInstance>(this.getAccessories());
        for (AccessoryInstance inst : removed) {
            if (!(inst instanceof IDogAlteration)) continue;
            ((IDogAlteration)((Object)inst)).remove(this);
        }
        this.getAccessories().clear();
        this.markDataParameterDirty(ACCESSORIES.get());
        return removed;
    }

    public Optional<AccessoryInstance> getAccessory(AccessoryType typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory().getType() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<AccessoryInstance> getAccessory(Accessory typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<Component> getOwnersName() {
        return (Optional)this.f_19804_.m_135370_(LAST_KNOWN_NAME);
    }

    public void setOwnersName(@Nullable Component comp) {
        this.setOwnersName(Optional.ofNullable(comp));
    }

    public void setOwnersName(Optional<Component> collar) {
        this.f_19804_.m_135381_(LAST_KNOWN_NAME, collar);
    }

    public EnumGender getGender() {
        return (EnumGender)((Object)this.f_19804_.m_135370_(GENDER.get()));
    }

    public void setGender(EnumGender collar) {
        this.f_19804_.m_135381_(GENDER.get(), (Object)collar);
    }

    @Override
    public EnumMode getMode() {
        return (EnumMode)((Object)this.f_19804_.m_135370_(MODE.get()));
    }

    public boolean isMode(EnumMode ... modes) {
        EnumMode mode = this.getMode();
        for (EnumMode test : modes) {
            if (mode != test) continue;
            return true;
        }
        return false;
    }

    public void setMode(EnumMode collar) {
        this.f_19804_.m_135381_(MODE.get(), (Object)collar);
    }

    public Optional<BlockPos> getBedPos() {
        return this.getBedPos((ResourceKey<Level>)this.f_19853_.m_46472_());
    }

    public Optional<BlockPos> getBedPos(ResourceKey<Level> registryKey) {
        return ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get())).getOrDefault(registryKey, Optional.empty());
    }

    public void setBedPos(@Nullable BlockPos pos) {
        this.setBedPos((ResourceKey<Level>)this.f_19853_.m_46472_(), pos);
    }

    public void setBedPos(ResourceKey<Level> registryKey, @Nullable BlockPos pos) {
        this.setBedPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBedPos(ResourceKey<Level> registryKey, Optional<BlockPos> pos) {
        this.f_19804_.m_135381_(DOG_BED_LOCATION.get(), ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get())).copy().set(registryKey, pos));
    }

    public Optional<BlockPos> getBowlPos() {
        return this.getBowlPos((ResourceKey<Level>)this.f_19853_.m_46472_());
    }

    public Optional<BlockPos> getBowlPos(ResourceKey<Level> registryKey) {
        return ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).getOrDefault(registryKey, Optional.empty());
    }

    public void setBowlPos(@Nullable BlockPos pos) {
        this.setBowlPos((ResourceKey<Level>)this.f_19853_.m_46472_(), pos);
    }

    public void setBowlPos(ResourceKey<Level> registryKey, @Nullable BlockPos pos) {
        this.setBowlPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBowlPos(ResourceKey<Level> registryKey, Optional<BlockPos> pos) {
        this.f_19804_.m_135381_(DOG_BOWL_LOCATION.get(), ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).copy().set(registryKey, pos));
    }

    @Override
    public float getMaxHunger() {
        float maxHunger = 120.0f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.getMaxHunger(this, maxHunger);
            if (!result.m_19089_().m_19080_()) continue;
            maxHunger = ((Float)result.m_19095_()).floatValue();
        }
        return maxHunger;
    }

    @Override
    public float getDogHunger() {
        return ((Float)this.f_19804_.m_135370_(HUNGER_INT)).floatValue();
    }

    @Override
    public void addHunger(float add) {
        this.setDogHunger(this.getDogHunger() + add);
    }

    @Override
    public void setDogHunger(float hunger) {
        float diff = hunger - this.getDogHunger();
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.setDogHunger(this, hunger, diff);
            if (!result.m_19089_().m_19080_()) continue;
            hunger = ((Float)result.m_19095_()).floatValue();
            diff = hunger - this.getDogHunger();
        }
        this.setHungerDirectly(Mth.m_14036_((float)hunger, (float)0.0f, (float)this.getMaxHunger()));
    }

    private void setHungerDirectly(float hunger) {
        this.f_19804_.m_135381_(HUNGER_INT, (Object)Float.valueOf(hunger));
    }

    public boolean hasCustomSkin() {
        return !Strings.isNullOrEmpty((String)this.getSkinHash());
    }

    public String getSkinHash() {
        return (String)this.f_19804_.m_135370_(CUSTOM_SKIN);
    }

    public void setSkinHash(String hash) {
        if (hash == null) {
            hash = "";
        }
        this.f_19804_.m_135381_(CUSTOM_SKIN, (Object)hash);
    }

    @Override
    public DogLevel getLevel() {
        return (DogLevel)this.f_19804_.m_135370_(DOG_LEVEL.get());
    }

    public void setLevel(DogLevel level) {
        this.f_19804_.m_135381_(DOG_LEVEL.get(), (Object)level);
    }

    @Override
    public void increaseLevel(DogLevel.Type typeIn) {
        this.getLevel().incrementLevel(typeIn);
        this.markDataParameterDirty(DOG_LEVEL.get());
    }

    @Override
    public void setDogSize(int value) {
        this.f_19804_.m_135381_(SIZE, (Object)((byte)Math.min(5, Math.max(1, value))));
    }

    @Override
    public int getDogSize() {
        return ((Byte)this.f_19804_.m_135370_(SIZE)).byteValue();
    }

    public void setBoneVariant(ItemStack stack) {
        this.f_19804_.m_135381_(BONE_VARIANT, (Object)stack);
    }

    public ItemStack getBoneVariant() {
        return (ItemStack)this.f_19804_.m_135370_(BONE_VARIANT);
    }

    @Nullable
    public IThrowableItem getThrowableItem() {
        Item item = ((ItemStack)this.f_19804_.m_135370_(BONE_VARIANT)).m_41720_();
        return item instanceof IThrowableItem ? (IThrowableItem)item : null;
    }

    public boolean hasBone() {
        return !this.getBoneVariant().m_41619_();
    }

    private boolean getDogFlag(int bit) {
        return ((Byte)this.f_19804_.m_135370_(DOG_FLAGS) & bit) != 0;
    }

    private void setDogFlag(int bits, boolean flag) {
        byte c = (Byte)this.f_19804_.m_135370_(DOG_FLAGS);
        this.f_19804_.m_135381_(DOG_FLAGS, (Object)((byte)(flag ? c | bits : c & ~bits)));
    }

    public void setBegging(boolean begging) {
        this.setDogFlag(1, begging);
    }

    public boolean isBegging() {
        return this.getDogFlag(1);
    }

    public void setWillObeyOthers(boolean obeyOthers) {
        this.setDogFlag(2, obeyOthers);
    }

    public boolean willObeyOthers() {
        return this.getDogFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setDogFlag(4, flag);
    }

    public boolean canPlayersAttack() {
        return this.getDogFlag(4);
    }

    public void set8Flag(boolean collar) {
        this.setDogFlag(8, collar);
    }

    public boolean get8Flag() {
        return this.getDogFlag(8);
    }

    public void setHasSunglasses(boolean sunglasses) {
        this.setDogFlag(16, sunglasses);
    }

    public boolean hasSunglasses() {
        return this.getDogFlag(16);
    }

    public void setLyingDown(boolean lying) {
        this.setDogFlag(32, lying);
    }

    public boolean isLyingDown() {
        return this.getDogFlag(32);
    }

    public void set64Flag(boolean lying) {
        this.setDogFlag(64, lying);
    }

    public boolean get64Flag() {
        return this.getDogFlag(64);
    }

    public List<TalentInstance> getTalentMap() {
        return (List)this.f_19804_.m_135370_(TALENTS.get());
    }

    public void setTalentMap(List<TalentInstance> map) {
        this.f_19804_.m_135381_(TALENTS.get(), map);
    }

    public InteractionResult setTalentLevel(Talent talent, int level) {
        if (0 > level || level > talent.getMaxLevel()) {
            return InteractionResult.FAIL;
        }
        List<TalentInstance> activeTalents = this.getTalentMap();
        TalentInstance inst = null;
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talent)) continue;
            inst = activeInst;
            break;
        }
        if (inst == null) {
            if (level == 0) {
                return InteractionResult.PASS;
            }
            inst = talent.getDefault(level);
            activeTalents.add(inst);
            inst.init(this);
        } else {
            int previousLevel = inst.level();
            if (previousLevel == level) {
                return InteractionResult.PASS;
            }
            inst.setLevel(level);
            inst.set(this, previousLevel);
            if (level == 0) {
                activeTalents.remove(inst);
            }
        }
        this.markDataParameterDirty(TALENTS.get());
        return InteractionResult.SUCCESS;
    }

    public <T> void markDataParameterDirty(EntityDataAccessor<T> key) {
        this.markDataParameterDirty(key, true);
    }

    public <T> void markDataParameterDirty(EntityDataAccessor<T> key, boolean notify) {
        if (notify) {
            this.m_7350_(key);
        }
        SynchedEntityData.DataItem dataentry = this.f_19804_.m_135379_(key);
        dataentry.m_135401_(true);
        this.f_19804_.f_135348_ = true;
    }

    @Override
    public void markAccessoriesDirty() {
        this.markDataParameterDirty(ACCESSORIES.get());
    }

    @Override
    public Optional<TalentInstance> getTalent(Talent talentIn) {
        List<TalentInstance> activeTalents = this.getTalentMap();
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talentIn)) continue;
            return Optional.of(activeInst);
        }
        return Optional.empty();
    }

    @Override
    public int getLevel(Talent talentIn) {
        return this.getTalent(talentIn).map(TalentInstance::level).orElse(0);
    }

    @Override
    public <T> void setData(DataKey<T> key, T value) {
        if (key.isFinal() && this.hasData(key)) {
            throw new RuntimeException("Key is final but was tried to be set again.");
        }
        this.objects.put(key.getIndex(), value);
    }

    @Override
    public <T> void setDataIfEmpty(DataKey<T> key, T value) {
        if (!this.hasData(key)) {
            this.objects.put(key.getIndex(), value);
        }
    }

    @Override
    public <T> T getData(DataKey<T> key) {
        return (T)this.objects.get(key.getIndex());
    }

    @Override
    public <T> T getDataOrGet(DataKey<T> key, Supplier<T> other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other.get();
    }

    @Override
    public <T> T getDataOrDefault(DataKey<T> key, T other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other;
    }

    @Override
    public <T> boolean hasData(DataKey<T> key) {
        return this.objects.containsKey(key.getIndex());
    }

    @Override
    public void untame() {
        this.m_7105_(false);
        this.f_21344_.m_26573_();
        this.m_21839_(false);
        this.m_21153_(8.0f);
        this.getTalentMap().clear();
        this.markDataParameterDirty(TALENTS.get());
        this.m_21816_(null);
        this.setWillObeyOthers(false);
        this.setMode(EnumMode.DOCILE);
    }

    public boolean canSpendPoints(int amount) {
        return this.getSpendablePoints() >= amount || this.getAccessory((Accessory)DoggyAccessories.GOLDEN_COLLAR.get()).isPresent();
    }

    private final int getSpendablePointsInternal() {
        int totalPoints = 15 + this.getLevel().getLevel(DogLevel.Type.NORMAL) + this.getLevel().getLevel(DogLevel.Type.DIRE);
        for (TalentInstance entry : this.getTalentMap()) {
            totalPoints -= entry.getTalent().getCummulativeCost(entry.level());
        }
        return totalPoints;
    }

    public int getSpendablePoints() {
        return this.spendablePoints.get();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public Entity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    public boolean m_5807_() {
        return this.m_6688_() instanceof LivingEntity;
    }

    public boolean m_6087_() {
        return super.m_6087_();
    }

    public boolean m_6094_() {
        return !this.m_20160_() && super.m_6094_();
    }

    public boolean m_6109_() {
        return super.m_6109_() && this.canInteract((LivingEntity)this.m_6688_());
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public void setJumpPower(int jumpPowerIn) {
        this.jumpPower = 1.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void m_7023_(Vec3 positionIn) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.m_5807_()) {
                double changeY;
                LivingEntity livingentity = (LivingEntity)this.m_6688_();
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                this.f_19793_ = 1.0f;
                float straf = livingentity.f_20900_ * 0.7f;
                float foward = livingentity.f_20902_;
                if (foward <= 0.0f) {
                    foward *= 0.5f;
                }
                if (this.jumpPower > 0.0f && !this.isDogJumping() && this.m_20096_()) {
                    double jumpValue = this.m_21051_((Attribute)DoggyAttributes.JUMP_POWER.get()).m_22135_() * (double)this.m_20098_() * (double)this.jumpPower;
                    if (this.m_21023_(MobEffects.f_19603_)) {
                        jumpValue += (double)((float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.1f);
                    }
                    Vec3 vec3d = this.m_20184_();
                    this.m_20334_(vec3d.f_82479_, jumpValue, vec3d.f_82481_);
                    this.setDogJumping(true);
                    this.f_19812_ = true;
                    if (foward > 0.0f) {
                        float amount = 0.4f;
                        float compX = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float compZ = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * compX * this.jumpPower), 0.0, (double)(0.4f * compZ * this.jumpPower)));
                    }
                    this.jumpPower = 0.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.1f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21051_(Attributes.f_22279_).m_22135_() * 0.5f);
                    super.m_7023_(new Vec3((double)straf, positionIn.f_82480_, (double)foward));
                    this.f_20903_ = 0;
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.m_20096_()) {
                    this.jumpPower = 0.0f;
                    this.setDogJumping(false);
                }
                this.f_20923_ = this.f_20924_;
                double changeX = this.m_20185_() - this.f_19854_;
                float f4 = Mth.m_14116_((float)((float)(changeX * changeX + (changeY = this.m_20189_() - this.f_19856_) * changeY))) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.f_20924_ += (f4 - this.f_20924_) * 0.4f;
                this.f_20925_ += this.f_20924_;
                if (this.m_6147_()) {
                    this.f_19789_ = 0.0f;
                }
            } else {
                this.f_19793_ = 0.5f;
                this.f_20887_ = 0.02f;
                super.m_7023_(positionIn);
            }
            this.addMovementStat(this.m_20185_() - this.f_19854_, this.m_20186_() - this.f_19855_, this.m_20189_() - this.f_19856_);
        }
    }

    public void addMovementStat(double xD, double yD, double zD) {
        int j;
        if (this.m_20160_()) {
            j = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
            this.statsTracker.increaseDistanceRidden(j);
        }
        if (!this.m_20159_()) {
            if (this.m_19941_((Tag)FluidTags.f_13131_)) {
                j = Math.round(Mth.m_14116_((float)((float)(xD * xD + yD * yD + zD * zD))) * 100.0f);
                if (j > 0) {
                    this.statsTracker.increaseDistanceOnWater(j);
                }
            } else if (this.m_20069_()) {
                int k = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (k > 0) {
                    this.statsTracker.increaseDistanceInWater(k);
                }
            } else if (this.m_20096_()) {
                int l = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (l > 0) {
                    if (this.m_20142_()) {
                        this.statsTracker.increaseDistanceSprint(l);
                    } else if (this.m_6047_()) {
                        this.statsTracker.increaseDistanceSneaking(l);
                    } else {
                        this.statsTracker.increaseDistanceWalk(l);
                    }
                }
            } else {
                int n = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
            }
        }
    }

    @Override
    public TranslatableComponent getTranslationKey(Function<EnumGender, String> function) {
        return new TranslatableComponent((String)function.apply((Object)((Boolean)ConfigHandler.SERVER.DOG_GENDER.get() != false ? this.getGender() : EnumGender.UNISEX)));
    }

    @Override
    public boolean isLying() {
        boolean onBed;
        boolean ownerSleeping;
        LivingEntity owner = this.m_142480_();
        boolean bl = ownerSleeping = owner != null && owner.m_5803_();
        if (ownerSleeping) {
            return true;
        }
        Block blockBelow = this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60734_();
        boolean bl2 = onBed = blockBelow == DoggyBlocks.DOG_BED.get() || BlockTags.f_13038_.m_8110_((Object)blockBelow);
        return onBed;
    }

    @Override
    public List<IDogFoodHandler> getFoodHandlers() {
        return this.foodHandlers;
    }

    public void setTargetBlock(BlockPos pos) {
        this.targetBlock = pos;
    }

    public BlockPos getTargetBlock() {
        return this.targetBlock;
    }
}

