/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.serializers;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AccessorySerializer
implements EntityDataSerializer<List<AccessoryInstance>> {
    public void write(FriendlyByteBuf buf, List<AccessoryInstance> value) {
        buf.writeInt(value.size());
        for (AccessoryInstance inst : value) {
            buf.writeRegistryIdUnsafe(DoggyTalentsAPI.ACCESSORIES, (IForgeRegistryEntry)inst.getAccessory());
            inst.getAccessory().write(inst, buf);
        }
    }

    public List<AccessoryInstance> read(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<AccessoryInstance> newInst = new ArrayList<AccessoryInstance>(size);
        for (int i = 0; i < size; ++i) {
            Accessory type = (Accessory)buf.readRegistryIdUnsafe(DoggyTalentsAPI.ACCESSORIES);
            newInst.add(type.createInstance(buf));
        }
        return newInst;
    }

    public List<AccessoryInstance> copy(List<AccessoryInstance> value) {
        ArrayList<AccessoryInstance> newInst = new ArrayList<AccessoryInstance>(value.size());
        for (AccessoryInstance inst : value) {
            newInst.add(inst.copy());
        }
        return newInst;
    }
}

