/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.serializers;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.util.Util;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CollarSerializer
implements EntityDataSerializer<Optional<AccessoryInstance>> {
    public void write(FriendlyByteBuf buf, Optional<AccessoryInstance> value) {
        Util.acceptOrElse(value, inst -> {
            buf.writeBoolean(true);
            buf.writeRegistryIdUnsafe(DoggyTalentsAPI.ACCESSORIES, (IForgeRegistryEntry)inst.getAccessory());
            inst.getAccessory().write((AccessoryInstance)inst, buf);
        }, () -> buf.writeBoolean(false));
    }

    public Optional<AccessoryInstance> read(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            Accessory type = (Accessory)buf.readRegistryIdUnsafe(DoggyTalentsAPI.ACCESSORIES);
            return Optional.of(type.createInstance(buf));
        }
        return Optional.empty();
    }

    public Optional<AccessoryInstance> copy(Optional<AccessoryInstance> value) {
        if (value.isPresent()) {
            return Optional.of(value.get().copy());
        }
        return Optional.empty();
    }
}

