/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.serializers;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TalentListSerializer
implements EntityDataSerializer<List<TalentInstance>> {
    public void write(FriendlyByteBuf buf, List<TalentInstance> value) {
        buf.writeInt(value.size());
        for (TalentInstance inst : value) {
            buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENTS, (IForgeRegistryEntry)inst.getTalent());
            inst.writeToBuf(buf);
        }
    }

    public List<TalentInstance> read(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<TalentInstance> newInst = new ArrayList<TalentInstance>(size);
        for (int i = 0; i < size; ++i) {
            TalentInstance inst = ((Talent)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENTS)).getDefault();
            inst.readFromBuf(buf);
            newInst.add(inst);
        }
        return newInst;
    }

    public EntityDataAccessor<List<TalentInstance>> m_135021_(int id) {
        return new EntityDataAccessor(id, (EntityDataSerializer)this);
    }

    public List<TalentInstance> copy(List<TalentInstance> value) {
        ArrayList<TalentInstance> newInst = new ArrayList<TalentInstance>(value.size());
        for (TalentInstance inst : value) {
            newInst.add(inst.copy());
        }
        return newInst;
    }
}

