/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.texture;

import com.google.common.hash.Hashing;
import doggytalents.DoggyTalents2;
import doggytalents.common.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DogTextureServer {
    public static final DogTextureServer INSTANCE = new DogTextureServer();

    public File getServerFolder() {
        return new File(ServerLifecycleHooks.getCurrentServer().m_6237_(), "dog_skins");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] getCachedBytes(File baseFolder, String hash) {
        InputStream stream = this.getCachedStream(baseFolder, hash);
        try {
            byte[] byArray = stream != null ? IOUtils.toByteArray((InputStream)stream) : null;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return null;
    }

    @Nullable
    public InputStream getCachedStream(File baseFolder, String hash) {
        File cacheFile = this.getCacheFile(baseFolder, hash);
        if (cacheFile.isFile() && cacheFile.exists()) {
            try {
                FileInputStream stream = new FileInputStream(cacheFile);
                DoggyTalents2.LOGGER.debug("Loaded dog texture from local cache ({})", (Object)cacheFile);
                return stream;
            }
            catch (FileNotFoundException e) {
                DoggyTalents2.LOGGER.debug("Failed to load dog texture from local cache ({})", (Object)cacheFile);
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getHash(byte[] targetArray) {
        return Hashing.sha1().hashBytes(targetArray).toString();
    }

    public File getCacheFile(File baseFolder, String name) {
        File subFolder = new File(baseFolder, name.length() > 2 ? name.substring(0, 2) : "xx");
        File cacheFile = new File(subFolder, name);
        return cacheFile;
    }

    public ResourceLocation getResourceLocation(String name) {
        return Util.getResource("dogskins/" + name);
    }

    public boolean saveTexture(File baseFolder, byte[] stream) throws IOException {
        String hash = this.getHash(stream);
        File cacheFile = this.getCacheFile(baseFolder, hash);
        if (!cacheFile.isFile()) {
            DoggyTalents2.LOGGER.debug("Saved dog texture to local cache ({})", (Object)cacheFile);
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])stream);
            return true;
        }
        DoggyTalents2.LOGGER.debug("Server already has cache for dog texture ({})", (Object)cacheFile);
        return false;
    }
}

