/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogInventoryPageData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class DogInventoryPagePacket
implements IPacket<DogInventoryPageData> {
    @Override
    public DogInventoryPageData decode(FriendlyByteBuf buf) {
        return new DogInventoryPageData(buf.readInt());
    }

    @Override
    public void encode(DogInventoryPageData data, FriendlyByteBuf buf) {
        buf.writeInt(data.page);
    }

    @Override
    public void handle(DogInventoryPageData data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.SERVER) {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                AbstractContainerMenu container = player.f_36096_;
                if (container instanceof DogInventoriesContainer) {
                    DogInventoriesContainer inventories = (DogInventoriesContainer)container;
                    int page = Mth.m_14045_((int)data.page, (int)0, (int)Math.max(0, inventories.getTotalNumColumns() - 9));
                    inventories.setPage(page);
                    inventories.m_7511_(0, page);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

