/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyTalents2;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogTalentData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DogTalentPacket
extends DogPacket<DogTalentData> {
    @Override
    public void encode(DogTalentData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENTS, (IForgeRegistryEntry)data.talent);
    }

    @Override
    public DogTalentData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        Talent talent = (Talent)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENTS);
        return new DogTalentData(entityId, talent);
    }

    @Override
    public void handleDog(DogEntity dogIn, DogTalentData data, Supplier<NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        if (!ConfigHandler.TALENT.getFlag(data.talent)) {
            DoggyTalents2.LOGGER.info("{} tried to level a disabled talent ({})", (Object)ctx.get().getSender().m_36316_().getName(), (Object)data.talent.getRegistryName());
            return;
        }
        int level = dogIn.getLevel(data.talent);
        if (level < data.talent.getMaxLevel() && dogIn.canSpendPoints(data.talent.getLevelCost(level + 1))) {
            dogIn.setTalentLevel(data.talent, level + 1);
        }
    }
}

