/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.addon.autumnity;

import com.google.common.collect.Lists;
import doggytalents.api.impl.CasingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.addon.Addon;
import doggytalents.common.util.Util;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AutumnityAddon
implements Addon {
    public static final String MOD_ID = "autumnity";
    public static final String[] BLOCKS = new String[]{"maple_planks"};

    public final void registerCasings(RegistryEvent.Register<ICasingMaterial> event) {
        if (!this.shouldLoad()) {
            return;
        }
        IForgeRegistry casingRegistry = event.getRegistry();
        for (String block : BLOCKS) {
            ResourceLocation rl = Util.getResource(MOD_ID, block);
            Supplier<Block> blockGet = () -> (Block)ForgeRegistries.BLOCKS.getValue(rl);
            casingRegistry.register((IForgeRegistryEntry)((ICasingMaterial)new CasingMaterial(blockGet).setRegistryName(rl)));
        }
    }

    @Override
    public void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(ICasingMaterial.class, this::registerCasings);
    }

    @Override
    public Collection<String> getMods() {
        return Lists.newArrayList((Object[])new String[]{MOD_ID});
    }

    @Override
    public String getName() {
        return "Autumnity Addon";
    }
}

