/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DoggyTags;
import doggytalents.api.feature.FoodHandler;
import doggytalents.common.entity.DogEntity;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DogBegGoal
extends Goal {
    private final DogEntity dog;
    private Player player;
    private final Level world;
    private final float minPlayerDistance;
    private int timeoutCounter;
    private final TargetingConditions playerPredicate;

    public DogBegGoal(DogEntity wolf, float minDistance) {
        this.dog = wolf;
        this.world = wolf.f_19853_;
        this.minPlayerDistance = minDistance;
        this.playerPredicate = TargetingConditions.m_148353_().m_26883_((double)minDistance);
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.player = this.world.m_45946_(this.playerPredicate, (LivingEntity)this.dog);
        return this.player == null ? false : this.hasTemptationItemInHand(this.player);
    }

    public boolean m_8045_() {
        if (!this.player.m_6084_()) {
            return false;
        }
        if (this.dog.m_20280_((Entity)this.player) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        return this.timeoutCounter > 0 && this.hasTemptationItemInHand(this.player);
    }

    public void m_8056_() {
        this.dog.setBegging(true);
        this.timeoutCounter = 40 + this.dog.m_21187_().nextInt(40);
    }

    public void m_8041_() {
        this.dog.setBegging(false);
        this.player = null;
    }

    public void m_8037_() {
        this.dog.m_21563_().m_24950_(this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_(), 10.0f, (float)this.dog.m_8132_());
        --this.timeoutCounter;
    }

    private boolean hasTemptationItemInHand(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemstack = player.m_21120_(hand);
            if ((this.dog.m_21824_() ? DoggyTags.BEG_ITEMS_TAMED : DoggyTags.BEG_ITEMS_UNTAMED).m_8110_((Object)itemstack.m_41720_())) {
                return true;
            }
            if (DoggyTags.TREATS.m_8110_((Object)itemstack.m_41720_())) {
                return true;
            }
            if (FoodHandler.isFood(itemstack).isPresent()) {
                return true;
            }
            if (!this.dog.m_6898_(itemstack)) continue;
            return true;
        }
        return false;
    }
}

