/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;

public class FindWaterGoal
extends Goal {
    private final PathfinderMob creature;
    private final PathNavigation navigator;
    private final Level world;
    private final int waterSearchRange = 12;
    private final int safeSearchRange = 6;
    @Nullable
    private BlockPos waterPos;
    private int timeToRecalcPath;

    public FindWaterGoal(PathfinderMob creatureIn) {
        this.creature = creatureIn;
        this.navigator = creatureIn.m_21573_();
        this.world = creatureIn.f_19853_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.creature.m_20096_() || this.creature.f_19797_ % 5 != 0) {
            return false;
        }
        if (this.creature.m_5825_()) {
            return false;
        }
        boolean isInFire = this.isInDangerSpot((Entity)this.creature);
        boolean isOnFire = this.creature.m_6060_();
        if (!isInFire && !isOnFire) {
            return false;
        }
        BlockPos entityPos = this.creature.m_142538_();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)entityPos.m_142082_(-this.waterSearchRange, -4, -this.waterSearchRange), (BlockPos)entityPos.m_142082_(this.waterSearchRange, 4, this.waterSearchRange))) {
            if (this.getBlockType(pos) != BlockType.WATER) continue;
            this.waterPos = pos;
            break;
        }
        boolean waterBlockNearBy = this.waterPos != null;
        return waterBlockNearBy || isInFire;
    }

    public boolean m_8045_() {
        if (this.waterPos != null) {
            BlockType safety = this.getBlockType(this.waterPos);
            if (safety != BlockType.WATER) {
                return false;
            }
            if (this.creature.m_6060_()) {
                return true;
            }
        }
        return this.isInDangerSpot((Entity)this.creature);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
    }

    public void m_8037_() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            BlockPos targetPos = null;
            if (this.waterPos != null) {
                targetPos = this.waterPos;
            } else if (!this.creature.m_21691_()) {
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int i = 0; i < 10; ++i) {
                    int j = EntityUtil.getRandomNumber((LivingEntity)this.creature, -this.safeSearchRange, this.safeSearchRange);
                    int k = EntityUtil.getRandomNumber((LivingEntity)this.creature, -4, 4);
                    int l = EntityUtil.getRandomNumber((LivingEntity)this.creature, -this.safeSearchRange, this.safeSearchRange);
                    mutablePos.m_122169_(this.creature.m_20185_() + (double)j, this.creature.m_20186_() + (double)k, this.creature.m_20189_() + (double)l);
                    boolean flag = this.getBlockType((BlockPos)mutablePos).isSafe();
                    if (!flag) continue;
                    targetPos = mutablePos;
                    break;
                }
            }
            if (targetPos != null) {
                this.navigator.m_26519_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), 1.2);
            }
        }
    }

    public void m_8041_() {
        this.navigator.m_26573_();
        this.waterPos = null;
    }

    public boolean isInDangerSpot(Entity entityIn) {
        AABB bb = entityIn.m_142469_();
        int minX = Mth.m_14107_((double)bb.f_82288_);
        int minY = Mth.m_14107_((double)bb.f_82289_);
        int minZ = Mth.m_14107_((double)bb.f_82290_);
        int maxX = Mth.m_14165_((double)bb.f_82291_);
        int maxY = Mth.m_14165_((double)bb.f_82292_);
        int maxZ = Mth.m_14165_((double)bb.f_82293_);
        for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockType safety = this.getBlockType(pos);
            if (safety != BlockType.FIRE) continue;
            return true;
        }
        return false;
    }

    public BlockType getBlockType(BlockPos posIn) {
        Material material = this.world.m_8055_(posIn).m_60767_();
        if (material == Material.f_76309_ || material == Material.f_76307_) {
            return BlockType.FIRE;
        }
        if (this.world.m_6425_(posIn).m_76153_((Tag)FluidTags.f_13131_)) {
            return BlockType.WATER;
        }
        if (this.world.m_46758_(posIn)) {
            return BlockType.WATER;
        }
        return BlockType.SAFE;
    }

    public static enum BlockType {
        SAFE,
        FIRE,
        WATER;


        public boolean isSafe() {
            return this == SAFE || this == WATER;
        }
    }
}

