/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.util.InventoryUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class PackPuppyTalent
extends TalentInstance {
    public static Capability<PackPuppyItemHandler> PACK_PUPPY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PackPuppyItemHandler>(){});
    private PackPuppyItemHandler packPuppyHandler;
    private LazyOptional<?> lazyPackPuppyHandler;
    public static Predicate<ItemEntity> SHOULD_PICKUP_ENTITY_ITEM = entity -> entity.m_6084_() && !entity.m_32063_() && !DoggyTags.PACK_PUPPY_BLACKLIST.m_8110_((Object)entity.m_32055_().m_41720_());

    public PackPuppyTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
        PackPuppyItemHandler handler;
        this.packPuppyHandler = handler = new PackPuppyItemHandler();
        this.lazyPackPuppyHandler = LazyOptional.of(() -> handler);
    }

    public PackPuppyItemHandler inventory() {
        return this.packPuppyHandler;
    }

    @Override
    public void tick(AbstractDogEntity dogIn) {
        List list;
        if (dogIn.m_6084_() && !dogIn.f_19853_.f_46443_ && this.level() >= 5 && !(list = dogIn.f_19853_.m_6443_(ItemEntity.class, dogIn.m_142469_().m_82377_(2.5, 1.0, 2.5), SHOULD_PICKUP_ENTITY_ITEM)).isEmpty()) {
            for (ItemEntity entityItem : list) {
                ItemStack remaining = InventoryUtil.addItem((IItemHandler)this.packPuppyHandler, entityItem.m_32055_());
                if (!remaining.m_41619_()) {
                    entityItem.m_32045_(remaining);
                    continue;
                }
                entityItem.m_146870_();
                dogIn.m_5496_(SoundEvents.f_12019_, 0.25f, ((dogIn.f_19853_.f_46441_.nextFloat() - dogIn.f_19853_.f_46441_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    @Override
    public InteractionResult processInteract(AbstractDogEntity dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (dogIn.m_21824_() && this.level() > 0 && playerIn.m_6144_() && stack.m_41619_() && dogIn.canInteract((LivingEntity)playerIn)) {
            if (!playerIn.f_19853_.f_46443_) {
                playerIn.m_5661_((Component)new TranslatableComponent("talent.doggytalents.pack_puppy.version_migration"), false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void set(AbstractDogEntity dog, int preLevel) {
        if (preLevel > 0 && this.level == 0) {
            this.dropInventory(dog);
        }
    }

    @Override
    public void dropInventory(AbstractDogEntity dogIn) {
        for (int i = 0; i < this.packPuppyHandler.getSlots(); ++i) {
            Containers.m_18992_((Level)dogIn.f_19853_, (double)dogIn.m_20185_(), (double)dogIn.m_20186_(), (double)dogIn.m_20189_(), (ItemStack)this.packPuppyHandler.getStackInSlot(i));
            this.packPuppyHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Override
    public void writeToNBT(AbstractDogEntity dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128391_(this.packPuppyHandler.serializeNBT());
    }

    @Override
    public void readFromNBT(AbstractDogEntity dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.packPuppyHandler.deserializeNBT(compound);
    }

    @Override
    public void onRead(AbstractDogEntity dogIn, CompoundTag compound) {
        this.packPuppyHandler.deserializeNBT(compound);
    }

    @Override
    public <T> LazyOptional<T> getCapability(AbstractDogEntity dogIn, Capability<T> cap, Direction side) {
        if (cap == PACK_PUPPY_CAPABILITY) {
            return this.lazyPackPuppyHandler;
        }
        return null;
    }

    @Override
    public void invalidateCapabilities(AbstractDogEntity dogIn) {
        this.lazyPackPuppyHandler.invalidate();
    }

    @Override
    public boolean hasRenderer() {
        return (Boolean)ConfigHandler.CLIENT.RENDER_CHEST.get();
    }

    public static boolean hasInventory(AbstractDogEntity dogIn) {
        return dogIn.m_6084_() && dogIn.getTalent((Supplier)DoggyTalents.PACK_PUPPY).isPresent();
    }
}

