/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.impl.MissingBeddingMaterial;
import doggytalents.api.impl.MissingCasingMissing;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.api.registry.Talent;
import doggytalents.common.util.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;

public class DoggyRegistries {
    public static void newRegistry(NewRegistryEvent event) {
        DoggyTalentsAPI.TALENTS = event.create(DoggyRegistries.makeRegistry(Keys.TALENTS_REGISTRY, Talent.class));
        DoggyTalentsAPI.ACCESSORIES = event.create(DoggyRegistries.makeRegistry(Keys.ACCESSORIES_REGISTRY, Accessory.class));
        DoggyTalentsAPI.ACCESSORY_TYPE = event.create(DoggyRegistries.makeRegistry(Keys.ACCESSORY_TYPE_REGISTRY, AccessoryType.class).disableSync());
        DoggyTalentsAPI.BEDDING_MATERIAL = event.create(DoggyRegistries.makeRegistry(Keys.BEDDING_REGISTRY, IBeddingMaterial.class).addCallback((Object)BeddingCallbacks.INSTANCE));
        DoggyTalentsAPI.CASING_MATERIAL = event.create(DoggyRegistries.makeRegistry(Keys.CASING_REGISTRY, ICasingMaterial.class).addCallback((Object)CasingCallbacks.INSTANCE));
    }

    private static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistry(ResourceLocation rl, Class<T> type) {
        return new RegistryBuilder().setName(rl).setType(type);
    }

    protected class Keys {
        public static final ResourceLocation TALENTS_REGISTRY = Util.getResource("talents");
        public static final ResourceLocation ACCESSORIES_REGISTRY = Util.getResource("accessories");
        public static final ResourceLocation ACCESSORY_TYPE_REGISTRY = Util.getResource("accessory_type");
        public static final ResourceLocation BEDDING_REGISTRY = Util.getResource("bedding");
        public static final ResourceLocation CASING_REGISTRY = Util.getResource("casing");

        protected Keys() {
        }
    }

    private static class BeddingCallbacks
    implements IForgeRegistry.DummyFactory<IBeddingMaterial> {
        static final BeddingCallbacks INSTANCE = new BeddingCallbacks();

        private BeddingCallbacks() {
        }

        public IBeddingMaterial createDummy(ResourceLocation key) {
            return (IBeddingMaterial)new MissingBeddingMaterial().setRegistryName(key);
        }
    }

    private static class CasingCallbacks
    implements IForgeRegistry.DummyFactory<ICasingMaterial> {
        static final CasingCallbacks INSTANCE = new CasingCallbacks();

        private CasingCallbacks() {
        }

        public ICasingMaterial createDummy(ResourceLocation key) {
            return (ICasingMaterial)new MissingCasingMissing().setRegistryName(key);
        }
    }
}

