/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyItems;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.registry.Accessory;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DogLocationData
implements IDogData {
    private final DogLocationStorage storage;
    private final UUID uuid;
    @Nullable
    private UUID ownerId;
    @Nullable
    private Vec3 position;
    @Nullable
    private ResourceKey<Level> dimension;
    @Nullable
    private Component name;
    @Nullable
    private Component ownerName;
    @Nullable
    private EnumGender gender;
    private boolean hasRadarCollar;
    private DogEntity dog;
    private LivingEntity owner;

    protected DogLocationData(DogLocationStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String getDogName() {
        return this.name == null ? "" : this.name.getString();
    }

    @Override
    public String getOwnerName() {
        return this.ownerName == null ? "" : this.ownerName.getString();
    }

    public void populate(DogEntity dogIn) {
        this.update(dogIn);
    }

    public void update(DogEntity dogIn) {
        this.ownerId = dogIn.m_142504_();
        this.position = dogIn.m_20182_();
        this.dimension = dogIn.f_19853_.m_46472_();
        this.name = dogIn.m_7755_();
        this.ownerName = dogIn.getOwnersName().orElse(null);
        this.gender = dogIn.getGender();
        this.hasRadarCollar = dogIn.getAccessory((Accessory)((Object)DoggyAccessories.RADIO_BAND.get())).isPresent();
        this.dog = dogIn;
        this.storage.m_77762_();
    }

    public void read(CompoundTag compound) {
        this.ownerId = NBTUtil.getUniqueId(compound, "ownerId");
        this.position = NBTUtil.getVector3d(compound);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)NBTUtil.getResourceLocation(compound, "dimension"));
        this.name = NBTUtil.getTextComponent(compound, "name_text_component");
        if (compound.m_128425_("gender", 8)) {
            this.gender = EnumGender.bySaveName(compound.m_128461_("gender"));
        }
        this.hasRadarCollar = compound.m_128471_("collar");
    }

    public CompoundTag write(CompoundTag compound) {
        NBTUtil.putUniqueId(compound, "ownerId", this.ownerId);
        NBTUtil.putVector3d(compound, this.position);
        NBTUtil.putResourceLocation(compound, "dimension", this.dimension.m_135782_());
        NBTUtil.putTextComponent(compound, "name_text_component", this.name);
        if (this.gender != null) {
            compound.m_128359_("gender", this.gender.getSaveName());
        }
        compound.m_128379_("collar", this.hasRadarCollar);
        return compound;
    }

    public static DogLocationData from(DogLocationStorage storageIn, DogEntity dogIn) {
        DogLocationData locationData = new DogLocationData(storageIn, dogIn.m_142081_());
        locationData.populate(dogIn);
        return locationData;
    }

    @Nullable
    public Optional<LivingEntity> getOwner(@Nullable Level worldIn) {
        if (worldIn == null) {
            return Optional.ofNullable(this.owner);
        }
        MinecraftServer server = worldIn.m_142572_();
        if (server == null) {
            throw new IllegalArgumentException("worldIn must be of ServerWorld");
        }
        for (ServerLevel world : server.m_129785_()) {
            LivingEntity possibleOwner = WorldUtil.getCachedEntity((Level)world, LivingEntity.class, this.owner, this.uuid);
            if (possibleOwner == null) continue;
            this.owner = possibleOwner;
            return Optional.of(this.owner);
        }
        this.owner = null;
        return Optional.empty();
    }

    @Nullable
    public Optional<DogEntity> getDog(@Nullable Level worldIn) {
        if (worldIn == null) {
            return Optional.ofNullable(this.dog);
        }
        MinecraftServer server = worldIn.m_142572_();
        if (server == null) {
            throw new IllegalArgumentException("worldIn must be of ServerWorld");
        }
        for (ServerLevel world : server.m_129785_()) {
            DogEntity possibleDog = WorldUtil.getCachedEntity((Level)world, DogEntity.class, this.dog, this.uuid);
            if (possibleDog == null) continue;
            this.dog = possibleDog;
            return Optional.of(this.dog);
        }
        this.dog = null;
        return Optional.empty();
    }

    public boolean shouldDisplay(Level worldIn, Player playerIn, InteractionHand handIn) {
        return this.hasRadarCollar || playerIn.m_7500_() || playerIn.m_21120_(handIn).m_41720_() == DoggyItems.CREATIVE_RADAR.get();
    }

    @Nullable
    public Component getName(@Nullable Level worldIn) {
        return this.getDog(worldIn).map(Entity::m_5446_).orElse(this.name);
    }

    @Nullable
    public Vec3 getPos(@Nullable ServerLevel worldIn) {
        return this.getDog((Level)worldIn).map(Entity::m_20182_).orElse(this.position);
    }

    @Nullable
    public Vec3 getPos() {
        return this.position;
    }

    @Nullable
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public String toString() {
        return "DogLocationData [uuid=" + this.uuid + ", owner=" + this.ownerId + ", position=" + this.position + ", dimension=" + this.dimension + ", name=" + this.name + ", gender=" + this.gender + ", hasRadarCollar=" + this.hasRadarCollar + "]";
    }
}

