/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.item.IDyeableArmorItem;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.registries.RegistryObject;

public class DoggyItemGroups {
    public static CreativeModeTab GENERAL;
    public static CreativeModeTab DOG_BED;

    public static void creativeModeTabRegisterEvent(CreativeModeTabEvent.Register event) {
        GENERAL = event.registerCreativeModeTab(Util.getResource("main"), builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.doggytalents")).m_257737_(() -> new ItemStack((ItemLike)DoggyItems.TRAINING_TREAT.get())));
        DOG_BED = event.registerCreativeModeTab(Util.getResource("dogbed"), Collections.emptyList(), List.of(GENERAL), builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.doggytalents.dogbed")).m_257737_(DogBedUtil::createRandomBed));
    }

    public static void creativeModeTabBuildEvent(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == GENERAL) {
            for (RegistryObject item : DoggyItems.ITEMS.getEntries()) {
                Object object = item.get();
                if (object instanceof IDyeableArmorItem) {
                    IDyeableArmorItem dyeableItem = (IDyeableArmorItem)object;
                    ItemStack stack = new ItemStack((ItemLike)item.get());
                    dyeableItem.m_41115_(stack, dyeableItem.getDefaultColor(stack));
                    event.m_246342_(stack);
                    continue;
                }
                event.accept((Supplier)item);
            }
            for (RegistryObject blockItem : DoggyBlocks.ITEMS.getEntries()) {
                if (blockItem.getId().m_135815_() == "dog_bed") continue;
                event.accept((Supplier)blockItem);
            }
        }
        if (event.getTab() == DOG_BED) {
            for (IBeddingMaterial beddingId : DoggyTalentsAPI.BEDDING_MATERIAL.get().getValues()) {
                for (ICasingMaterial casingId : DoggyTalentsAPI.CASING_MATERIAL.get().getValues()) {
                    event.m_246267_(DogBedUtil.createItemStack(casingId, beddingId), CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
                }
            }
        }
    }
}

