/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.serializers.AccessorySerializer;
import doggytalents.common.entity.serializers.BedLocationsSerializer;
import doggytalents.common.entity.serializers.CollarSerializer;
import doggytalents.common.entity.serializers.DimensionDependantArg;
import doggytalents.common.entity.serializers.DogLevelSerializer;
import doggytalents.common.entity.serializers.GenderSerializer;
import doggytalents.common.entity.serializers.ModeSerializer;
import doggytalents.common.entity.serializers.TalentListSerializer;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DoggySerializers {
    public static final DeferredRegister<EntityDataSerializer<?>> SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"doggytalents");
    public static final EntityDataSerializer<List<TalentInstance>> TALENT_SERIALIZER = new TalentListSerializer();
    public static final EntityDataSerializer<Optional<AccessoryInstance>> COLLAR_TYPE_SERIALIZER = new CollarSerializer();
    public static final EntityDataSerializer<List<AccessoryInstance>> ACCESSORY_SERIALIZER = new AccessorySerializer();
    public static final EntityDataSerializer<EnumGender> GENDER_SERIALIZER = new GenderSerializer();
    public static final EntityDataSerializer<EnumMode> MODE_SERIALIZER = new ModeSerializer();
    public static final EntityDataSerializer<DogLevel> DOG_LEVEL_SERIALIZER = new DogLevelSerializer();
    public static final EntityDataSerializer<DimensionDependantArg<Optional<BlockPos>>> BED_LOC_SERIALIZER = new BedLocationsSerializer<Optional<BlockPos>>();

    private static RegistryObject<EntityDataSerializer> register(String name, Supplier<EntityDataSerializer> sup) {
        return SERIALIZERS.register(name, sup);
    }

    static {
        DoggySerializers.register("talents", () -> TALENT_SERIALIZER);
        DoggySerializers.register("collar", () -> COLLAR_TYPE_SERIALIZER);
        DoggySerializers.register("accessories", () -> ACCESSORY_SERIALIZER);
        DoggySerializers.register("gender", () -> GENDER_SERIALIZER);
        DoggySerializers.register("mode", () -> MODE_SERIALIZER);
        DoggySerializers.register("dog_level", () -> DOG_LEVEL_SERIALIZER);
        DoggySerializers.register("dog_bed_location", () -> BED_LOC_SERIALIZER);
    }
}

