/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import com.mojang.brigadier.CommandDispatcher;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyAttributes;
import doggytalents.DoggyBedMaterials;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItemGroups;
import doggytalents.DoggyItems;
import doggytalents.DoggyRecipeSerializers;
import doggytalents.DoggyRegistries;
import doggytalents.DoggySerializers;
import doggytalents.DoggySounds;
import doggytalents.DoggyTalents;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.feature.InteractHandler;
import doggytalents.client.ClientSetup;
import doggytalents.client.data.DTBlockstateProvider;
import doggytalents.client.data.DTItemModelProvider;
import doggytalents.client.entity.render.world.BedFinderRenderer;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.Capabilities;
import doggytalents.common.addon.AddonManager;
import doggytalents.common.command.DogRespawnCommand;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.data.DTAdvancementProvider;
import doggytalents.common.data.DTBlockTagsProvider;
import doggytalents.common.data.DTItemTagsProvider;
import doggytalents.common.data.DTLootTableProvider;
import doggytalents.common.data.DTRecipeProvider;
import doggytalents.common.entity.HelmetInteractHandler;
import doggytalents.common.entity.MeatFoodHandler;
import doggytalents.common.event.EventHandler;
import doggytalents.common.lib.Constants;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.talent.HappyEaterTalent;
import doggytalents.common.util.BackwardsComp;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="doggytalents")
public class DoggyTalents2 {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents");
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)Constants.CHANNEL_NAME).clientAcceptedVersions(Constants.PROTOCOL_VERSION::equals).serverAcceptedVersions(Constants.PROTOCOL_VERSION::equals).networkProtocolVersion(Constants.PROTOCOL_VERSION::toString).simpleChannel();

    public DoggyTalents2() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::interModProcess);
        DoggyBlocks.BLOCKS.register(modEventBus);
        DoggyBlocks.ITEMS.register(modEventBus);
        DoggyTileEntityTypes.TILE_ENTITIES.register(modEventBus);
        DoggyItems.ITEMS.register(modEventBus);
        DoggyEntityTypes.ENTITIES.register(modEventBus);
        DoggyContainerTypes.CONTAINERS.register(modEventBus);
        DoggySerializers.SERIALIZERS.register(modEventBus);
        DoggySounds.SOUNDS.register(modEventBus);
        DoggyRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        DoggyTalents.TALENTS.register(modEventBus);
        DoggyAccessories.ACCESSORIES.register(modEventBus);
        DoggyAccessoryTypes.ACCESSORY_TYPES.register(modEventBus);
        DoggyBedMaterials.BEDDINGS.register(modEventBus);
        DoggyBedMaterials.CASINGS.register(modEventBus);
        DoggyAttributes.ATTRIBUTES.register(modEventBus);
        modEventBus.addListener(DoggyRegistries::newRegistry);
        modEventBus.addListener(DoggyEntityTypes::addEntityAttributes);
        modEventBus.addListener(DoggyItemGroups::creativeModeTabRegisterEvent);
        modEventBus.addListener(DoggyItemGroups::creativeModeTabBuildEvent);
        modEventBus.addListener(Capabilities::registerCaps);
        DogRespawnCommand.registerSerilizers(modEventBus);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::serverStarting);
        forgeEventBus.addListener(this::registerCommands);
        forgeEventBus.register((Object)new EventHandler());
        forgeEventBus.register((Object)new BackwardsComp());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(DoggyBlocks::registerBlockColours);
            modEventBus.addListener(DoggyItems::registerItemColours);
            modEventBus.addListener(ClientEventHandler::onRegisterAdditionalModel);
            modEventBus.addListener(ClientEventHandler::onModelBakeEvent);
            modEventBus.addListener(ClientSetup::setupTileEntityRenderers);
            modEventBus.addListener(ClientSetup::setupEntityRenderers);
            modEventBus.addListener(ClientSetup::addClientReloadListeners);
            modEventBus.addListener(ClientSetup::registerOverlays);
            forgeEventBus.register((Object)new ClientEventHandler());
            forgeEventBus.addListener(BedFinderRenderer::onWorldRenderLast);
        });
        ConfigHandler.init(modEventBus);
        AddonManager.init();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        FoodHandler.registerHandler(new MeatFoodHandler());
        FoodHandler.registerDynPredicate(HappyEaterTalent.INNER_DYN_PRED);
        InteractHandler.registerHandler(new HelmetInteractHandler());
        ConfigHandler.initTalentConfig();
    }

    public void serverStarting(ServerStartingEvent event) {
    }

    public void registerCommands(RegisterCommandsEvent event) {
        DogRespawnCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        ClientSetup.setupScreenManagers(event);
        ClientSetup.setupCollarRenderers(event);
    }

    protected void interModProcess(InterModProcessEvent event) {
        BackwardsComp.init();
        AddonManager.init();
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        if (event.includeClient()) {
            DTBlockstateProvider blockstates = new DTBlockstateProvider(packOutput, event.getExistingFileHelper());
            gen.addProvider(true, (DataProvider)blockstates);
            gen.addProvider(true, (DataProvider)new DTItemModelProvider(packOutput, blockstates.getExistingHelper()));
        }
        if (event.includeServer()) {
            gen.addProvider(true, (DataProvider)new DTAdvancementProvider(packOutput, event.getLookupProvider(), event.getExistingFileHelper()));
            DTBlockTagsProvider blockTagProvider = new DTBlockTagsProvider(packOutput, event.getLookupProvider(), event.getExistingFileHelper());
            gen.addProvider(true, (DataProvider)blockTagProvider);
            gen.addProvider(true, (DataProvider)new DTItemTagsProvider(packOutput, event.getLookupProvider(), (TagsProvider<Block>)blockTagProvider, event.getExistingFileHelper()));
            gen.addProvider(true, (DataProvider)new DTRecipeProvider(packOutput));
            gen.addProvider(true, (DataProvider)new DTLootTableProvider(packOutput));
        }
    }
}

